/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jpa.resolvers.strategy;

import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.jpa.javaee.JavaEEModuleInformer;
import org.jboss.jpa.resolvers.PersistenceUnitDependencyResolver;
import org.jboss.jpa.resolvers.strategy.SearchStrategy;
import org.jboss.metadata.jpa.spec.PersistenceMetaData;
import org.jboss.metadata.jpa.spec.PersistenceUnitMetaData;

public abstract class BaseSearchStrategy
implements SearchStrategy {
    private JavaEEModuleInformer javaEEModuleInformer;

    public String findPersistenceUnitSupplier(PersistenceUnitDependencyResolver resolver, DeploymentUnit deploymentUnit, String persistenceUnitName) {
        String name = this.findWithinModule(resolver, deploymentUnit, persistenceUnitName, true);
        if (name == null) {
            name = this.findWithinApplication(resolver, deploymentUnit.getTopLevel(), persistenceUnitName);
        }
        return name;
    }

    protected String findWithinApplication(PersistenceUnitDependencyResolver resolver, DeploymentUnit unit, String persistenceUnitName) {
        String name = this.findWithinModule(resolver, unit, persistenceUnitName, false);
        if (name != null) {
            return name;
        }
        for (DeploymentUnit child : unit.getChildren()) {
            name = this.findWithinApplication(resolver, child, persistenceUnitName);
            if (name == null) continue;
            return name;
        }
        return null;
    }

    protected String findWithinModule(PersistenceUnitDependencyResolver resolver, DeploymentUnit unit, String persistenceUnitName, boolean allowScoped) {
        if (!allowScoped && this.isScoped(unit)) {
            return null;
        }
        PersistenceMetaData persistenceMetaData = (PersistenceMetaData)unit.getAttachment(PersistenceMetaData.class);
        if (persistenceMetaData == null) {
            return null;
        }
        for (PersistenceUnitMetaData persistenceUnit : persistenceMetaData.getPersistenceUnits()) {
            if (persistenceUnitName != null && persistenceUnitName.length() != 0 && !persistenceUnit.getName().equals(persistenceUnitName)) continue;
            return resolver.createBeanName(unit, persistenceUnit.getName());
        }
        return null;
    }

    protected static DeploymentUnit getDeploymentUnit(DeploymentUnit current, String path) {
        if (path.startsWith("/")) {
            return BaseSearchStrategy.getDeploymentUnit(current.getTopLevel(), path.substring(1));
        }
        if (path.startsWith("./")) {
            return BaseSearchStrategy.getDeploymentUnit(current, path.substring(2));
        }
        if (path.startsWith("../")) {
            return BaseSearchStrategy.getDeploymentUnit(current.getParent(), path.substring(3));
        }
        int i = path.indexOf(47);
        String name = i == -1 ? path : path.substring(0, i);
        for (DeploymentUnit child : current.getChildren()) {
            if (!child.getSimpleName().equals(name)) continue;
            return child;
        }
        throw new IllegalArgumentException("Can't find a deployment unit named " + name + " at " + current);
    }

    private boolean isScoped(DeploymentUnit unit) {
        JavaEEModuleInformer.ModuleType type = this.javaEEModuleInformer.getModuleType(unit);
        if (type == JavaEEModuleInformer.ModuleType.APP_CLIENT) {
            return true;
        }
        if (type == JavaEEModuleInformer.ModuleType.EJB) {
            return true;
        }
        return type == JavaEEModuleInformer.ModuleType.WEB;
    }

    @Inject
    public void setJavaEEModuleInformer(JavaEEModuleInformer informer) {
        this.javaEEModuleInformer = informer;
    }
}

