/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security.jaspi;

import java.io.IOException;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.PasswordValidationCallback;
import javax.servlet.http.Cookie;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.authenticator.Constants;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.jboss.logging.Logger;
import org.jboss.security.ServerAuthenticationManager;
import org.jboss.security.auth.message.GenericMessageInfo;
import org.jboss.security.plugins.auth.JASPIServerAuthenticationManager;
import org.jboss.web.tomcat.security.jaspi.SecurityActions;
import org.jboss.web.tomcat.security.jaspi.TomcatJASPICallbackHandler;

public class TomcatJASPIAuthenticator
extends AuthenticatorBase {
    private static Logger log = Logger.getLogger(TomcatJASPIAuthenticator.class);
    private String messageLayer = "HttpServlet";
    protected String serverAuthenticationManagerClass = JASPIServerAuthenticationManager.class.getName();

    protected boolean authenticate(Request request, Response response, LoginConfig config) throws IOException {
        boolean result = false;
        String authMethod = config.getAuthMethod();
        Principal principal = request.getUserPrincipal();
        String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
        if (principal != null) {
            log.trace((Object)("Already authenticated '" + principal.getName() + "'"));
            if (ssoId != null) {
                this.associate(ssoId, request.getSessionInternal(true));
            }
            return true;
        }
        if (("BASIC".equalsIgnoreCase(authMethod) || "FORM".equalsIgnoreCase(authMethod)) && ssoId != null) {
            log.trace((Object)("SSO Id " + ssoId + " set; attempting " + "reauthentication"));
            if (this.reauthenticateFromSSO(ssoId, request)) {
                return true;
            }
        }
        GenericMessageInfo messageInfo = new GenericMessageInfo();
        messageInfo.setRequestMessage((Object)request);
        messageInfo.setResponseMessage((Object)response);
        messageInfo.getMap().put("CACHE", this.cache);
        TomcatJASPICallbackHandler cbh = new TomcatJASPICallbackHandler();
        ServerAuthenticationManager sam = this.getServerAuthenticationManager();
        if (sam != null) {
            result = sam.isValid((MessageInfo)messageInfo, new Subject(), this.messageLayer, (CallbackHandler)cbh);
        }
        if (result) {
            PasswordValidationCallback pvc = cbh.getPasswordValidationCallback();
            CallerPrincipalCallback cpcb = cbh.getCallerPrincipalCallback();
            this.register(request, response, cpcb.getPrincipal(), authMethod, pvc.getUsername(), new String(pvc.getPassword()));
        }
        return result;
    }

    public String getServerAuthenticationManagerClass() {
        return this.serverAuthenticationManagerClass;
    }

    public void setServerAuthenticationManagerClass(String serverAuthenticationManagerClass) {
        this.serverAuthenticationManagerClass = serverAuthenticationManagerClass;
    }

    protected ServerAuthenticationManager getServerAuthenticationManager() {
        ServerAuthenticationManager sam = null;
        try {
            Class<?> clazz = SecurityActions.loadClass(this.serverAuthenticationManagerClass);
            sam = (ServerAuthenticationManager)clazz.newInstance();
        }
        catch (Exception e) {
            log.error((Object)"Exception in obtaining ServerAuthenticationManager:", (Throwable)e);
        }
        return sam;
    }

    protected void register(Request request, Response response, Principal principal, String authType, String username, String password) {
        if (log.isTraceEnabled()) {
            String name = principal == null ? "none" : principal.getName();
            log.trace((Object)("Authenticated '" + name + "' with type '" + authType + "'"));
        }
        request.setAuthType(authType);
        request.setUserPrincipal(principal);
        Session session = request.getSessionInternal(false);
        if (this.cache && session != null) {
            session.setAuthType(authType);
            session.setPrincipal(principal);
            if (username != null) {
                session.setNote("org.apache.catalina.session.USERNAME", (Object)username);
            } else {
                session.removeNote("org.apache.catalina.session.USERNAME");
            }
            if (password != null) {
                session.setNote("org.apache.catalina.session.PASSWORD", (Object)password);
            } else {
                session.removeNote("org.apache.catalina.session.PASSWORD");
            }
        }
        if (this.sso == null) {
            return;
        }
        String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
        if (ssoId == null) {
            ssoId = this.generateSessionId();
            Cookie cookie = new Cookie(Constants.SINGLE_SIGN_ON_COOKIE, ssoId);
            cookie.setMaxAge(-1);
            cookie.setPath("/");
            cookie.setSecure(request.isSecure());
            String ssoDomain = this.sso.getCookieDomain();
            if (ssoDomain != null) {
                cookie.setDomain(ssoDomain);
            }
            response.addCookie(cookie);
            this.sso.register(ssoId, principal, authType, username, password);
            request.setNote("org.apache.catalina.request.SSOID", (Object)ssoId);
        } else {
            this.sso.update(ssoId, principal, authType, username, password);
        }
        if (session == null) {
            session = request.getSessionInternal(true);
        }
        this.sso.associate(ssoId, session);
    }
}

