/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered.local.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.jboss.logging.Logger;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryItemMetadata;

public class FileUtil {
    private static final Logger log = Logger.getLogger(FileUtil.class);

    public static void localMove(File source, File destination, long modifiedTime) throws IOException {
        if (!source.renameTo(destination)) {
            FileOutputStream out = new FileOutputStream(destination);
            FileInputStream in = new FileInputStream(source);
            byte[] buffer = new byte[32768];
            int bytesRead = 0;
            while (bytesRead > -1) {
                bytesRead = ((InputStream)in).read(buffer);
                if (bytesRead <= 0) continue;
                ((OutputStream)out).write(buffer, 0, bytesRead);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        destination.setLastModified(modifiedTime);
    }

    public static File getFileForItem(URI rootURI, RepositoryItemMetadata item) {
        File f = new File(rootURI);
        for (String element : item.getRelativePathElements()) {
            f = new File(f, element);
        }
        return f;
    }

    public static File createTempFile(String tmpDirName, String partitionName) throws IOException {
        if (tmpDirName == null) {
            return File.createTempFile(partitionName, "tmp");
        }
        return FileUtil.createTempFile(FileUtil.createTempDir(tmpDirName), partitionName);
    }

    public static File createTempFile(File tmpDir, String partitionName) throws IOException {
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        return File.createTempFile(partitionName, "tmp", tmpDir);
    }

    public static File createTempDir(String tmpDirName) throws IOException {
        File dir = new File(tmpDirName);
        if (!dir.exists()) {
            dir.mkdirs();
        } else if (!dir.isDirectory()) {
            throw new IllegalStateException(dir + " already exists and is not a directory");
        }
        return dir;
    }

    public static void safeCloseStream(OutputStream os, Object id) {
        try {
            os.close();
        }
        catch (IOException e) {
            log.trace((Object)("Failed to close temporary output stream for " + id), (Throwable)e);
        }
    }

    private FileUtil() {
    }
}

