/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileFactory;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;
import org.jboss.system.server.profile.repository.NoopProfile;
import org.jboss.system.server.profile.repository.metadata.EmptyProfileMetaData;
import org.jboss.system.server.profileservice.repository.AbstractProfileFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedProfileFactory
extends AbstractProfileFactory
implements ProfileFactory {
    private Map<String, AbstractProfileFactory> factories = new ConcurrentHashMap<String, AbstractProfileFactory>();
    public static final Collection<String> types = Arrays.asList(EmptyProfileMetaData.class.getName());

    public String[] getTypes() {
        return types.toArray(new String[types.size()]);
    }

    @Override
    public Profile createProfile(ProfileKey key, ProfileMetaData metaData, List<ProfileKey> subProfiles) throws Exception {
        if (key == null) {
            throw new IllegalArgumentException("Null profile key.");
        }
        if (metaData == null) {
            throw new IllegalArgumentException("Null profile meta data");
        }
        String profileType = metaData.getClass().getName();
        if (types.contains(profileType)) {
            return this.createNoopProfile(key, metaData, subProfiles);
        }
        return this.delegateCreateProfile(profileType, key, metaData, subProfiles);
    }

    protected Profile delegateCreateProfile(String type, ProfileKey key, ProfileMetaData metaData, List<ProfileKey> subProfiles) throws IllegalArgumentException, Exception {
        AbstractProfileFactory factory = this.factories.get(type);
        if (factory == null) {
            throw new IllegalArgumentException("Unrecognized meta data type: " + type);
        }
        return factory.createProfile(key, metaData, subProfiles);
    }

    protected Profile createNoopProfile(ProfileKey key, ProfileMetaData metaData, List<ProfileKey> subProfiles) {
        return new NoopProfile(key, subProfiles);
    }

    public void addProfileFactory(AbstractProfileFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Null profile factory.");
        }
        if (factory.getTypes() == null) {
            throw new IllegalArgumentException("Null factory types.");
        }
        for (String type : factory.getTypes()) {
            this.factories.put(type, factory);
        }
    }

    public void removeProfileFactory(AbstractProfileFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Null profile factory.");
        }
        if (factory.getTypes() == null) {
            throw new IllegalArgumentException("Null factory types.");
        }
        for (String type : factory.getTypes()) {
            this.factories.remove(type);
        }
    }
}

