/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.system.server.profileservice.persistence.DelegatingPersistencePlugin;
import org.jboss.system.server.profileservice.persistence.ManagedObjectPersistencePlugin;
import org.jboss.system.server.profileservice.persistence.ManagedObjectRecreationHelper;
import org.jboss.system.server.profileservice.persistence.PersistenceFactory;
import org.jboss.system.server.profileservice.persistence.component.ComponentMapper;
import org.jboss.system.server.profileservice.persistence.component.ComponentMapperRegistry;
import org.jboss.system.server.profileservice.persistence.xml.ModificationInfo;
import org.jboss.system.server.profileservice.persistence.xml.PersistedComponent;
import org.jboss.system.server.profileservice.persistence.xml.PersistenceRoot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractPersistenceFactory
extends PersistenceFactory {
    private final ComponentMapperRegistry componentMapper = ComponentMapperRegistry.getInstance();
    private final DelegatingPersistencePlugin persistencePlugin;
    private final ManagedObjectRecreationHelper recreationHelper;

    public AbstractPersistenceFactory() {
        this(ManagedObjectFactory.getInstance());
    }

    public AbstractPersistenceFactory(ManagedObjectFactory managedObjectFactory) {
        super(managedObjectFactory);
        this.recreationHelper = new ManagedObjectRecreationHelper(managedObjectFactory);
        this.persistencePlugin = new DelegatingPersistencePlugin(this.recreationHelper);
    }

    @Override
    public ManagedObjectPersistencePlugin getPersistencePlugin() {
        return this.persistencePlugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restorePersistenceRoot(PersistenceRoot root, Object parentAttachment, ClassLoader classLoader) {
        if (root == null) {
            throw new IllegalArgumentException("null root");
        }
        if (parentAttachment == null) {
            throw new IllegalArgumentException("null attachment");
        }
        if (root.getComponents() != null && !root.getComponents().isEmpty()) {
            this.recreationHelper.setLoader(classLoader);
            try {
                ComponentMapper mapper = this.getComponentMapper(root);
                for (PersistedComponent component : root.getComponents()) {
                    mapper.restoreComponent(parentAttachment, component);
                }
            }
            finally {
                this.recreationHelper.setLoader(null);
            }
        }
    }

    @Override
    public PersistenceRoot addComponent(PersistenceRoot root, ManagedObject parent, ManagedComponent component) {
        if (root == null) {
            throw new IllegalArgumentException("null persistence root");
        }
        ComponentMapper mapper = this.getComponentMapper(parent);
        PersistedComponent persistedComponent = mapper.addComponent(parent.getAttachment(), component);
        return this.addPersistedComponent(root, persistedComponent);
    }

    @Override
    public PersistenceRoot removeComponent(PersistenceRoot root, ManagedObject parent, ManagedComponent component) {
        if (root == null) {
            throw new IllegalArgumentException("null persistence root");
        }
        ComponentMapper mapper = this.getComponentMapper(parent);
        PersistedComponent persistedComponent = mapper.removeComponent(parent.getAttachment(), component);
        return this.addPersistedComponent(root, persistedComponent);
    }

    @Override
    public PersistenceRoot updateComponent(PersistenceRoot root, ManagedObject parent, ManagedComponent component) {
        if (root == null) {
            throw new IllegalArgumentException("null persistence root");
        }
        ComponentMapper mapper = this.getComponentMapper(parent);
        PersistedComponent persistedComponent = mapper.updateComponent(parent.getAttachment(), component);
        return this.addPersistedComponent(root, persistedComponent);
    }

    @Override
    public PersistenceRoot resetComponent(PersistenceRoot root, ManagedObject parent, ManagedComponent component) {
        ComponentMapper mapper = this.getComponentMapper(parent);
        PersistedComponent persistedComponent = mapper.updateComponent(parent.getAttachment(), component);
        Map<String, PersistedComponent> components = AbstractPersistenceFactory.mapComponents(root);
        PersistedComponent previous = components.remove(persistedComponent.getOriginalName());
        if (previous == null) {
            previous = components.remove(persistedComponent.getName());
        }
        root.setComponents(new ArrayList<PersistedComponent>(components.values()));
        return root;
    }

    protected PersistenceRoot addPersistedComponent(PersistenceRoot root, PersistedComponent component) {
        Map<String, PersistedComponent> components = AbstractPersistenceFactory.mapComponents(root);
        PersistedComponent previous = components.remove(component.getOriginalName());
        if (previous == null) {
            previous = components.remove(component.getName());
        }
        components.put(component.getName(), component);
        if (previous != null) {
            if (previous.getModificationInfo() == ModificationInfo.ADDED && component.getModificationInfo() == ModificationInfo.MODIFIED) {
                component.setModificationInfo(ModificationInfo.ADDED);
            }
            if (previous.getModificationInfo() == ModificationInfo.ADDED && component.getModificationInfo() == ModificationInfo.REMOVED) {
                components.remove(component.getName());
            }
            if (previous.getOriginalName() != null) {
                component.setOriginalName(previous.getOriginalName());
            }
        }
        root.setComponents(new ArrayList<PersistedComponent>(components.values()));
        return root;
    }

    protected ComponentMapper getComponentMapper(ManagedObject parent) {
        ComponentMapper mapper = null;
        if (parent.getAttachmentName() != null) {
            mapper = this.getComponentMapper(parent.getAttachmentName());
        }
        if (mapper == null && parent.getAttachment() != null) {
            mapper = this.getComponentMapper(parent.getAttachment().getClass().getName());
        }
        if (mapper == null) {
            throw new IllegalStateException("no mapper registered for type: " + parent.getAttachmentName());
        }
        return mapper;
    }

    protected ComponentMapper getComponentMapper(PersistenceRoot root) {
        ComponentMapper mapper = null;
        if (root.getName() != null) {
            mapper = this.getComponentMapper(root.getName());
        }
        if (root.getClassName() != null) {
            mapper = this.getComponentMapper(root.getClassName());
        }
        if (mapper == null) {
            throw new IllegalStateException("no mapper registered for type: " + root);
        }
        return mapper;
    }

    protected ComponentMapper getComponentMapper(String type) {
        if (type == null) {
            throw new IllegalArgumentException("null type");
        }
        return this.componentMapper.getMapper(type);
    }

    protected static Map<String, PersistedComponent> mapComponents(PersistenceRoot root) {
        HashMap<String, PersistedComponent> map = new HashMap<String, PersistedComponent>();
        if (root.getComponents() != null && !root.getComponents().isEmpty()) {
            for (PersistedComponent component : root.getComponents()) {
                map.put(component.getName(), component);
            }
        }
        return map;
    }

    public void addComponentMapper(ComponentMapper mapper) {
        this.componentMapper.addMapper(mapper);
    }

    public ComponentMapper removeComponentMapper(ComponentMapper mapper) {
        return this.componentMapper.removeComponentMapper(mapper);
    }

    public void addPersistencePlugin(ManagedObjectPersistencePlugin plugin) {
        this.persistencePlugin.addPlugin(plugin);
    }

    public void removePersistencePlugin(ManagedObjectPersistencePlugin plugin) {
        this.persistencePlugin.removePlugin(plugin);
    }
}

