/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractProfileDeployment
implements ProfileDeployment {
    private String name;
    private VirtualFile root;
    private Map<String, Object> attachments = new ConcurrentHashMap<String, Object>();
    private static final long serialVersionUID = -2600392045205267112L;

    static final String safeVirtualFileName(VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        try {
            return root.toURI().toString();
        }
        catch (Exception e) {
            return root.getName();
        }
    }

    public AbstractProfileDeployment(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name.");
        }
        this.name = name;
    }

    public AbstractProfileDeployment(VirtualFile root) {
        this(AbstractProfileDeployment.safeVirtualFileName(root));
        this.root = root;
    }

    public String getName() {
        return this.name;
    }

    public VirtualFile getRoot() {
        return this.root;
    }

    public Object getAttachment(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null attachment name.");
        }
        return this.attachments.get(name);
    }

    public Object addAttachment(String name, Object attachment) {
        if (name == null) {
            throw new IllegalArgumentException("Null attachment name.");
        }
        if (attachment == null) {
            throw new IllegalArgumentException("Null attachment.");
        }
        return this.attachments.put(name, attachment);
    }

    public Map<String, Object> getAttachments() {
        return Collections.unmodifiableMap(this.attachments);
    }

    public String toString() {
        return "AbstractProfileDeployment(" + this.root != null ? this.root.getName() : this.name + ")";
    }
}

