/*     */ package org.slf4j;
/*     */ 
/*     */ import org.slf4j.helpers.Util;
/*     */ import org.slf4j.impl.StaticMDCBinder;
/*     */ import org.slf4j.spi.MDCAdapter;
/*     */ 
/*     */ public class MDC
/*     */ {
/*     */   static final String NULL_MDCA_URL = "http://www.slf4j.org/codes.html#null_MDCA";
/*     */   static final String NO_STATIC_MDC_BINDER_URL = "http://www.slf4j.org/codes.html#no_static_mdc_binder";
/*     */   static MDCAdapter mdcAdapter;
/*     */ 
/*     */   public static void put(String key, String val)
/*     */     throws IllegalArgumentException
/*     */   {
/*  99 */     if (key == null) {
/* 100 */       throw new IllegalArgumentException("key parameter cannot be null");
/*     */     }
/* 102 */     if (mdcAdapter == null) {
/* 103 */       throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
/*     */     }
/*     */ 
/* 106 */     mdcAdapter.put(key, val);
/*     */   }
/*     */ 
/*     */   public static String get(String key)
/*     */     throws IllegalArgumentException
/*     */   {
/* 119 */     if (key == null) {
/* 120 */       throw new IllegalArgumentException("key parameter cannot be null");
/*     */     }
/*     */ 
/* 123 */     if (mdcAdapter == null) {
/* 124 */       throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
/*     */     }
/*     */ 
/* 127 */     return mdcAdapter.get(key);
/*     */   }
/*     */ 
/*     */   public static void remove(String key)
/*     */     throws IllegalArgumentException
/*     */   {
/* 139 */     if (key == null) {
/* 140 */       throw new IllegalArgumentException("key parameter cannot be null");
/*     */     }
/*     */ 
/* 143 */     if (mdcAdapter == null) {
/* 144 */       throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
/*     */     }
/*     */ 
/* 147 */     mdcAdapter.remove(key);
/*     */   }
/*     */ 
/*     */   public static void clear()
/*     */   {
/* 154 */     if (mdcAdapter == null) {
/* 155 */       throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
/*     */     }
/*     */ 
/* 158 */     mdcAdapter.clear();
/*     */   }
/*     */ 
/*     */   public static MDCAdapter getMDCAdapter()
/*     */   {
/* 168 */     return mdcAdapter;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  69 */       mdcAdapter = StaticMDCBinder.SINGLETON.getMDCA();
/*     */     } catch (NoClassDefFoundError ncde) {
/*  71 */       String msg = ncde.getMessage();
/*  72 */       if ((msg != null) && (msg.indexOf("org/slf4j/impl/StaticMDCBinder") != -1)) {
/*  73 */         Util.reportFailure("Failed to load class \"org.slf4j.impl.StaticMDCBinder\".");
/*     */ 
/*  75 */         Util.reportFailure("See http://www.slf4j.org/codes.html#no_static_mdc_binder for further details.");
/*     */       }
/*     */ 
/*  79 */       throw ncde;
/*     */     }
/*     */     catch (Exception e) {
/*  82 */       Util.reportFailure("Could not bind with an instance of class [" + StaticMDCBinder.SINGLETON.getMDCAdapterClassStr() + "]", e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.slf4j.MDC
 * JD-Core Version:    0.6.0
 */