/*     */ package org.quartz.plugins.xml;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.URL;
/*     */ import java.net.URLDecoder;
/*     */ import java.util.Date;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.quartz.JobDataMap;
/*     */ import org.quartz.JobDetail;
/*     */ import org.quartz.Scheduler;
/*     */ import org.quartz.SchedulerContext;
/*     */ import org.quartz.SchedulerException;
/*     */ import org.quartz.SimpleTrigger;
/*     */ import org.quartz.jobs.FileScanJob;
/*     */ import org.quartz.jobs.FileScanListener;
/*     */ import org.quartz.simpl.CascadingClassLoadHelper;
/*     */ import org.quartz.spi.ClassLoadHelper;
/*     */ import org.quartz.spi.SchedulerPlugin;
/*     */ import org.quartz.xml.JobSchedulingDataProcessor;
/*     */ 
/*     */ public class JobInitializationPlugin
/*     */   implements SchedulerPlugin, FileScanListener
/*     */ {
/*     */   private String name;
/*     */   private Scheduler scheduler;
/*  67 */   private boolean overWriteExistingJobs = false;
/*     */ 
/*  69 */   private boolean failOnFileNotFound = true;
/*     */ 
/*  71 */   private boolean fileFound = false;
/*     */ 
/*  73 */   private String fileName = "quartz_jobs.xml";
/*     */ 
/*  75 */   private String filePath = null;
/*     */ 
/*  77 */   private boolean useContextClassLoader = true;
/*     */ 
/*  79 */   private boolean validating = false;
/*     */ 
/*  81 */   private boolean validatingSchema = true;
/*     */ 
/*  83 */   private long scanInterval = 0L;
/*     */ 
/*  85 */   boolean initializing = true;
/*     */ 
/*  87 */   boolean started = false;
/*     */ 
/*  89 */   protected ClassLoadHelper classLoadHelper = null;
/*     */ 
/*     */   public String getFileName()
/*     */   {
/* 117 */     return this.fileName;
/*     */   }
/*     */ 
/*     */   public void setFileName(String fileName)
/*     */   {
/* 126 */     this.fileName = fileName;
/*     */   }
/*     */ 
/*     */   public boolean isOverWriteExistingJobs()
/*     */   {
/* 136 */     return this.overWriteExistingJobs;
/*     */   }
/*     */ 
/*     */   public void setOverWriteExistingJobs(boolean overWriteExistingJobs)
/*     */   {
/* 146 */     this.overWriteExistingJobs = overWriteExistingJobs;
/*     */   }
/*     */ 
/*     */   public long getScanInterval()
/*     */   {
/* 157 */     return this.scanInterval / 1000L;
/*     */   }
/*     */ 
/*     */   public void setScanInterval(long scanInterval)
/*     */   {
/* 168 */     this.scanInterval = (scanInterval * 1000L);
/*     */   }
/*     */ 
/*     */   public boolean isFailOnFileNotFound()
/*     */   {
/* 178 */     return this.failOnFileNotFound;
/*     */   }
/*     */ 
/*     */   public void setFailOnFileNotFound(boolean failOnFileNotFound)
/*     */   {
/* 188 */     this.failOnFileNotFound = failOnFileNotFound;
/*     */   }
/*     */ 
/*     */   public boolean isUseContextClassLoader()
/*     */   {
/* 197 */     return this.useContextClassLoader;
/*     */   }
/*     */ 
/*     */   public void setUseContextClassLoader(boolean useContextClassLoader)
/*     */   {
/* 206 */     this.useContextClassLoader = useContextClassLoader;
/*     */   }
/*     */ 
/*     */   public boolean isValidating()
/*     */   {
/* 215 */     return this.validating;
/*     */   }
/*     */ 
/*     */   public void setValidating(boolean validating)
/*     */   {
/* 224 */     this.validating = validating;
/*     */   }
/*     */ 
/*     */   public boolean isValidatingSchema()
/*     */   {
/* 233 */     return this.validatingSchema;
/*     */   }
/*     */ 
/*     */   public void setValidatingSchema(boolean validatingSchema)
/*     */   {
/* 242 */     this.validatingSchema = validatingSchema;
/*     */   }
/*     */ 
/*     */   protected static Log getLog() {
/* 246 */     return LogFactory.getLog(JobInitializationPlugin.class);
/*     */   }
/*     */ 
/*     */   public void initialize(String name, Scheduler scheduler)
/*     */     throws SchedulerException
/*     */   {
/* 269 */     this.initializing = true;
/*     */ 
/* 271 */     this.classLoadHelper = new CascadingClassLoadHelper();
/* 272 */     this.classLoadHelper.initialize();
/*     */     try
/*     */     {
/* 275 */       this.name = name;
/* 276 */       this.scheduler = scheduler;
/*     */ 
/* 278 */       getLog().info("Registering Quartz Job Initialization Plug-in.");
/*     */ 
/* 280 */       findFile();
/*     */     }
/*     */     finally {
/* 283 */       this.initializing = false;
/*     */     }
/*     */   }
/*     */ 
/*     */   private String getFilePath() throws SchedulerException {
/* 288 */     if (this.filePath == null) {
/* 289 */       findFile();
/*     */     }
/* 291 */     return this.filePath;
/*     */   }
/*     */ 
/*     */   private void findFile()
/*     */     throws SchedulerException
/*     */   {
/* 298 */     InputStream f = null;
/* 299 */     String furl = null;
/*     */ 
/* 301 */     File file = new File(getFileName());
/*     */ 
/* 303 */     if (!file.exists()) {
/* 304 */       URL url = this.classLoadHelper.getResource(getFileName());
/* 305 */       if (url != null)
/*     */       {
/* 312 */         furl = URLDecoder.decode(url.getPath());
/* 313 */         file = new File(furl);
/*     */         try {
/* 315 */           f = url.openStream();
/*     */         }
/*     */         catch (IOException ignor) {
/*     */         }
/*     */       }
/*     */     }
/*     */     else {
/*     */       try {
/* 323 */         f = new FileInputStream(file);
/*     */       }
/*     */       catch (FileNotFoundException e)
/*     */       {
/*     */       }
/*     */     }
/* 329 */     if ((f == null) && (isFailOnFileNotFound())) {
/* 330 */       throw new SchedulerException("File named '" + getFileName() + "' does not exist.");
/*     */     }
/* 332 */     if (f == null) {
/* 333 */       getLog().warn("File named '" + getFileName() + "' does not exist.");
/*     */     } else {
/* 335 */       this.fileFound = true;
/*     */       try {
/* 337 */         if (furl != null)
/* 338 */           this.filePath = furl;
/*     */         else
/* 340 */           this.filePath = file.getAbsolutePath();
/* 341 */         f.close();
/*     */       } catch (IOException ioe) {
/* 343 */         getLog().warn("Error closing jobs file " + getFileName(), ioe);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/* 350 */     if (this.scanInterval > 0L) {
/*     */       try {
/* 352 */         SimpleTrigger trig = new SimpleTrigger("JobInitializationPlugin_" + this.name, "JobInitializationPlugin", new Date(), null, SimpleTrigger.REPEAT_INDEFINITELY, this.scanInterval);
/*     */ 
/* 357 */         trig.setVolatility(true);
/* 358 */         JobDetail job = new JobDetail("JobInitializationPlugin_" + this.name, "JobInitializationPlugin", FileScanJob.class);
/*     */ 
/* 362 */         job.setVolatility(true);
/* 363 */         job.getJobDataMap().put(FileScanJob.FILE_NAME, getFilePath());
/* 364 */         job.getJobDataMap().put(FileScanJob.FILE_SCAN_LISTENER_NAME, "JobInitializationPlugin_" + this.name);
/*     */ 
/* 366 */         this.scheduler.getContext().put("JobInitializationPlugin_" + this.name, this);
/* 367 */         this.scheduler.scheduleJob(job, trig);
/*     */       }
/*     */       catch (SchedulerException se) {
/* 370 */         getLog().error("Error starting background-task for watching jobs file.", se);
/*     */       }
/*     */     }
/*     */     try
/*     */     {
/* 375 */       processFile();
/*     */     }
/*     */     finally {
/* 378 */       this.started = true;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void shutdown()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void processFile()
/*     */   {
/* 395 */     if (!this.fileFound) return;
/*     */ 
/* 397 */     JobSchedulingDataProcessor processor = new JobSchedulingDataProcessor(isUseContextClassLoader(), isValidating(), isValidatingSchema());
/*     */     try
/*     */     {
/* 401 */       processor.processFileAndScheduleJobs(this.fileName, this.scheduler, isOverWriteExistingJobs());
/*     */     } catch (Exception e) {
/* 403 */       getLog().error("Error scheduling jobs: " + e.getMessage(), e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void fileUpdated(String fileName)
/*     */   {
/* 411 */     if (this.started)
/* 412 */       processFile();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.plugins.xml.JobInitializationPlugin
 * JD-Core Version:    0.6.0
 */