/*     */ package org.quartz.jobs;
/*     */ 
/*     */ import java.io.File;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.quartz.JobDataMap;
/*     */ import org.quartz.JobDetail;
/*     */ import org.quartz.JobExecutionContext;
/*     */ import org.quartz.JobExecutionException;
/*     */ import org.quartz.Scheduler;
/*     */ import org.quartz.SchedulerContext;
/*     */ import org.quartz.SchedulerException;
/*     */ import org.quartz.StatefulJob;
/*     */ 
/*     */ public class FileScanJob
/*     */   implements StatefulJob
/*     */ {
/*  47 */   public static String FILE_NAME = "FILE_NAME";
/*  48 */   public static String FILE_SCAN_LISTENER_NAME = "FILE_SCAN_LISTENER_NAME";
/*  49 */   private static String LAST_MODIFIED_TIME = "LAST_MODIFIED_TIME";
/*     */ 
/*     */   public void execute(JobExecutionContext context)
/*     */     throws JobExecutionException
/*     */   {
/*  59 */     Log log = LogFactory.getLog(getClass());
/*     */ 
/*  61 */     JobDataMap data = context.getJobDetail().getJobDataMap();
/*  62 */     SchedulerContext schedCtxt = null;
/*     */     try {
/*  64 */       schedCtxt = context.getScheduler().getContext();
/*     */     } catch (SchedulerException e) {
/*  66 */       throw new JobExecutionException("Error obtaining scheduler context.", e, false);
/*     */     }
/*     */ 
/*  69 */     String fileName = data.getString(FILE_NAME);
/*  70 */     String listenerName = data.getString(FILE_SCAN_LISTENER_NAME);
/*     */ 
/*  72 */     if (fileName == null) {
/*  73 */       throw new JobExecutionException("Required parameter '" + FILE_NAME + "' not found in JobDataMap");
/*     */     }
/*  75 */     if (listenerName == null) {
/*  76 */       throw new JobExecutionException("Required parameter '" + FILE_SCAN_LISTENER_NAME + "' not found in JobDataMap");
/*     */     }
/*     */ 
/*  79 */     FileScanListener listener = (FileScanListener)schedCtxt.get(listenerName);
/*     */ 
/*  81 */     if (listener == null) {
/*  82 */       throw new JobExecutionException("FileScanListener named '" + listenerName + "' not found in SchedulerContext");
/*     */     }
/*     */ 
/*  85 */     long lastDate = -1L;
/*  86 */     if (data.containsKey(LAST_MODIFIED_TIME)) {
/*  87 */       lastDate = data.getLong(LAST_MODIFIED_TIME);
/*     */     }
/*  89 */     long newDate = getLastModifiedDate(fileName);
/*     */ 
/*  91 */     if (newDate < 0L) {
/*  92 */       log.warn("File '" + fileName + "' does not exist.");
/*  93 */       return;
/*     */     }
/*     */ 
/*  96 */     if ((lastDate > 0L) && (newDate != lastDate))
/*     */     {
/*  98 */       log.info("File '" + fileName + "' updated, notifying listener.");
/*  99 */       listener.fileUpdated(fileName);
/*     */     }
/*     */     else {
/* 102 */       log.debug("File '" + fileName + "' unchanged.");
/*     */     }
/* 104 */     data.put(LAST_MODIFIED_TIME, newDate);
/*     */   }
/*     */ 
/*     */   protected long getLastModifiedDate(String fileName)
/*     */   {
/* 109 */     File file = new File(fileName);
/*     */ 
/* 111 */     if (!file.exists()) {
/* 112 */       return -1L;
/*     */     }
/*     */ 
/* 115 */     return file.lastModified();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.jobs.FileScanJob
 * JD-Core Version:    0.6.0
 */