/*     */ package org.quartz.impl.jdbcjobstore;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.math.BigDecimal;
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Date;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.quartz.Calendar;
/*     */ import org.quartz.CronTrigger;
/*     */ import org.quartz.JobDetail;
/*     */ import org.quartz.SimpleTrigger;
/*     */ import org.quartz.Trigger;
/*     */ 
/*     */ public class PointbaseDelegate extends StdJDBCDelegate
/*     */ {
/*     */   public PointbaseDelegate(Log logger, String tablePrefix, String instanceId)
/*     */   {
/*  63 */     super(logger, tablePrefix, instanceId);
/*     */   }
/*     */ 
/*     */   public PointbaseDelegate(Log logger, String tablePrefix, String instanceId, Boolean useProperties)
/*     */   {
/*  78 */     super(logger, tablePrefix, instanceId, useProperties);
/*     */   }
/*     */ 
/*     */   public int insertJobDetail(Connection conn, JobDetail job)
/*     */     throws IOException, SQLException
/*     */   {
/* 101 */     ByteArrayOutputStream baos = serializeJobData(job.getJobDataMap());
/* 102 */     int len = baos.toByteArray().length;
/* 103 */     ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
/*     */ 
/* 105 */     PreparedStatement ps = null;
/*     */ 
/* 107 */     int insertResult = 0;
/*     */     try
/*     */     {
/* 110 */       ps = conn.prepareStatement(rtp("INSERT INTO {0}JOB_DETAILS (JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_VOLATILE, IS_STATEFUL, REQUESTS_RECOVERY, JOB_DATA)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)"));
/* 111 */       ps.setString(1, job.getName());
/* 112 */       ps.setString(2, job.getGroup());
/* 113 */       ps.setString(3, job.getDescription());
/* 114 */       ps.setString(4, job.getJobClass().getName());
/* 115 */       ps.setBoolean(5, job.isDurable());
/* 116 */       ps.setBoolean(6, job.isVolatile());
/* 117 */       ps.setBoolean(7, job.isStateful());
/* 118 */       ps.setBoolean(8, job.requestsRecovery());
/* 119 */       ps.setBinaryStream(9, bais, len);
/*     */ 
/* 121 */       insertResult = ps.executeUpdate();
/*     */     } finally {
/* 123 */       if (null != ps)
/*     */         try {
/* 125 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore)
/*     */         {
/*     */         }
/*     */     }
/* 131 */     if (insertResult > 0) {
/* 132 */       String[] jobListeners = job.getJobListenerNames();
/* 133 */       for (int i = 0; (jobListeners != null) && (i < jobListeners.length); i++) {
/* 134 */         insertJobListener(conn, job, jobListeners[i]);
/*     */       }
/*     */     }
/* 137 */     return insertResult;
/*     */   }
/*     */ 
/*     */   public int updateJobDetail(Connection conn, JobDetail job)
/*     */     throws IOException, SQLException
/*     */   {
/* 156 */     ByteArrayOutputStream baos = serializeJobData(job.getJobDataMap());
/* 157 */     int len = baos.toByteArray().length;
/* 158 */     ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
/*     */ 
/* 160 */     PreparedStatement ps = null;
/*     */ 
/* 162 */     int insertResult = 0;
/*     */     try
/*     */     {
/* 165 */       ps = conn.prepareStatement(rtp("UPDATE {0}JOB_DETAILS SET DESCRIPTION = ?, JOB_CLASS_NAME = ?, IS_DURABLE = ?, IS_VOLATILE = ?, IS_STATEFUL = ?, REQUESTS_RECOVERY = ?, JOB_DATA = ?  WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
/* 166 */       ps.setString(1, job.getDescription());
/* 167 */       ps.setString(2, job.getJobClass().getName());
/* 168 */       ps.setBoolean(3, job.isDurable());
/* 169 */       ps.setBoolean(4, job.isVolatile());
/* 170 */       ps.setBoolean(5, job.isStateful());
/* 171 */       ps.setBoolean(6, job.requestsRecovery());
/* 172 */       ps.setBinaryStream(7, bais, len);
/* 173 */       ps.setString(8, job.getName());
/* 174 */       ps.setString(9, job.getGroup());
/*     */ 
/* 176 */       insertResult = ps.executeUpdate();
/*     */     } finally {
/* 178 */       if (null != ps)
/*     */         try {
/* 180 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore)
/*     */         {
/*     */         }
/*     */     }
/* 186 */     if (insertResult > 0) {
/* 187 */       deleteJobListeners(conn, job.getName(), job.getGroup());
/*     */ 
/* 189 */       String[] jobListeners = job.getJobListenerNames();
/* 190 */       for (int i = 0; (jobListeners != null) && (i < jobListeners.length); i++) {
/* 191 */         insertJobListener(conn, job, jobListeners[i]);
/*     */       }
/*     */     }
/* 194 */     return insertResult;
/*     */   }
/*     */ 
/*     */   public int insertTrigger(Connection conn, Trigger trigger, String state, JobDetail jobDetail)
/*     */     throws SQLException, IOException
/*     */   {
/* 200 */     ByteArrayOutputStream baos = serializeJobData(trigger.getJobDataMap());
/* 201 */     int len = baos.toByteArray().length;
/* 202 */     ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
/*     */ 
/* 204 */     PreparedStatement ps = null;
/*     */ 
/* 206 */     int insertResult = 0;
/*     */     try
/*     */     {
/* 209 */       ps = conn.prepareStatement(rtp("INSERT INTO {0}TRIGGERS (TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP, IS_VOLATILE, DESCRIPTION, NEXT_FIRE_TIME, PREV_FIRE_TIME, TRIGGER_STATE, TRIGGER_TYPE, START_TIME, END_TIME, CALENDAR_NAME, MISFIRE_INSTR, JOB_DATA)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"));
/* 210 */       ps.setString(1, trigger.getName());
/* 211 */       ps.setString(2, trigger.getGroup());
/* 212 */       ps.setString(3, trigger.getJobName());
/* 213 */       ps.setString(4, trigger.getJobGroup());
/* 214 */       ps.setBoolean(5, trigger.isVolatile());
/* 215 */       ps.setString(6, trigger.getDescription());
/* 216 */       ps.setBigDecimal(7, new BigDecimal(String.valueOf(trigger.getNextFireTime().getTime())));
/*     */ 
/* 218 */       long prevFireTime = -1L;
/* 219 */       if (trigger.getPreviousFireTime() != null) {
/* 220 */         prevFireTime = trigger.getPreviousFireTime().getTime();
/*     */       }
/* 222 */       ps.setBigDecimal(8, new BigDecimal(String.valueOf(prevFireTime)));
/* 223 */       ps.setString(9, state);
/* 224 */       if ((trigger instanceof SimpleTrigger))
/* 225 */         ps.setString(10, "SIMPLE");
/* 226 */       else if ((trigger instanceof CronTrigger))
/* 227 */         ps.setString(10, "CRON");
/*     */       else {
/* 229 */         ps.setString(10, "BLOB");
/*     */       }
/* 231 */       ps.setBigDecimal(11, new BigDecimal(String.valueOf(trigger.getStartTime().getTime())));
/*     */ 
/* 233 */       long endTime = 0L;
/* 234 */       if (trigger.getEndTime() != null) {
/* 235 */         endTime = trigger.getEndTime().getTime();
/*     */       }
/* 237 */       ps.setBigDecimal(12, new BigDecimal(String.valueOf(endTime)));
/* 238 */       ps.setString(13, trigger.getCalendarName());
/* 239 */       ps.setInt(14, trigger.getMisfireInstruction());
/* 240 */       ps.setBinaryStream(15, bais, len);
/*     */ 
/* 242 */       insertResult = ps.executeUpdate();
/*     */     } finally {
/* 244 */       if (null != ps)
/*     */         try {
/* 246 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore)
/*     */         {
/*     */         }
/*     */     }
/* 252 */     if (insertResult > 0) {
/* 253 */       String[] trigListeners = trigger.getTriggerListenerNames();
/* 254 */       for (int i = 0; (trigListeners != null) && (i < trigListeners.length); i++) {
/* 255 */         insertTriggerListener(conn, trigger, trigListeners[i]);
/*     */       }
/*     */     }
/* 258 */     return insertResult;
/*     */   }
/*     */ 
/*     */   public int updateTrigger(Connection conn, Trigger trigger, String state, JobDetail jobDetail)
/*     */     throws SQLException, IOException
/*     */   {
/* 264 */     ByteArrayOutputStream baos = serializeJobData(trigger.getJobDataMap());
/* 265 */     int len = baos.toByteArray().length;
/* 266 */     ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
/*     */ 
/* 268 */     PreparedStatement ps = null;
/*     */ 
/* 270 */     int insertResult = 0;
/*     */     try
/*     */     {
/* 274 */       ps = conn.prepareStatement(rtp("UPDATE {0}TRIGGERS SET JOB_NAME = ?, JOB_GROUP = ?, IS_VOLATILE = ?, DESCRIPTION = ?, NEXT_FIRE_TIME = ?, PREV_FIRE_TIME = ?, TRIGGER_STATE = ?, TRIGGER_TYPE = ?, START_TIME = ?, END_TIME = ?, CALENDAR_NAME = ?, MISFIRE_INSTR = ?, JOB_DATA = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
/*     */ 
/* 276 */       ps.setString(1, trigger.getJobName());
/* 277 */       ps.setString(2, trigger.getJobGroup());
/* 278 */       ps.setBoolean(3, trigger.isVolatile());
/* 279 */       ps.setString(4, trigger.getDescription());
/* 280 */       long nextFireTime = -1L;
/* 281 */       if (trigger.getNextFireTime() != null) {
/* 282 */         nextFireTime = trigger.getNextFireTime().getTime();
/*     */       }
/* 284 */       ps.setBigDecimal(5, new BigDecimal(String.valueOf(nextFireTime)));
/* 285 */       long prevFireTime = -1L;
/* 286 */       if (trigger.getPreviousFireTime() != null) {
/* 287 */         prevFireTime = trigger.getPreviousFireTime().getTime();
/*     */       }
/* 289 */       ps.setBigDecimal(6, new BigDecimal(String.valueOf(prevFireTime)));
/* 290 */       ps.setString(7, state);
/* 291 */       if ((trigger instanceof SimpleTrigger))
/*     */       {
/* 293 */         ps.setString(8, "SIMPLE");
/* 294 */       } else if ((trigger instanceof CronTrigger))
/*     */       {
/* 296 */         ps.setString(8, "CRON");
/*     */       }
/*     */       else {
/* 299 */         ps.setString(8, "BLOB");
/*     */       }
/* 301 */       ps.setBigDecimal(9, new BigDecimal(String.valueOf(trigger.getStartTime().getTime())));
/*     */ 
/* 303 */       long endTime = 0L;
/* 304 */       if (trigger.getEndTime() != null) {
/* 305 */         endTime = trigger.getEndTime().getTime();
/*     */       }
/* 307 */       ps.setBigDecimal(10, new BigDecimal(String.valueOf(endTime)));
/* 308 */       ps.setString(11, trigger.getCalendarName());
/* 309 */       ps.setInt(12, trigger.getMisfireInstruction());
/* 310 */       ps.setBinaryStream(13, bais, len);
/* 311 */       ps.setString(14, trigger.getName());
/* 312 */       ps.setString(15, trigger.getGroup());
/*     */ 
/* 314 */       insertResult = ps.executeUpdate();
/*     */     } finally {
/* 316 */       if (null != ps)
/*     */         try {
/* 318 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore)
/*     */         {
/*     */         }
/*     */     }
/* 324 */     if (insertResult > 0) {
/* 325 */       deleteTriggerListeners(conn, trigger.getName(), trigger.getGroup());
/*     */ 
/* 327 */       String[] trigListeners = trigger.getTriggerListenerNames();
/* 328 */       for (int i = 0; (trigListeners != null) && (i < trigListeners.length); i++) {
/* 329 */         insertTriggerListener(conn, trigger, trigListeners[i]);
/*     */       }
/*     */     }
/* 332 */     return insertResult;
/*     */   }
/*     */ 
/*     */   public int updateJobData(Connection conn, JobDetail job)
/*     */     throws IOException, SQLException
/*     */   {
/* 349 */     ByteArrayOutputStream baos = serializeJobData(job.getJobDataMap());
/* 350 */     int len = baos.toByteArray().length;
/* 351 */     ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
/* 352 */     PreparedStatement ps = null;
/*     */     try
/*     */     {
/* 355 */       ps = conn.prepareStatement(rtp("UPDATE {0}JOB_DETAILS SET JOB_DATA = ?  WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
/* 356 */       ps.setBinaryStream(1, bais, len);
/* 357 */       ps.setString(2, job.getName());
/* 358 */       ps.setString(3, job.getGroup());
/*     */ 
/* 360 */       i = ps.executeUpdate();
/*     */     }
/*     */     finally
/*     */     {
/*     */       int i;
/* 362 */       if (null != ps)
/*     */         try {
/* 364 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore)
/*     */         {
/*     */         }
/*     */     }
/*     */   }
/*     */ 
/*     */   public int insertCalendar(Connection conn, String calendarName, Calendar calendar)
/*     */     throws IOException, SQLException
/*     */   {
/* 398 */     ByteArrayOutputStream baos = serializeObject(calendar);
/* 399 */     byte[] buf = baos.toByteArray();
/* 400 */     ByteArrayInputStream bais = new ByteArrayInputStream(buf);
/*     */ 
/* 402 */     PreparedStatement ps = null;
/*     */     try
/*     */     {
/* 405 */       ps = conn.prepareStatement(rtp("INSERT INTO {0}CALENDARS (CALENDAR_NAME, CALENDAR)  VALUES(?, ?)"));
/* 406 */       ps.setString(1, calendarName);
/* 407 */       ps.setBinaryStream(2, bais, buf.length);
/*     */ 
/* 409 */       i = ps.executeUpdate();
/*     */     }
/*     */     finally
/*     */     {
/*     */       int i;
/* 411 */       if (null != ps)
/*     */         try {
/* 413 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore)
/*     */         {
/*     */         }
/*     */     }
/*     */   }
/*     */ 
/*     */   public int updateCalendar(Connection conn, String calendarName, Calendar calendar)
/*     */     throws IOException, SQLException
/*     */   {
/* 438 */     ByteArrayOutputStream baos = serializeObject(calendar);
/* 439 */     byte[] buf = baos.toByteArray();
/* 440 */     ByteArrayInputStream bais = new ByteArrayInputStream(buf);
/*     */ 
/* 442 */     PreparedStatement ps = null;
/*     */     try
/*     */     {
/* 445 */       ps = conn.prepareStatement(rtp("UPDATE {0}CALENDARS SET CALENDAR = ?  WHERE CALENDAR_NAME = ?"));
/* 446 */       ps.setBinaryStream(1, bais, buf.length);
/* 447 */       ps.setString(2, calendarName);
/*     */ 
/* 449 */       i = ps.executeUpdate();
/*     */     }
/*     */     finally
/*     */     {
/*     */       int i;
/* 451 */       if (null != ps)
/*     */         try {
/* 453 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore)
/*     */         {
/*     */         }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Object getObjectFromBlob(ResultSet rs, String colName)
/*     */     throws ClassNotFoundException, IOException, SQLException
/*     */   {
/* 484 */     Object obj = null;
/*     */ 
/* 486 */     byte[] binaryData = rs.getBytes(colName);
/*     */ 
/* 488 */     InputStream binaryInput = new ByteArrayInputStream(binaryData);
/*     */ 
/* 490 */     if (null != binaryInput) {
/* 491 */       ObjectInputStream in = new ObjectInputStream(binaryInput);
/* 492 */       obj = in.readObject();
/* 493 */       in.close();
/*     */     }
/*     */ 
/* 496 */     return obj;
/*     */   }
/*     */ 
/*     */   protected Object getJobDetailFromBlob(ResultSet rs, String colName)
/*     */     throws ClassNotFoundException, IOException, SQLException
/*     */   {
/* 519 */     if (canUseProperties()) {
/* 520 */       byte[] data = rs.getBytes(colName);
/* 521 */       if (data == null)
/* 522 */         return null;
/* 523 */       InputStream binaryInput = new ByteArrayInputStream(data);
/* 524 */       return binaryInput;
/*     */     }
/*     */ 
/* 527 */     return getObjectFromBlob(rs, colName);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.impl.jdbcjobstore.PointbaseDelegate
 * JD-Core Version:    0.6.0
 */