/*     */ package org.quartz.impl.calendar;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Date;
/*     */ 
/*     */ public class WeeklyCalendar extends BaseCalendar
/*     */   implements org.quartz.Calendar, Serializable
/*     */ {
/*  47 */   private boolean[] excludeDays = new boolean[8];
/*     */ 
/*  50 */   private boolean excludeAll = false;
/*     */ 
/*     */   public WeeklyCalendar()
/*     */   {
/*  59 */     init();
/*     */   }
/*     */ 
/*     */   public WeeklyCalendar(org.quartz.Calendar baseCalendar)
/*     */   {
/*  68 */     super(baseCalendar);
/*  69 */     init();
/*     */   }
/*     */ 
/*     */   private void init()
/*     */   {
/*  78 */     this.excludeDays[1] = true;
/*  79 */     this.excludeDays[7] = true;
/*  80 */     this.excludeAll = areAllDaysExcluded();
/*     */   }
/*     */ 
/*     */   public boolean[] getDaysExcluded()
/*     */   {
/*  89 */     return this.excludeDays;
/*     */   }
/*     */ 
/*     */   public boolean isDayExcluded(int wday)
/*     */   {
/*  99 */     return this.excludeDays[wday];
/*     */   }
/*     */ 
/*     */   public void setDaysExcluded(boolean[] weekDays)
/*     */   {
/* 110 */     if (weekDays == null) return;
/*     */ 
/* 112 */     this.excludeDays = weekDays;
/* 113 */     this.excludeAll = areAllDaysExcluded();
/*     */   }
/*     */ 
/*     */   public void setDayExcluded(int wday, boolean exclude)
/*     */   {
/* 124 */     this.excludeDays[wday] = exclude;
/* 125 */     this.excludeAll = areAllDaysExcluded();
/*     */   }
/*     */ 
/*     */   public boolean areAllDaysExcluded()
/*     */   {
/* 136 */     if (!isDayExcluded(1)) return false;
/*     */ 
/* 138 */     if (!isDayExcluded(2)) return false;
/*     */ 
/* 140 */     if (!isDayExcluded(3)) return false;
/*     */ 
/* 142 */     if (!isDayExcluded(4)) return false;
/*     */ 
/* 144 */     if (!isDayExcluded(5)) return false;
/*     */ 
/* 146 */     if (!isDayExcluded(6)) return false;
/*     */ 
/* 148 */     return isDayExcluded(7);
/*     */   }
/*     */ 
/*     */   public boolean isTimeIncluded(long timeStamp)
/*     */   {
/* 164 */     if (this.excludeAll == true) return false;
/*     */ 
/* 168 */     if (!super.isTimeIncluded(timeStamp)) return false;
/*     */ 
/* 170 */     java.util.Calendar cl = java.util.Calendar.getInstance();
/* 171 */     cl.setTime(new Date(timeStamp));
/* 172 */     int wday = cl.get(7);
/*     */ 
/* 174 */     return !isDayExcluded(wday);
/*     */   }
/*     */ 
/*     */   public long getNextIncludedTime(long timeStamp)
/*     */   {
/* 189 */     if (this.excludeAll == true) return 0L;
/*     */ 
/* 192 */     long baseTime = super.getNextIncludedTime(timeStamp);
/* 193 */     if ((baseTime > 0L) && (baseTime > timeStamp)) timeStamp = baseTime;
/*     */ 
/* 196 */     long newTimeStamp = buildHoliday(timeStamp);
/*     */ 
/* 198 */     java.util.Calendar cl = getJavaCalendar(newTimeStamp);
/* 199 */     int wday = cl.get(7);
/*     */ 
/* 201 */     if (!isDayExcluded(wday)) return timeStamp;
/*     */ 
/* 204 */     while (isDayExcluded(wday) == true) {
/* 205 */       cl.add(5, 1);
/* 206 */       wday = cl.get(7);
/*     */     }
/*     */ 
/* 209 */     return cl.getTime().getTime();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.impl.calendar.WeeklyCalendar
 * JD-Core Version:    0.6.0
 */