/*     */ package org.quartz.impl;
/*     */ 
/*     */ import java.util.Date;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import org.quartz.Calendar;
/*     */ import org.quartz.JobDataMap;
/*     */ import org.quartz.JobDetail;
/*     */ import org.quartz.JobListener;
/*     */ import org.quartz.Scheduler;
/*     */ import org.quartz.SchedulerContext;
/*     */ import org.quartz.SchedulerException;
/*     */ import org.quartz.SchedulerListener;
/*     */ import org.quartz.SchedulerMetaData;
/*     */ import org.quartz.Trigger;
/*     */ import org.quartz.TriggerListener;
/*     */ import org.quartz.UnableToInterruptJobException;
/*     */ import org.quartz.core.QuartzScheduler;
/*     */ import org.quartz.core.SchedulingContext;
/*     */ import org.quartz.spi.JobFactory;
/*     */ 
/*     */ public class StdScheduler
/*     */   implements Scheduler
/*     */ {
/*     */   private QuartzScheduler sched;
/*     */   private SchedulingContext schedCtxt;
/*     */ 
/*     */   public StdScheduler(QuartzScheduler sched, SchedulingContext schedCtxt)
/*     */   {
/*  85 */     this.sched = sched;
/*  86 */     this.schedCtxt = schedCtxt;
/*     */   }
/*     */ 
/*     */   public String getSchedulerName()
/*     */   {
/* 103 */     return this.sched.getSchedulerName();
/*     */   }
/*     */ 
/*     */   public String getSchedulerInstanceId()
/*     */   {
/* 112 */     return this.sched.getSchedulerInstanceId();
/*     */   }
/*     */ 
/*     */   public SchedulerMetaData getMetaData() {
/* 116 */     return new SchedulerMetaData(getSchedulerName(), getSchedulerInstanceId(), getClass(), false, this.sched.runningSince() != null, isPaused(), isShutdown(), this.sched.runningSince(), this.sched.numJobsExecuted(), this.sched.getJobStoreClass(), this.sched.supportsPersistence(), this.sched.getThreadPoolClass(), this.sched.getThreadPoolSize(), this.sched.getVersion());
/*     */   }
/*     */ 
/*     */   public SchedulerContext getContext()
/*     */     throws SchedulerException
/*     */   {
/* 132 */     return this.sched.getSchedulerContext();
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws SchedulerException
/*     */   {
/* 147 */     this.sched.start();
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public void pause()
/*     */   {
/* 159 */     standby();
/*     */   }
/*     */ 
/*     */   public void standby()
/*     */   {
/* 168 */     this.sched.standby();
/*     */   }
/*     */ 
/*     */   public boolean isInStandbyMode()
/*     */   {
/* 177 */     return this.sched.isInStandbyMode();
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public boolean isPaused()
/*     */   {
/* 184 */     return isInStandbyMode();
/*     */   }
/*     */ 
/*     */   public void shutdown()
/*     */   {
/* 193 */     this.sched.shutdown();
/*     */   }
/*     */ 
/*     */   public void shutdown(boolean waitForJobsToComplete)
/*     */   {
/* 202 */     this.sched.shutdown(waitForJobsToComplete);
/*     */   }
/*     */ 
/*     */   public boolean isShutdown()
/*     */   {
/* 211 */     return this.sched.isShutdown();
/*     */   }
/*     */ 
/*     */   public List getCurrentlyExecutingJobs()
/*     */   {
/* 220 */     return this.sched.getCurrentlyExecutingJobs();
/*     */   }
/*     */ 
/*     */   public Date scheduleJob(JobDetail jobDetail, Trigger trigger)
/*     */     throws SchedulerException
/*     */   {
/* 238 */     return this.sched.scheduleJob(this.schedCtxt, jobDetail, trigger);
/*     */   }
/*     */ 
/*     */   public Date scheduleJob(Trigger trigger)
/*     */     throws SchedulerException
/*     */   {
/* 249 */     return this.sched.scheduleJob(this.schedCtxt, trigger);
/*     */   }
/*     */ 
/*     */   public void addJob(JobDetail jobDetail, boolean replace)
/*     */     throws SchedulerException
/*     */   {
/* 261 */     this.sched.addJob(this.schedCtxt, jobDetail, replace);
/*     */   }
/*     */ 
/*     */   public boolean deleteJob(String jobName, String groupName)
/*     */     throws SchedulerException
/*     */   {
/* 273 */     return this.sched.deleteJob(this.schedCtxt, jobName, groupName);
/*     */   }
/*     */ 
/*     */   public boolean unscheduleJob(String triggerName, String groupName)
/*     */     throws SchedulerException
/*     */   {
/* 285 */     return this.sched.unscheduleJob(this.schedCtxt, triggerName, groupName);
/*     */   }
/*     */ 
/*     */   public Date rescheduleJob(String triggerName, String groupName, Trigger newTrigger)
/*     */     throws SchedulerException
/*     */   {
/* 297 */     return this.sched.rescheduleJob(this.schedCtxt, triggerName, groupName, newTrigger);
/*     */   }
/*     */ 
/*     */   public void triggerJob(String jobName, String groupName)
/*     */     throws SchedulerException
/*     */   {
/* 309 */     triggerJob(jobName, groupName, null);
/*     */   }
/*     */ 
/*     */   public void triggerJob(String jobName, String groupName, JobDataMap data)
/*     */     throws SchedulerException
/*     */   {
/* 321 */     this.sched.triggerJob(this.schedCtxt, jobName, groupName, data);
/*     */   }
/*     */ 
/*     */   public void triggerJobWithVolatileTrigger(String jobName, String groupName)
/*     */     throws SchedulerException
/*     */   {
/* 333 */     triggerJobWithVolatileTrigger(jobName, groupName, null);
/*     */   }
/*     */ 
/*     */   public void triggerJobWithVolatileTrigger(String jobName, String groupName, JobDataMap data)
/*     */     throws SchedulerException
/*     */   {
/* 345 */     this.sched.triggerJobWithVolatileTrigger(this.schedCtxt, jobName, groupName, data);
/*     */   }
/*     */ 
/*     */   public void pauseTrigger(String triggerName, String groupName)
/*     */     throws SchedulerException
/*     */   {
/* 357 */     this.sched.pauseTrigger(this.schedCtxt, triggerName, groupName);
/*     */   }
/*     */ 
/*     */   public void pauseTriggerGroup(String groupName)
/*     */     throws SchedulerException
/*     */   {
/* 368 */     this.sched.pauseTriggerGroup(this.schedCtxt, groupName);
/*     */   }
/*     */ 
/*     */   public void pauseJob(String jobName, String groupName)
/*     */     throws SchedulerException
/*     */   {
/* 380 */     this.sched.pauseJob(this.schedCtxt, jobName, groupName);
/*     */   }
/*     */ 
/*     */   public Set getPausedTriggerGroups()
/*     */     throws SchedulerException
/*     */   {
/* 387 */     return this.sched.getPausedTriggerGroups(this.schedCtxt);
/*     */   }
/*     */ 
/*     */   public void pauseJobGroup(String groupName)
/*     */     throws SchedulerException
/*     */   {
/* 398 */     this.sched.pauseJobGroup(this.schedCtxt, groupName);
/*     */   }
/*     */ 
/*     */   public void resumeTrigger(String triggerName, String groupName)
/*     */     throws SchedulerException
/*     */   {
/* 410 */     this.sched.resumeTrigger(this.schedCtxt, triggerName, groupName);
/*     */   }
/*     */ 
/*     */   public void resumeTriggerGroup(String groupName)
/*     */     throws SchedulerException
/*     */   {
/* 421 */     this.sched.resumeTriggerGroup(this.schedCtxt, groupName);
/*     */   }
/*     */ 
/*     */   public void resumeJob(String jobName, String groupName)
/*     */     throws SchedulerException
/*     */   {
/* 433 */     this.sched.resumeJob(this.schedCtxt, jobName, groupName);
/*     */   }
/*     */ 
/*     */   public void resumeJobGroup(String groupName)
/*     */     throws SchedulerException
/*     */   {
/* 444 */     this.sched.resumeJobGroup(this.schedCtxt, groupName);
/*     */   }
/*     */ 
/*     */   public void pauseAll()
/*     */     throws SchedulerException
/*     */   {
/* 455 */     this.sched.pauseAll(this.schedCtxt);
/*     */   }
/*     */ 
/*     */   public void resumeAll()
/*     */     throws SchedulerException
/*     */   {
/* 466 */     this.sched.resumeAll(this.schedCtxt);
/*     */   }
/*     */ 
/*     */   public String[] getJobGroupNames()
/*     */     throws SchedulerException
/*     */   {
/* 477 */     return this.sched.getJobGroupNames(this.schedCtxt);
/*     */   }
/*     */ 
/*     */   public Trigger[] getTriggersOfJob(String jobName, String groupName)
/*     */     throws SchedulerException
/*     */   {
/* 489 */     return this.sched.getTriggersOfJob(this.schedCtxt, jobName, groupName);
/*     */   }
/*     */ 
/*     */   public String[] getJobNames(String groupName)
/*     */     throws SchedulerException
/*     */   {
/* 500 */     return this.sched.getJobNames(this.schedCtxt, groupName);
/*     */   }
/*     */ 
/*     */   public String[] getTriggerGroupNames()
/*     */     throws SchedulerException
/*     */   {
/* 511 */     return this.sched.getTriggerGroupNames(this.schedCtxt);
/*     */   }
/*     */ 
/*     */   public String[] getTriggerNames(String groupName)
/*     */     throws SchedulerException
/*     */   {
/* 522 */     return this.sched.getTriggerNames(this.schedCtxt, groupName);
/*     */   }
/*     */ 
/*     */   public JobDetail getJobDetail(String jobName, String jobGroup)
/*     */     throws SchedulerException
/*     */   {
/* 534 */     return this.sched.getJobDetail(this.schedCtxt, jobName, jobGroup);
/*     */   }
/*     */ 
/*     */   public Trigger getTrigger(String triggerName, String triggerGroup)
/*     */     throws SchedulerException
/*     */   {
/* 546 */     return this.sched.getTrigger(this.schedCtxt, triggerName, triggerGroup);
/*     */   }
/*     */ 
/*     */   public int getTriggerState(String triggerName, String triggerGroup)
/*     */     throws SchedulerException
/*     */   {
/* 558 */     return this.sched.getTriggerState(this.schedCtxt, triggerName, triggerGroup);
/*     */   }
/*     */ 
/*     */   public void addCalendar(String calName, Calendar calendar, boolean replace, boolean updateTriggers)
/*     */     throws SchedulerException
/*     */   {
/* 570 */     this.sched.addCalendar(this.schedCtxt, calName, calendar, replace, updateTriggers);
/*     */   }
/*     */ 
/*     */   public boolean deleteCalendar(String calName)
/*     */     throws SchedulerException
/*     */   {
/* 581 */     return this.sched.deleteCalendar(this.schedCtxt, calName);
/*     */   }
/*     */ 
/*     */   public Calendar getCalendar(String calName)
/*     */     throws SchedulerException
/*     */   {
/* 592 */     return this.sched.getCalendar(this.schedCtxt, calName);
/*     */   }
/*     */ 
/*     */   public String[] getCalendarNames()
/*     */     throws SchedulerException
/*     */   {
/* 603 */     return this.sched.getCalendarNames(this.schedCtxt);
/*     */   }
/*     */ 
/*     */   public void addGlobalJobListener(JobListener jobListener)
/*     */   {
/* 618 */     this.sched.addGlobalJobListener(jobListener);
/*     */   }
/*     */ 
/*     */   public void addJobListener(JobListener jobListener)
/*     */   {
/* 627 */     this.sched.addJobListener(jobListener);
/*     */   }
/*     */ 
/*     */   public boolean removeGlobalJobListener(JobListener jobListener)
/*     */   {
/* 636 */     return this.sched.removeGlobalJobListener(jobListener);
/*     */   }
/*     */ 
/*     */   public boolean removeJobListener(String name)
/*     */   {
/* 645 */     return this.sched.removeJobListener(name);
/*     */   }
/*     */ 
/*     */   public List getGlobalJobListeners()
/*     */   {
/* 654 */     return this.sched.getGlobalJobListeners();
/*     */   }
/*     */ 
/*     */   public Set getJobListenerNames()
/*     */   {
/* 663 */     return this.sched.getJobListenerNames();
/*     */   }
/*     */ 
/*     */   public JobListener getJobListener(String name)
/*     */   {
/* 672 */     return this.sched.getJobListener(name);
/*     */   }
/*     */ 
/*     */   public void addGlobalTriggerListener(TriggerListener triggerListener)
/*     */   {
/* 681 */     this.sched.addGlobalTriggerListener(triggerListener);
/*     */   }
/*     */ 
/*     */   public void addTriggerListener(TriggerListener triggerListener)
/*     */   {
/* 690 */     this.sched.addTriggerListener(triggerListener);
/*     */   }
/*     */ 
/*     */   public boolean removeGlobalTriggerListener(TriggerListener triggerListener)
/*     */   {
/* 699 */     return this.sched.removeGlobalTriggerListener(triggerListener);
/*     */   }
/*     */ 
/*     */   public boolean removeTriggerListener(String name)
/*     */   {
/* 708 */     return this.sched.removeTriggerListener(name);
/*     */   }
/*     */ 
/*     */   public List getGlobalTriggerListeners()
/*     */   {
/* 717 */     return this.sched.getGlobalTriggerListeners();
/*     */   }
/*     */ 
/*     */   public Set getTriggerListenerNames()
/*     */   {
/* 726 */     return this.sched.getTriggerListenerNames();
/*     */   }
/*     */ 
/*     */   public TriggerListener getTriggerListener(String name)
/*     */   {
/* 735 */     return this.sched.getTriggerListener(name);
/*     */   }
/*     */ 
/*     */   public void addSchedulerListener(SchedulerListener schedulerListener)
/*     */   {
/* 744 */     this.sched.addSchedulerListener(schedulerListener);
/*     */   }
/*     */ 
/*     */   public boolean removeSchedulerListener(SchedulerListener schedulerListener)
/*     */   {
/* 753 */     return this.sched.removeSchedulerListener(schedulerListener);
/*     */   }
/*     */ 
/*     */   public List getSchedulerListeners()
/*     */   {
/* 762 */     return this.sched.getSchedulerListeners();
/*     */   }
/*     */ 
/*     */   public boolean interrupt(String jobName, String groupName) throws UnableToInterruptJobException {
/* 766 */     return this.sched.interrupt(this.schedCtxt, jobName, groupName);
/*     */   }
/*     */ 
/*     */   public void setJobFactory(JobFactory factory)
/*     */     throws SchedulerException
/*     */   {
/* 773 */     this.sched.setJobFactory(factory);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.impl.StdScheduler
 * JD-Core Version:    0.6.0
 */