/*     */ package org.quartz.core;
/*     */ 
/*     */ import org.quartz.spi.JobStore;
/*     */ import org.quartz.spi.ThreadPool;
/*     */ 
/*     */ public class QuartzSchedulerResources
/*     */ {
/*     */   public static final String CREATE_REGISTRY_NEVER = "never";
/*     */   public static final String CREATE_REGISTRY_ALWAYS = "always";
/*     */   public static final String CREATE_REGISTRY_AS_NEEDED = "as_needed";
/*     */   private String name;
/*     */   private String instanceId;
/*     */   private String threadName;
/*  59 */   private String rmiRegistryHost = null;
/*     */ 
/*  61 */   private int rmiRegistryPort = 1099;
/*     */ 
/*  63 */   private int rmiServerPort = -1;
/*     */ 
/*  65 */   private String rmiCreateRegistryStrategy = "never";
/*     */   private ThreadPool threadPool;
/*     */   private JobStore jobStore;
/*     */   private JobRunShellFactory jobRunShellFactory;
/*     */ 
/*     */   public String getName()
/*     */   {
/* 104 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/* 116 */     if ((name == null) || (name.trim().length() == 0)) {
/* 117 */       throw new IllegalArgumentException("Scheduler name cannot be empty.");
/*     */     }
/*     */ 
/* 120 */     this.name = name;
/*     */ 
/* 122 */     if (this.threadName == null)
/*     */     {
/* 124 */       setThreadName(name + "_QuartzSchedulerThread");
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getInstanceId()
/*     */   {
/* 134 */     return this.instanceId;
/*     */   }
/*     */ 
/*     */   public void setInstanceId(String instanceId)
/*     */   {
/* 146 */     if ((instanceId == null) || (instanceId.trim().length() == 0)) {
/* 147 */       throw new IllegalArgumentException("Scheduler instanceId cannot be empty.");
/*     */     }
/*     */ 
/* 150 */     this.instanceId = instanceId;
/*     */   }
/*     */ 
/*     */   public static String getUniqueIdentifier(String schedName, String schedInstId)
/*     */   {
/* 155 */     return schedName + "_$_" + schedInstId;
/*     */   }
/*     */ 
/*     */   public String getUniqueIdentifier() {
/* 159 */     return getUniqueIdentifier(this.name, this.instanceId);
/*     */   }
/*     */ 
/*     */   public String getRMIRegistryHost()
/*     */   {
/* 169 */     return this.rmiRegistryHost;
/*     */   }
/*     */ 
/*     */   public void setRMIRegistryHost(String hostName)
/*     */   {
/* 179 */     this.rmiRegistryHost = hostName;
/*     */   }
/*     */ 
/*     */   public int getRMIRegistryPort()
/*     */   {
/* 189 */     return this.rmiRegistryPort;
/*     */   }
/*     */ 
/*     */   public void setRMIRegistryPort(int port)
/*     */   {
/* 199 */     this.rmiRegistryPort = port;
/*     */   }
/*     */ 
/*     */   public int getRMIServerPort()
/*     */   {
/* 209 */     return this.rmiServerPort;
/*     */   }
/*     */ 
/*     */   public void setRMIServerPort(int port)
/*     */   {
/* 218 */     this.rmiServerPort = port;
/*     */   }
/*     */ 
/*     */   public String getRMICreateRegistryStrategy()
/*     */   {
/* 228 */     return this.rmiCreateRegistryStrategy;
/*     */   }
/*     */ 
/*     */   public String getThreadName()
/*     */   {
/* 237 */     return this.threadName;
/*     */   }
/*     */ 
/*     */   public void setThreadName(String threadName)
/*     */   {
/* 249 */     if ((threadName == null) || (threadName.trim().length() == 0)) {
/* 250 */       throw new IllegalArgumentException("Scheduler thread name cannot be empty.");
/*     */     }
/*     */ 
/* 253 */     this.threadName = threadName;
/*     */   }
/*     */ 
/*     */   public void setRMICreateRegistryStrategy(String rmiCreateRegistryStrategy)
/*     */   {
/* 266 */     if ((rmiCreateRegistryStrategy == null) || (rmiCreateRegistryStrategy.trim().length() == 0))
/* 267 */       rmiCreateRegistryStrategy = "never";
/* 268 */     else if (rmiCreateRegistryStrategy.equalsIgnoreCase("true")) rmiCreateRegistryStrategy = "as_needed";
/* 269 */     else if (rmiCreateRegistryStrategy.equalsIgnoreCase("false")) rmiCreateRegistryStrategy = "never";
/* 270 */     else if (rmiCreateRegistryStrategy.equalsIgnoreCase("always"))
/* 271 */       rmiCreateRegistryStrategy = "always";
/* 272 */     else if (rmiCreateRegistryStrategy.equalsIgnoreCase("as_needed"))
/* 273 */       rmiCreateRegistryStrategy = "as_needed";
/* 274 */     else if (rmiCreateRegistryStrategy.equalsIgnoreCase("never"))
/* 275 */       rmiCreateRegistryStrategy = "never";
/*     */     else {
/* 277 */       throw new IllegalArgumentException("Faild to set RMICreateRegistryStrategy - strategy unknown: '" + rmiCreateRegistryStrategy + "'");
/*     */     }
/*     */ 
/* 281 */     this.rmiCreateRegistryStrategy = rmiCreateRegistryStrategy;
/*     */   }
/*     */ 
/*     */   public ThreadPool getThreadPool()
/*     */   {
/* 291 */     return this.threadPool;
/*     */   }
/*     */ 
/*     */   public void setThreadPool(ThreadPool threadPool)
/*     */   {
/* 304 */     if (threadPool == null) {
/* 305 */       throw new IllegalArgumentException("ThreadPool cannot be null.");
/*     */     }
/* 307 */     this.threadPool = threadPool;
/*     */   }
/*     */ 
/*     */   public JobStore getJobStore()
/*     */   {
/* 317 */     return this.jobStore;
/*     */   }
/*     */ 
/*     */   public void setJobStore(JobStore jobStore)
/*     */   {
/* 330 */     if (jobStore == null) {
/* 331 */       throw new IllegalArgumentException("JobStore cannot be null.");
/*     */     }
/* 333 */     this.jobStore = jobStore;
/*     */   }
/*     */ 
/*     */   public JobRunShellFactory getJobRunShellFactory()
/*     */   {
/* 343 */     return this.jobRunShellFactory;
/*     */   }
/*     */ 
/*     */   public void setJobRunShellFactory(JobRunShellFactory jobRunShellFactory)
/*     */   {
/* 356 */     if (jobRunShellFactory == null) {
/* 357 */       throw new IllegalArgumentException("JobRunShellFactory cannot be null.");
/*     */     }
/*     */ 
/* 360 */     this.jobRunShellFactory = jobRunShellFactory;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.core.QuartzSchedulerResources
 * JD-Core Version:    0.6.0
 */