/*     */ package org.quartz;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Date;
/*     */ import java.util.LinkedList;
/*     */ 
/*     */ public abstract class Trigger
/*     */   implements Serializable, Cloneable, Comparable
/*     */ {
/*     */   private static final long serialVersionUID = -3904243490805975570L;
/*     */   public static final int INSTRUCTION_NOOP = 0;
/*     */   public static final int INSTRUCTION_RE_EXECUTE_JOB = 1;
/*     */   public static final int INSTRUCTION_SET_TRIGGER_COMPLETE = 2;
/*     */   public static final int INSTRUCTION_DELETE_TRIGGER = 3;
/*     */   public static final int INSTRUCTION_SET_ALL_JOB_TRIGGERS_COMPLETE = 4;
/*     */   public static final int INSTRUCTION_SET_TRIGGER_ERROR = 5;
/*     */   public static final int INSTRUCTION_SET_ALL_JOB_TRIGGERS_ERROR = 6;
/*     */   public static final int MISFIRE_INSTRUCTION_SMART_POLICY = 0;
/*     */   public static final int STATE_NORMAL = 0;
/*     */   public static final int STATE_PAUSED = 1;
/*     */   public static final int STATE_COMPLETE = 2;
/*     */   public static final int STATE_ERROR = 3;
/*     */   public static final int STATE_BLOCKED = 4;
/*     */   public static final int STATE_NONE = -1;
/*     */   private String name;
/* 226 */   private String group = "DEFAULT";
/*     */   private String jobName;
/* 230 */   private String jobGroup = "DEFAULT";
/*     */   private String description;
/*     */   private JobDataMap jobDataMap;
/* 236 */   private boolean volatility = false;
/*     */ 
/* 238 */   private String calendarName = null;
/*     */ 
/* 240 */   private String fireInstanceId = null;
/*     */ 
/* 242 */   private int misfireInstruction = 0;
/*     */ 
/* 244 */   private LinkedList triggerListeners = new LinkedList();
/*     */ 
/*     */   public Trigger()
/*     */   {
/*     */   }
/*     */ 
/*     */   public Trigger(String name, String group)
/*     */   {
/* 287 */     setName(name);
/* 288 */     setGroup(group);
/*     */   }
/*     */ 
/*     */   public Trigger(String name, String group, String jobName, String jobGroup)
/*     */   {
/* 302 */     setName(name);
/* 303 */     setGroup(group);
/* 304 */     setJobName(jobName);
/* 305 */     setJobGroup(jobGroup);
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 322 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/* 334 */     if ((name == null) || (name.trim().length() == 0)) {
/* 335 */       throw new IllegalArgumentException("Trigger name cannot be null or empty.");
/*     */     }
/*     */ 
/* 338 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public String getGroup()
/*     */   {
/* 347 */     return this.group;
/*     */   }
/*     */ 
/*     */   public void setGroup(String group)
/*     */   {
/* 361 */     if ((group != null) && (group.trim().length() == 0)) {
/* 362 */       throw new IllegalArgumentException("Group name cannot be an empty string.");
/*     */     }
/*     */ 
/* 365 */     if (group == null) {
/* 366 */       group = "DEFAULT";
/*     */     }
/* 368 */     this.group = group;
/*     */   }
/*     */ 
/*     */   public String getJobName()
/*     */   {
/* 377 */     return this.jobName;
/*     */   }
/*     */ 
/*     */   public void setJobName(String jobName)
/*     */   {
/* 389 */     if ((jobName == null) || (jobName.trim().length() == 0)) {
/* 390 */       throw new IllegalArgumentException("Job name cannot be null or empty.");
/*     */     }
/*     */ 
/* 393 */     this.jobName = jobName;
/*     */   }
/*     */ 
/*     */   public String getJobGroup()
/*     */   {
/* 403 */     return this.jobGroup;
/*     */   }
/*     */ 
/*     */   public void setJobGroup(String jobGroup)
/*     */   {
/* 418 */     if ((jobGroup != null) && (jobGroup.trim().length() == 0)) {
/* 419 */       throw new IllegalArgumentException("Group name cannot be null or empty.");
/*     */     }
/*     */ 
/* 422 */     if (jobGroup == null) {
/* 423 */       jobGroup = "DEFAULT";
/*     */     }
/* 425 */     this.jobGroup = jobGroup;
/*     */   }
/*     */ 
/*     */   public String getFullName()
/*     */   {
/* 435 */     return this.group + "." + this.name;
/*     */   }
/*     */ 
/*     */   public String getFullJobName()
/*     */   {
/* 445 */     return this.jobGroup + "." + this.jobName;
/*     */   }
/*     */ 
/*     */   public String getDescription()
/*     */   {
/* 457 */     return this.description;
/*     */   }
/*     */ 
/*     */   public void setDescription(String description)
/*     */   {
/* 468 */     this.description = description;
/*     */   }
/*     */ 
/*     */   public void setVolatility(boolean volatility)
/*     */   {
/* 479 */     this.volatility = volatility;
/*     */   }
/*     */ 
/*     */   public void setCalendarName(String calendarName)
/*     */   {
/* 492 */     this.calendarName = calendarName;
/*     */   }
/*     */ 
/*     */   public String getCalendarName()
/*     */   {
/* 504 */     return this.calendarName;
/*     */   }
/*     */ 
/*     */   public JobDataMap getJobDataMap()
/*     */   {
/* 519 */     if (this.jobDataMap == null) this.jobDataMap = new JobDataMap();
/* 520 */     return this.jobDataMap;
/*     */   }
/*     */ 
/*     */   public void setJobDataMap(JobDataMap jobDataMap)
/*     */   {
/* 531 */     this.jobDataMap = jobDataMap;
/*     */   }
/*     */ 
/*     */   public boolean isVolatile()
/*     */   {
/* 549 */     return this.volatility;
/*     */   }
/*     */ 
/*     */   public void addTriggerListener(String name)
/*     */   {
/* 559 */     this.triggerListeners.add(name);
/*     */   }
/*     */ 
/*     */   public boolean removeTriggerListener(String name)
/*     */   {
/* 571 */     return this.triggerListeners.remove(name);
/*     */   }
/*     */ 
/*     */   public String[] getTriggerListenerNames()
/*     */   {
/* 582 */     String[] outNames = new String[this.triggerListeners.size()];
/* 583 */     return (String[])this.triggerListeners.toArray(outNames);
/*     */   }
/*     */ 
/*     */   public abstract void triggered(Calendar paramCalendar);
/*     */ 
/*     */   public abstract Date computeFirstFireTime(Calendar paramCalendar);
/*     */ 
/*     */   public abstract int executionComplete(JobExecutionContext paramJobExecutionContext, JobExecutionException paramJobExecutionException);
/*     */ 
/*     */   public abstract boolean mayFireAgain();
/*     */ 
/*     */   public abstract Date getStartTime();
/*     */ 
/*     */   public abstract void setStartTime(Date paramDate);
/*     */ 
/*     */   public abstract void setEndTime(Date paramDate);
/*     */ 
/*     */   public abstract Date getEndTime();
/*     */ 
/*     */   public abstract Date getNextFireTime();
/*     */ 
/*     */   public abstract Date getPreviousFireTime();
/*     */ 
/*     */   public abstract Date getFireTimeAfter(Date paramDate);
/*     */ 
/*     */   public abstract Date getFinalFireTime();
/*     */ 
/*     */   public void setMisfireInstruction(int misfireInstruction)
/*     */   {
/* 744 */     if (!validateMisfireInstruction(misfireInstruction)) {
/* 745 */       throw new IllegalArgumentException("The misfire instruction code is invalid for this type of trigger.");
/*     */     }
/* 747 */     this.misfireInstruction = misfireInstruction;
/*     */   }
/*     */ 
/*     */   protected abstract boolean validateMisfireInstruction(int paramInt);
/*     */ 
/*     */   public int getMisfireInstruction()
/*     */   {
/* 771 */     return this.misfireInstruction;
/*     */   }
/*     */ 
/*     */   public abstract void updateAfterMisfire(Calendar paramCalendar);
/*     */ 
/*     */   public abstract void updateWithNewCalendar(Calendar paramCalendar, long paramLong);
/*     */ 
/*     */   public void validate()
/*     */     throws SchedulerException
/*     */   {
/* 821 */     if (this.name == null) {
/* 822 */       throw new SchedulerException("Trigger's name cannot be null", 100);
/*     */     }
/*     */ 
/* 825 */     if (this.group == null) {
/* 826 */       throw new SchedulerException("Trigger's group cannot be null", 100);
/*     */     }
/*     */ 
/* 829 */     if (this.jobName == null) {
/* 830 */       throw new SchedulerException("Trigger's related Job's name cannot be null", 100);
/*     */     }
/*     */ 
/* 834 */     if (this.jobGroup == null)
/* 835 */       throw new SchedulerException("Trigger's related Job's group cannot be null", 100);
/*     */   }
/*     */ 
/*     */   public void setFireInstanceId(String id)
/*     */   {
/* 854 */     this.fireInstanceId = id;
/*     */   }
/*     */ 
/*     */   public String getFireInstanceId()
/*     */   {
/* 863 */     return this.fireInstanceId;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 872 */     return "Trigger '" + getFullName() + "':  triggerClass: '" + getClass().getName() + " isVolatile: " + isVolatile() + " calendar: '" + getCalendarName() + "' misfireInstruction: " + getMisfireInstruction() + " nextFireTime: " + getNextFireTime();
/*     */   }
/*     */ 
/*     */   public int compareTo(Object obj)
/*     */   {
/* 885 */     Trigger other = (Trigger)obj;
/*     */ 
/* 887 */     Date myTime = getNextFireTime();
/* 888 */     Date otherTime = other.getNextFireTime();
/*     */ 
/* 890 */     if ((myTime == null) && (otherTime == null)) return 0;
/*     */ 
/* 892 */     if (myTime == null) return 1;
/*     */ 
/* 894 */     if (otherTime == null) return -1;
/*     */ 
/* 896 */     if (myTime.before(otherTime)) {
/* 897 */       return -1;
/*     */     }
/* 899 */     if (myTime.after(otherTime)) {
/* 900 */       return 1;
/*     */     }
/* 902 */     return 0;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj) {
/* 906 */     if (!(obj instanceof Trigger)) return false;
/*     */ 
/* 908 */     Trigger other = (Trigger)obj;
/*     */ 
/* 910 */     if (!other.getName().equals(getName())) return false;
/* 911 */     return other.getGroup().equals(getGroup());
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 918 */     return getFullName().hashCode();
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/*     */     try {
/* 924 */       copy = (Trigger)super.clone();
/*     */     }
/*     */     catch (CloneNotSupportedException ex)
/*     */     {
/*     */       Trigger copy;
/* 926 */       throw new IncompatibleClassChangeError("Not Cloneable.");
/*     */     }
/*     */     Trigger copy;
/* 928 */     return copy;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.Trigger
 * JD-Core Version:    0.6.0
 */