/*     */ package org.quartz;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Date;
/*     */ 
/*     */ public class SchedulerMetaData
/*     */   implements Serializable
/*     */ {
/*     */   private String schedName;
/*     */   private String schedInst;
/*     */   private Class schedClass;
/*     */   private boolean isRemote;
/*     */   private boolean started;
/*     */   private boolean paused;
/*     */   private boolean shutdown;
/*     */   private Date startTime;
/*     */   private int numJobsExec;
/*     */   private Class jsClass;
/*     */   private boolean jsPersistent;
/*     */   private Class tpClass;
/*     */   private int tpSize;
/*     */   private String version;
/*     */ 
/*     */   public SchedulerMetaData(String schedName, String schedInst, Class schedClass, boolean isRemote, boolean started, boolean paused, boolean shutdown, Date startTime, int numJobsExec, Class jsClass, boolean jsPersistent, Class tpClass, int tpSize, String version)
/*     */   {
/*  85 */     this.schedName = schedName;
/*  86 */     this.schedInst = schedInst;
/*  87 */     this.schedClass = schedClass;
/*  88 */     this.isRemote = isRemote;
/*  89 */     this.started = started;
/*  90 */     this.paused = paused;
/*  91 */     this.shutdown = shutdown;
/*  92 */     this.startTime = startTime;
/*  93 */     this.numJobsExec = numJobsExec;
/*  94 */     this.jsClass = jsClass;
/*  95 */     this.jsPersistent = jsPersistent;
/*  96 */     this.tpClass = tpClass;
/*  97 */     this.tpSize = tpSize;
/*  98 */     this.version = version;
/*     */   }
/*     */ 
/*     */   public String getSchedulerName()
/*     */   {
/* 115 */     return this.schedName;
/*     */   }
/*     */ 
/*     */   public String getSchedulerInstanceId()
/*     */   {
/* 124 */     return this.schedInst;
/*     */   }
/*     */ 
/*     */   public Class getSchedulerClass()
/*     */   {
/* 133 */     return this.schedClass;
/*     */   }
/*     */ 
/*     */   public Date runningSince()
/*     */   {
/* 144 */     return this.startTime;
/*     */   }
/*     */ 
/*     */   public int numJobsExecuted()
/*     */   {
/* 154 */     return this.numJobsExec;
/*     */   }
/*     */ 
/*     */   public boolean isSchedulerRemote()
/*     */   {
/* 164 */     return this.isRemote;
/*     */   }
/*     */ 
/*     */   public boolean isStarted()
/*     */   {
/* 178 */     return this.started;
/*     */   }
/*     */ 
/*     */   public boolean isPaused()
/*     */   {
/* 192 */     return this.paused;
/*     */   }
/*     */ 
/*     */   public boolean isShutdown()
/*     */   {
/* 201 */     return this.shutdown;
/*     */   }
/*     */ 
/*     */   public Class getJobStoreClass()
/*     */   {
/* 211 */     return this.jsClass;
/*     */   }
/*     */ 
/*     */   public boolean jobStoreSupportsPersistence()
/*     */   {
/* 221 */     return this.jsPersistent;
/*     */   }
/*     */ 
/*     */   public Class getThreadPoolClass()
/*     */   {
/* 231 */     return this.tpClass;
/*     */   }
/*     */ 
/*     */   public int getThreadPoolSize()
/*     */   {
/* 241 */     return this.tpSize;
/*     */   }
/*     */ 
/*     */   public String getVersion()
/*     */   {
/* 250 */     return this.version;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/*     */     try
/*     */     {
/* 260 */       return getSummary(); } catch (SchedulerException se) {
/*     */     }
/* 262 */     return "SchedulerMetaData: undeterminable.";
/*     */   }
/*     */ 
/*     */   public String getSummary()
/*     */     throws SchedulerException
/*     */   {
/* 284 */     StringBuffer str = new StringBuffer("Quartz Scheduler (v");
/* 285 */     str.append(getVersion());
/* 286 */     str.append(") '");
/*     */ 
/* 288 */     str.append(getSchedulerName());
/* 289 */     str.append("' with instanceId '");
/* 290 */     str.append(getSchedulerInstanceId());
/* 291 */     str.append("'\n");
/*     */ 
/* 293 */     str.append("  Scheduler class: '");
/* 294 */     str.append(getSchedulerClass().getName());
/* 295 */     str.append("'");
/* 296 */     if (isSchedulerRemote()) str.append(" - access via RMI.");
/*     */     else
/* 298 */       str.append(" - running locally.");
/* 299 */     str.append("\n");
/*     */ 
/* 301 */     if (!isShutdown()) {
/* 302 */       if (runningSince() != null) {
/* 303 */         str.append("  Running since: ");
/* 304 */         str.append(runningSince());
/*     */       } else {
/* 306 */         str.append("NOT STARTED.");
/* 307 */       }str.append("\n");
/*     */ 
/* 309 */       if (isPaused()) str.append("  Currently PAUSED.");
/*     */       else
/* 311 */         str.append("  Not currently paused.");
/*     */     } else {
/* 313 */       str.append("  Scheduler has been SHUTDOWN.");
/*     */     }
/* 315 */     str.append("\n");
/*     */ 
/* 317 */     str.append("  Number of jobs executed: ");
/* 318 */     str.append(numJobsExecuted());
/* 319 */     str.append("\n");
/*     */ 
/* 321 */     str.append("  Using thread pool '");
/* 322 */     str.append(getThreadPoolClass().getName());
/* 323 */     str.append("' - with ");
/* 324 */     str.append(getThreadPoolSize());
/* 325 */     str.append(" threads.");
/* 326 */     str.append("\n");
/*     */ 
/* 328 */     str.append("  Using job-store '");
/* 329 */     str.append(getJobStoreClass().getName());
/* 330 */     str.append("' - which ");
/* 331 */     if (jobStoreSupportsPersistence()) str.append("supports persistence.");
/*     */     else
/* 333 */       str.append("does not support persistence.");
/* 334 */     str.append("\n");
/*     */ 
/* 336 */     return str.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.SchedulerMetaData
 * JD-Core Version:    0.6.0
 */