/*     */ package org.quartz;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.text.ParseException;
/*     */ import java.util.Date;
/*     */ import java.util.List;
/*     */ import java.util.TimeZone;
/*     */ 
/*     */ public class CronTrigger extends Trigger
/*     */ {
/*     */   public static final int MISFIRE_INSTRUCTION_FIRE_ONCE_NOW = 1;
/*     */   public static final int MISFIRE_INSTRUCTION_DO_NOTHING = 2;
/* 216 */   private CronExpression cronEx = null;
/* 217 */   private Date startTime = null;
/* 218 */   private Date endTime = null;
/* 219 */   private Date nextFireTime = null;
/* 220 */   private Date previousFireTime = null;
/* 221 */   private transient TimeZone timeZone = null;
/*     */ 
/*     */   public CronTrigger()
/*     */   {
/* 243 */     setStartTime(new Date());
/* 244 */     setTimeZone(TimeZone.getDefault());
/*     */   }
/*     */ 
/*     */   public CronTrigger(String name, String group)
/*     */   {
/* 258 */     super(name, group);
/* 259 */     setStartTime(new Date());
/* 260 */     setTimeZone(TimeZone.getDefault());
/*     */   }
/*     */ 
/*     */   public CronTrigger(String name, String group, String cronExpression)
/*     */     throws ParseException
/*     */   {
/* 276 */     super(name, group);
/*     */ 
/* 278 */     setCronExpression(cronExpression);
/*     */ 
/* 280 */     setStartTime(new Date());
/* 281 */     setTimeZone(TimeZone.getDefault());
/*     */   }
/*     */ 
/*     */   public CronTrigger(String name, String group, String jobName, String jobGroup)
/*     */   {
/* 297 */     super(name, group, jobName, jobGroup);
/* 298 */     setStartTime(new Date());
/* 299 */     setTimeZone(TimeZone.getDefault());
/*     */   }
/*     */ 
/*     */   public CronTrigger(String name, String group, String jobName, String jobGroup, String cronExpression)
/*     */     throws ParseException
/*     */   {
/* 316 */     this(name, group, jobName, jobGroup, null, null, cronExpression, TimeZone.getDefault());
/*     */   }
/*     */ 
/*     */   public CronTrigger(String name, String group, String jobName, String jobGroup, String cronExpression, TimeZone timeZone)
/*     */     throws ParseException
/*     */   {
/* 330 */     this(name, group, jobName, jobGroup, null, null, cronExpression, timeZone);
/*     */   }
/*     */ 
/*     */   public CronTrigger(String name, String group, String jobName, String jobGroup, Date startTime, Date endTime, String cronExpression)
/*     */     throws ParseException
/*     */   {
/* 355 */     super(name, group, jobName, jobGroup);
/*     */ 
/* 357 */     setCronExpression(cronExpression);
/*     */ 
/* 359 */     if (startTime == null) startTime = new Date();
/* 360 */     setStartTime(startTime);
/* 361 */     if (endTime != null) setEndTime(endTime);
/* 362 */     setTimeZone(TimeZone.getDefault());
/*     */   }
/*     */ 
/*     */   public CronTrigger(String name, String group, String jobName, String jobGroup, Date startTime, Date endTime, String cronExpression, TimeZone timeZone)
/*     */     throws ParseException
/*     */   {
/* 407 */     super(name, group, jobName, jobGroup);
/*     */ 
/* 409 */     setCronExpression(cronExpression);
/*     */ 
/* 411 */     if (startTime == null) startTime = new Date();
/* 412 */     setStartTime(startTime);
/* 413 */     if (endTime != null) setEndTime(endTime);
/* 414 */     if (timeZone == null)
/* 415 */       setTimeZone(TimeZone.getDefault());
/*     */     else
/* 417 */       setTimeZone(timeZone);
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/* 430 */     CronTrigger copy = (CronTrigger)super.clone();
/* 431 */     copy.setCronExpression((CronExpression)this.cronEx.clone());
/* 432 */     return copy;
/*     */   }
/*     */ 
/*     */   public void setCronExpression(String cronExpression) throws ParseException {
/* 436 */     this.cronEx = new CronExpression(cronExpression);
/* 437 */     this.cronEx.setTimeZone(getTimeZone());
/*     */   }
/*     */ 
/*     */   public String getCronExpression() {
/* 441 */     return this.cronEx == null ? null : this.cronEx.getCronExpression();
/*     */   }
/*     */ 
/*     */   public void setCronExpression(CronExpression cronExpression) {
/* 445 */     this.cronEx = cronExpression;
/* 446 */     this.timeZone = cronExpression.getTimeZone();
/*     */   }
/*     */ 
/*     */   public Date getStartTime()
/*     */   {
/* 455 */     return this.startTime;
/*     */   }
/*     */ 
/*     */   public void setStartTime(Date startTime) {
/* 459 */     if (startTime == null) {
/* 460 */       throw new IllegalArgumentException("Start time cannot be null");
/*     */     }
/* 462 */     Date eTime = getEndTime();
/* 463 */     if ((eTime != null) && (startTime != null) && (eTime.before(startTime))) {
/* 464 */       throw new IllegalArgumentException("End time cannot be before start time");
/*     */     }
/*     */ 
/* 471 */     java.util.Calendar cl = java.util.Calendar.getInstance();
/* 472 */     cl.setTime(startTime);
/* 473 */     cl.set(14, 0);
/*     */ 
/* 475 */     this.startTime = cl.getTime();
/*     */   }
/*     */ 
/*     */   public Date getEndTime()
/*     */   {
/* 487 */     return this.endTime;
/*     */   }
/*     */ 
/*     */   public void setEndTime(Date endTime) {
/* 491 */     Date sTime = getStartTime();
/* 492 */     if ((sTime != null) && (endTime != null) && (sTime.after(endTime))) {
/* 493 */       throw new IllegalArgumentException("End time cannot be before start time");
/*     */     }
/*     */ 
/* 496 */     this.endTime = endTime;
/*     */   }
/*     */ 
/*     */   public Date getNextFireTime()
/*     */   {
/* 508 */     return this.nextFireTime;
/*     */   }
/*     */ 
/*     */   public Date getPreviousFireTime()
/*     */   {
/* 518 */     return this.previousFireTime;
/*     */   }
/*     */ 
/*     */   public void setNextFireTime(Date nextFireTime)
/*     */   {
/* 528 */     this.nextFireTime = nextFireTime;
/*     */   }
/*     */ 
/*     */   public void setPreviousFireTime(Date previousFireTime)
/*     */   {
/* 541 */     this.previousFireTime = previousFireTime;
/*     */   }
/*     */ 
/*     */   public TimeZone getTimeZone()
/*     */   {
/* 552 */     if (this.cronEx != null) return this.cronEx.getTimeZone();
/*     */ 
/* 554 */     if (this.timeZone == null) this.timeZone = TimeZone.getDefault();
/* 555 */     return this.timeZone;
/*     */   }
/*     */ 
/*     */   public void setTimeZone(TimeZone timeZone)
/*     */   {
/* 565 */     if (this.cronEx != null) this.cronEx.setTimeZone(timeZone);
/* 566 */     this.timeZone = timeZone;
/*     */   }
/*     */ 
/*     */   public Date getFireTimeAfter(Date afterTime)
/*     */   {
/* 582 */     if (afterTime == null) afterTime = new Date();
/*     */ 
/* 584 */     if (this.startTime.after(afterTime)) {
/* 585 */       afterTime = new Date(this.startTime.getTime() - 1000L);
/*     */     }
/* 587 */     Date pot = getTimeAfter(afterTime);
/* 588 */     if ((this.endTime != null) && (pot != null) && (pot.after(this.endTime))) return null;
/*     */ 
/* 590 */     return pot;
/*     */   }
/*     */ 
/*     */   public Date getFinalFireTime()
/*     */   {
/* 605 */     if (this.endTime != null) return getTimeBefore(this.endTime);
/*     */ 
/* 607 */     return null;
/*     */   }
/*     */ 
/*     */   public boolean mayFireAgain()
/*     */   {
/* 617 */     return getNextFireTime() != null;
/*     */   }
/*     */ 
/*     */   protected boolean validateMisfireInstruction(int misfireInstruction) {
/* 621 */     if (misfireInstruction < 0) {
/* 622 */       return false;
/*     */     }
/* 624 */     return misfireInstruction <= 2;
/*     */   }
/*     */ 
/*     */   public void updateAfterMisfire(Calendar cal)
/*     */   {
/* 645 */     int instr = getMisfireInstruction();
/*     */ 
/* 647 */     if (instr == 0) {
/* 648 */       instr = 1;
/*     */     }
/* 650 */     if (instr == 2) {
/* 651 */       Date newFireTime = getFireTimeAfter(new Date());
/*     */ 
/* 653 */       while ((newFireTime != null) && (cal != null) && (!cal.isTimeIncluded(newFireTime.getTime()))) {
/* 654 */         newFireTime = getFireTimeAfter(newFireTime);
/*     */       }
/* 656 */       setNextFireTime(newFireTime);
/* 657 */     } else if (instr == 1) {
/* 658 */       setNextFireTime(new Date());
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean willFireOn(java.util.Calendar test)
/*     */   {
/* 677 */     return willFireOn(test, false);
/*     */   }
/*     */ 
/*     */   public boolean willFireOn(java.util.Calendar test, boolean dayOnly)
/*     */   {
/* 699 */     test = (java.util.Calendar)test.clone();
/*     */ 
/* 701 */     test.set(14, 0);
/*     */ 
/* 703 */     if (dayOnly) {
/* 704 */       test.set(10, 0);
/* 705 */       test.set(12, 0);
/* 706 */       test.set(13, 0);
/*     */     }
/*     */ 
/* 709 */     Date testTime = test.getTime();
/*     */ 
/* 711 */     Date fta = getFireTimeAfter(new Date(test.getTime().getTime() - 1000L));
/*     */ 
/* 713 */     java.util.Calendar p = java.util.Calendar.getInstance(test.getTimeZone());
/* 714 */     p.setTime(fta);
/*     */ 
/* 716 */     int year = p.get(1);
/* 717 */     int month = p.get(2);
/* 718 */     int day = p.get(5);
/*     */ 
/* 720 */     if (dayOnly) {
/* 721 */       return (year == test.get(1)) && (month == test.get(2)) && (day == test.get(5));
/*     */     }
/*     */ 
/* 726 */     while (fta.before(testTime)) {
/* 727 */       fta = getFireTimeAfter(fta);
/*     */     }
/*     */ 
/* 731 */     return fta.equals(testTime);
/*     */   }
/*     */ 
/*     */   public int executionComplete(JobExecutionContext context, JobExecutionException result)
/*     */   {
/* 759 */     if ((result != null) && (result.refireImmediately())) {
/* 760 */       return 1;
/*     */     }
/* 762 */     if ((result != null) && (result.unscheduleFiringTrigger())) {
/* 763 */       return 2;
/*     */     }
/* 765 */     if ((result != null) && (result.unscheduleAllTriggers())) {
/* 766 */       return 4;
/*     */     }
/* 768 */     if (!mayFireAgain()) return 3;
/*     */ 
/* 770 */     return 0;
/*     */   }
/*     */ 
/*     */   public void triggered(Calendar calendar)
/*     */   {
/* 784 */     this.previousFireTime = this.nextFireTime;
/* 785 */     this.nextFireTime = getFireTimeAfter(this.nextFireTime);
/*     */ 
/* 788 */     while ((this.nextFireTime != null) && (calendar != null) && (!calendar.isTimeIncluded(this.nextFireTime.getTime())))
/* 789 */       this.nextFireTime = getFireTimeAfter(this.nextFireTime);
/*     */   }
/*     */ 
/*     */   public void updateWithNewCalendar(Calendar calendar, long misfireThreshold)
/*     */   {
/* 799 */     this.nextFireTime = getFireTimeAfter(this.previousFireTime);
/*     */ 
/* 801 */     Date now = new Date();
/*     */ 
/* 804 */     while ((this.nextFireTime != null) && (calendar != null) && (!calendar.isTimeIncluded(this.nextFireTime.getTime()))) {
/* 805 */       this.nextFireTime = getFireTimeAfter(this.nextFireTime);
/*     */     }
/*     */ 
/* 808 */     if ((this.nextFireTime != null) && (this.nextFireTime.before(now))) {
/* 809 */       long diff = now.getTime() - this.nextFireTime.getTime();
/* 810 */       if (diff >= misfireThreshold)
/* 811 */         this.nextFireTime = getFireTimeAfter(this.nextFireTime);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Date computeFirstFireTime(Calendar calendar)
/*     */   {
/* 836 */     this.nextFireTime = getFireTimeAfter(new Date(this.startTime.getTime() - 1000L));
/*     */ 
/* 839 */     while ((this.nextFireTime != null) && (calendar != null) && (!calendar.isTimeIncluded(this.nextFireTime.getTime()))) {
/* 840 */       this.nextFireTime = getFireTimeAfter(this.nextFireTime);
/*     */     }
/*     */ 
/* 843 */     return this.nextFireTime;
/*     */   }
/*     */ 
/*     */   public String getExpressionSummary() {
/* 847 */     return this.cronEx == null ? null : this.cronEx.getExpressionSummary();
/*     */   }
/*     */ 
/*     */   protected Date getTimeAfter(Date afterTime)
/*     */   {
/* 857 */     return this.cronEx.getTimeAfter(afterTime);
/*     */   }
/*     */ 
/*     */   protected Date getTimeBefore(Date endTime)
/*     */   {
/* 862 */     return null;
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */     throws Exception
/*     */   {
/* 869 */     String expr = "15 10 0/4 * * ?";
/* 870 */     if ((args != null) && (args.length > 0) && (args[0] != null)) {
/* 871 */       expr = args[0];
/*     */     }
/* 873 */     CronTrigger ct = new CronTrigger("t", "g", "j", "g", new Date(), null, expr);
/* 874 */     ct.setTimeZone(TimeZone.getTimeZone("America/Los_Angeles"));
/* 875 */     System.err.println(ct.getExpressionSummary());
/* 876 */     System.err.println("tz=" + ct.getTimeZone().getID());
/* 877 */     System.err.println();
/*     */ 
/* 879 */     List times = TriggerUtils.computeFireTimes(ct, null, 25);
/*     */ 
/* 881 */     for (int i = 0; i < times.size(); i++) {
/* 882 */       System.err.println("firetime = " + times.get(i));
/*     */     }
/*     */ 
/* 885 */     java.util.Calendar tt = java.util.Calendar.getInstance();
/* 886 */     tt.set(5, 17);
/* 887 */     tt.set(2, 4);
/* 888 */     tt.set(10, 11);
/* 889 */     tt.set(12, 0);
/* 890 */     tt.set(13, 7);
/*     */ 
/* 892 */     System.err.println("\nWill fire on: " + tt.getTime() + " -- " + ct.willFireOn(tt, false));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.CronTrigger
 * JD-Core Version:    0.6.0
 */