package org.hsqldb.scriptio;

import java.io.IOException;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.NumberSequence;
import org.hsqldb.Session;
import org.hsqldb.Table;

public abstract class ScriptReaderBase
{
  public static final int ANY_STATEMENT = 1;
  public static final int DELETE_STATEMENT = 2;
  public static final int INSERT_STATEMENT = 3;
  public static final int SEQUENCE_STATEMENT = 4;
  public static final int COMMIT_STATEMENT = 5;
  public static final int SESSION_ID = 6;
  public static final int SCHEMA_STATEMENT = 7;
  Database db;
  int lineCount;
  String fileName;
  int statementType;
  int sessionNumber;
  Object[] rowData;
  long sequenceValue;
  String statement;
  Table currentTable;
  NumberSequence currentSequence;
  String currentSchema;

  public static ScriptReaderBase newScriptReader(Database paramDatabase, String paramString, int paramInt)
    throws HsqlException, IOException
  {
    if (paramInt == 0)
      return new ScriptReaderText(paramDatabase, paramString);
    if (paramInt == 1)
      return new ScriptReaderBinary(paramDatabase, paramString);
    return new ScriptReaderZipped(paramDatabase, paramString);
  }

  ScriptReaderBase(Database paramDatabase, String paramString)
    throws HsqlException, IOException
  {
    this.db = paramDatabase;
    this.fileName = paramString;
    openFile();
  }

  protected abstract void openFile()
    throws IOException;

  public void readAll(Session paramSession)
    throws IOException, HsqlException
  {
    readDDL(paramSession);
    readExistingData(paramSession);
  }

  protected abstract void readDDL(Session paramSession)
    throws IOException, HsqlException;

  protected abstract void readExistingData(Session paramSession)
    throws IOException, HsqlException;

  public abstract boolean readLoggedStatement(Session paramSession)
    throws IOException;

  public int getStatementType()
  {
    return this.statementType;
  }

  public int getSessionNumber()
  {
    return this.sessionNumber;
  }

  public Object[] getData()
  {
    return this.rowData;
  }

  public String getLoggedStatement()
  {
    return this.statement;
  }

  public NumberSequence getCurrentSequence()
  {
    return this.currentSequence;
  }

  public long getSequenceValue()
  {
    return this.sequenceValue;
  }

  public Table getCurrentTable()
  {
    return this.currentTable;
  }

  public String getCurrentSchema()
  {
    return this.currentSchema;
  }

  public int getLineNumber()
  {
    return this.lineCount;
  }

  public abstract void close();
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.scriptio.ScriptReaderBase
 * JD-Core Version:    0.6.0
 */