package org.hsqldb.persist;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.NumberSequence;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.User;
import org.hsqldb.lib.SimpleLog;

public class Logger
{
  public SimpleLog appLog = new SimpleLog(null, SimpleLog.LOG_NONE, false);
  private Log log;
  private LockFile lf;
  boolean needsCheckpoint;
  private boolean logStatements;
  private boolean syncFile = false;

  public void openLog(Database paramDatabase)
    throws HsqlException
  {
    this.needsCheckpoint = false;
    String str = paramDatabase.getPath();
    int i = paramDatabase.getProperties().getIntegerProperty("hsqldb.applog", 0);
    if (i != SimpleLog.LOG_NONE)
      this.appLog = new SimpleLog(str + ".app.log", i, !paramDatabase.isFilesReadOnly());
    this.appLog.sendLine(SimpleLog.LOG_ERROR, "Database (re)opened");
    this.logStatements = false;
    if (!paramDatabase.isFilesReadOnly())
      acquireLock(str);
    this.log = new Log(paramDatabase);
    this.log.open();
    this.logStatements = (!paramDatabase.isFilesReadOnly());
  }

  public boolean closeLog(int paramInt)
  {
    if (this.log == null)
    {
      this.appLog.sendLine(SimpleLog.LOG_ERROR, "Database closed");
      this.appLog.close();
      return true;
    }
    try
    {
      switch (paramInt)
      {
      case -1:
        this.log.shutdown();
        break;
      case 0:
        this.log.close(false);
        break;
      case 1:
      case 2:
        this.log.close(true);
      }
    }
    catch (Throwable localThrowable)
    {
      this.appLog.logContext(localThrowable, "error closing log");
      this.appLog.close();
      this.log = null;
      return false;
    }
    this.appLog.sendLine(SimpleLog.LOG_ERROR, "Database closed");
    this.appLog.close();
    this.log = null;
    return true;
  }

  public boolean hasLog()
  {
    return this.log != null;
  }

  public DataFileCache getCache()
    throws HsqlException
  {
    if (this.log == null)
      return null;
    return this.log.getCache();
  }

  public boolean hasCache()
  {
    if (this.log == null)
      return false;
    return this.log.hasCache();
  }

  public synchronized void logConnectUser(Session paramSession)
    throws HsqlException
  {
    if (this.logStatements)
      writeToLog(paramSession, paramSession.getUser().getConnectStatement());
  }

  public synchronized void writeToLog(Session paramSession, String paramString)
    throws HsqlException
  {
    if ((this.logStatements) && (this.log != null))
      this.log.writeStatement(paramSession, paramString);
  }

  public synchronized void writeInsertStatement(Session paramSession, Table paramTable, Object[] paramArrayOfObject)
    throws HsqlException
  {
    if (this.logStatements)
      this.log.writeInsertStatement(paramSession, paramTable, paramArrayOfObject);
  }

  public synchronized void writeDeleteStatement(Session paramSession, Table paramTable, Object[] paramArrayOfObject)
    throws HsqlException
  {
    if (this.logStatements)
      this.log.writeDeleteStatement(paramSession, paramTable, paramArrayOfObject);
  }

  public synchronized void writeSequenceStatement(Session paramSession, NumberSequence paramNumberSequence)
    throws HsqlException
  {
    if (this.logStatements)
      this.log.writeSequenceStatement(paramSession, paramNumberSequence);
  }

  public synchronized void writeCommitStatement(Session paramSession)
    throws HsqlException
  {
    if (this.logStatements)
    {
      this.log.writeCommitStatement(paramSession);
      synchLog();
    }
  }

  public synchronized void synchLog()
  {
    if ((this.logStatements) && (this.syncFile))
      this.log.synchLog();
  }

  public synchronized void synchLogForce()
  {
    if (this.logStatements)
      this.log.synchLog();
  }

  public synchronized void checkpoint(boolean paramBoolean)
    throws HsqlException
  {
    if (this.logStatements)
    {
      this.appLog.logContext(SimpleLog.LOG_NORMAL, "start");
      this.needsCheckpoint = false;
      this.log.checkpoint(paramBoolean);
      this.appLog.logContext(SimpleLog.LOG_NORMAL, "end");
    }
  }

  public synchronized void setLogSize(int paramInt)
  {
    if (this.log != null)
      this.log.setLogSize(paramInt);
  }

  public synchronized void setScriptType(int paramInt)
    throws HsqlException
  {
    if (this.log != null)
      this.log.setScriptType(paramInt);
  }

  public synchronized void setWriteDelay(int paramInt)
  {
    if (this.log != null)
    {
      this.syncFile = (paramInt == 0);
      this.log.setWriteDelay(paramInt);
    }
  }

  public int getWriteDelay()
  {
    return this.log != null ? this.log.getWriteDelay() : 0;
  }

  public int getLogSize()
  {
    return this.log != null ? this.log.getLogSize() : 0;
  }

  public int getScriptType()
  {
    return this.log != null ? this.log.getScriptType() : 0;
  }

  public DataFileCache openTextCache(Table paramTable, String paramString, boolean paramBoolean1, boolean paramBoolean2)
    throws HsqlException
  {
    return this.log.openTextCache(paramTable, paramString, paramBoolean1, paramBoolean2);
  }

  public void closeTextCache(Table paramTable)
    throws HsqlException
  {
    this.log.closeTextCache(paramTable);
  }

  public boolean needsCheckpoint()
  {
    return this.needsCheckpoint;
  }

  public void acquireLock(String paramString)
    throws HsqlException
  {
    if (this.lf != null)
      return;
    this.lf = LockFile.newLockFileLock(paramString);
  }

  public void releaseLock()
  {
    try
    {
      if (this.lf != null)
        this.lf.tryRelease();
    }
    catch (Exception localException)
    {
      if (Trace.TRACE)
        Trace.printSystemOut(localException.toString());
    }
    this.lf = null;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.persist.Logger
 * JD-Core Version:    0.6.0
 */