package org.hsqldb.persist;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager.HsqlName;
import org.hsqldb.Index;
import org.hsqldb.Row;
import org.hsqldb.SchemaManager;
import org.hsqldb.Session;
import org.hsqldb.SessionManager;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.TransactionManager;
import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.lib.Storage;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputBinary;

final class DataFileDefrag
{
  BufferedOutputStream fileStreamOut;
  long fileOffset;
  StopWatch stopw = new StopWatch();
  String filename;
  int[][] rootsList;
  Database database;
  DataFileCache cache;
  int scale;
  DoubleIntIndex transactionRowLookup;

  DataFileDefrag(Database paramDatabase, DataFileCache paramDataFileCache, String paramString)
  {
    this.database = paramDatabase;
    this.cache = paramDataFileCache;
    this.scale = paramDataFileCache.cacheFileScale;
    this.filename = paramString;
  }

  void process()
    throws HsqlException, IOException
  {
    int i = 0;
    Trace.printSystemOut("Defrag Transfer begins");
    this.transactionRowLookup = this.database.txManager.getTransactionIDList();
    HsqlArrayList localHsqlArrayList = this.database.schemaManager.getAllTables();
    this.rootsList = new int[localHsqlArrayList.size()][];
    Storage localStorage = null;
    try
    {
      OutputStream localOutputStream = this.database.getFileAccess().openOutputStreamElement(this.filename + ".new");
      this.fileStreamOut = new BufferedOutputStream(localOutputStream, 4096);
      for (int j = 0; j < 32; j++)
        this.fileStreamOut.write(0);
      this.fileOffset = 32L;
      j = 0;
      int k = localHsqlArrayList.size();
      Object localObject1;
      while (j < k)
      {
        localObject1 = (Table)localHsqlArrayList.get(j);
        if (((Table)localObject1).getTableType() == 4)
        {
          int[] arrayOfInt = writeTableToDataFile((Table)localObject1);
          this.rootsList[j] = arrayOfInt;
        }
        else
        {
          this.rootsList[j] = null;
        }
        Trace.printSystemOut(((Table)localObject1).getName().name + " complete");
        j++;
      }
      writeTransactionRows();
      this.fileStreamOut.close();
      this.fileStreamOut = null;
      localStorage = ScaledRAFile.newScaledRAFile(this.database, this.filename + ".new", false, 0, this.database.getURLProperties().getProperty("storage_class_name"), this.database.getURLProperties().getProperty("storage_key"));
      localStorage.seek(12L);
      localStorage.writeLong(this.fileOffset);
      localStorage.close();
      localStorage = null;
      j = 0;
      k = this.rootsList.length;
      while (j < k)
      {
        localObject1 = this.rootsList[j];
        if (localObject1 != null)
          Trace.printSystemOut(StringUtil.getList(localObject1, ",", ""));
        j++;
      }
      i = 1;
    }
    catch (IOException localIOException)
    {
      throw Trace.error(29, this.filename + ".new");
    }
    catch (OutOfMemoryError localOutOfMemoryError)
    {
      throw Trace.error(72);
    }
    finally
    {
      if (this.fileStreamOut != null)
        this.fileStreamOut.close();
      if (localStorage != null)
        localStorage.close();
      if (i == 0)
        this.database.getFileAccess().removeElement(this.filename + ".new");
    }
  }

  void updateTableIndexRoots()
    throws HsqlException
  {
    HsqlArrayList localHsqlArrayList = this.database.schemaManager.getAllTables();
    int i = 0;
    int j = localHsqlArrayList.size();
    while (i < j)
    {
      Table localTable = (Table)localHsqlArrayList.get(i);
      if (localTable.getTableType() == 4)
      {
        int[] arrayOfInt = this.rootsList[i];
        localTable.setIndexRoots(arrayOfInt);
      }
      i++;
    }
  }

  void updateTransactionRowIDs()
    throws HsqlException
  {
    this.database.txManager.convertTransactionIDs(this.transactionRowLookup);
  }

  int[] writeTableToDataFile(Table paramTable)
    throws IOException, HsqlException
  {
    Session localSession = this.database.getSessionManager().getSysSession();
    RowOutputBinary localRowOutputBinary = new RowOutputBinary();
    DoubleIntIndex localDoubleIntIndex = new DoubleIntIndex(paramTable.getPrimaryIndex().sizeEstimate(), false);
    int[] arrayOfInt = paramTable.getIndexRootsArray();
    long l = this.fileOffset;
    int i = 0;
    localDoubleIntIndex.setKeysSearchTarget();
    Trace.printSystemOut("lookup begins: " + this.stopw.elapsedTime());
    RowIterator localRowIterator = paramTable.rowIterator(localSession);
    Row localRow;
    while (localRowIterator.hasNext())
    {
      localRow = localRowIterator.next();
      localDoubleIntIndex.addUnsorted(localRow.getPos(), (int)(l / this.scale));
      if (i % 50000 == 0)
        Trace.printSystemOut("pointer pair for row " + i + " " + localRow.getPos() + " " + l);
      l += localRow.getStorageSize();
      i++;
    }
    Trace.printSystemOut(paramTable.getName().name + " list done ", this.stopw.elapsedTime());
    i = 0;
    localRowIterator = paramTable.rowIterator(localSession);
    while (localRowIterator.hasNext())
    {
      localRow = localRowIterator.next();
      localRowOutputBinary.reset();
      localRow.write(localRowOutputBinary, localDoubleIntIndex);
      this.fileStreamOut.write(localRowOutputBinary.getOutputStream().getBuffer(), 0, localRowOutputBinary.size());
      this.fileOffset += localRow.getStorageSize();
      if (i % 50000 == 0)
        Trace.printSystemOut(i + " rows " + this.stopw.elapsedTime());
      i++;
    }
    for (int j = 0; j < arrayOfInt.length; j++)
    {
      if (arrayOfInt[j] == -1)
        continue;
      int k = localDoubleIntIndex.findFirstEqualKeyIndex(arrayOfInt[j]);
      if (k == -1)
        throw Trace.error(129);
      arrayOfInt[j] = localDoubleIntIndex.getValue(k);
    }
    setTransactionRowLookups(localDoubleIntIndex);
    Trace.printSystemOut(paramTable.getName().name + " : table converted");
    return arrayOfInt;
  }

  void setTransactionRowLookups(DoubleIntIndex paramDoubleIntIndex)
  {
    int i = 0;
    int j = this.transactionRowLookup.size();
    while (i < j)
    {
      int k = this.transactionRowLookup.getKey(i);
      int m = paramDoubleIntIndex.findFirstEqualKeyIndex(k);
      if (m != -1)
        this.transactionRowLookup.setValue(i, paramDoubleIntIndex.getValue(m));
      i++;
    }
  }

  void writeTransactionRows()
  {
    int i = 0;
    int j = this.transactionRowLookup.size();
    while (i < j)
    {
      if (this.transactionRowLookup.getValue(i) == 0)
      {
        int k = this.transactionRowLookup.getKey(i);
        try
        {
          this.transactionRowLookup.setValue(i, (int)(this.fileOffset / this.scale));
          RowInputInterface localRowInputInterface = this.cache.readObject(k);
          this.fileStreamOut.write(localRowInputInterface.getBuffer(), 0, localRowInputInterface.getSize());
          this.fileOffset += localRowInputInterface.getSize();
        }
        catch (IOException localIOException)
        {
        }
      }
      i++;
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.persist.DataFileDefrag
 * JD-Core Version:    0.6.0
 */