package org.hsqldb.lib;

import java.lang.reflect.Array;

public class StringUtil
{
  public static String toLowerSubset(String paramString, char paramChar)
  {
    int i = paramString.length();
    StringBuffer localStringBuffer = new StringBuffer(i);
    for (int j = 0; j < i; j++)
    {
      char c = paramString.charAt(j);
      if (!Character.isLetterOrDigit(c))
        localStringBuffer.append(paramChar);
      else if ((j == 0) && (Character.isDigit(c)))
        localStringBuffer.append(paramChar);
      else
        localStringBuffer.append(Character.toLowerCase(c));
    }
    return localStringBuffer.toString();
  }

  public static String arrayToString(Object paramObject)
  {
    int i = Array.getLength(paramObject);
    int j = i - 1;
    StringBuffer localStringBuffer = new StringBuffer(2 * (i + 1));
    localStringBuffer.append('{');
    for (int k = 0; k < i; k++)
    {
      localStringBuffer.append(Array.get(paramObject, k));
      if (k == j)
        continue;
      localStringBuffer.append(',');
    }
    localStringBuffer.append('}');
    return localStringBuffer.toString();
  }

  public static String getList(String[] paramArrayOfString, String paramString1, String paramString2)
  {
    int i = paramArrayOfString.length;
    StringBuffer localStringBuffer = new StringBuffer(i * 16);
    for (int j = 0; j < i; j++)
    {
      localStringBuffer.append(paramString2);
      localStringBuffer.append(paramArrayOfString[j]);
      localStringBuffer.append(paramString2);
      if (j + 1 >= i)
        continue;
      localStringBuffer.append(paramString1);
    }
    return localStringBuffer.toString();
  }

  public static String getList(Object[] paramArrayOfObject, String paramString1, String paramString2)
  {
    int i = paramArrayOfObject.length;
    StringBuffer localStringBuffer = new StringBuffer(i * 16);
    for (int j = 0; j < i; j++)
    {
      localStringBuffer.append(paramString2);
      localStringBuffer.append(paramArrayOfObject[j]);
      localStringBuffer.append(paramString2);
      if (j + 1 >= i)
        continue;
      localStringBuffer.append(paramString1);
    }
    return localStringBuffer.toString();
  }

  public static String getList(int[] paramArrayOfInt, String paramString1, String paramString2)
  {
    int i = paramArrayOfInt.length;
    StringBuffer localStringBuffer = new StringBuffer(i * 8);
    for (int j = 0; j < i; j++)
    {
      localStringBuffer.append(paramString2);
      localStringBuffer.append(paramArrayOfInt[j]);
      localStringBuffer.append(paramString2);
      if (j + 1 >= i)
        continue;
      localStringBuffer.append(paramString1);
    }
    return localStringBuffer.toString();
  }

  public static String getList(String[][] paramArrayOfString, String paramString1, String paramString2)
  {
    int i = paramArrayOfString.length;
    StringBuffer localStringBuffer = new StringBuffer(i * 16);
    for (int j = 0; j < i; j++)
    {
      localStringBuffer.append(paramString2);
      localStringBuffer.append(paramArrayOfString[j][0]);
      localStringBuffer.append(paramString2);
      if (j + 1 >= i)
        continue;
      localStringBuffer.append(paramString1);
    }
    return localStringBuffer.toString();
  }

  public static void appendPair(StringBuffer paramStringBuffer, String paramString1, String paramString2, String paramString3, String paramString4)
  {
    paramStringBuffer.append(paramString1);
    paramStringBuffer.append(paramString3);
    paramStringBuffer.append(paramString2);
    paramStringBuffer.append(paramString4);
  }

  public static boolean isEmpty(String paramString)
  {
    int i = paramString == null ? 0 : paramString.length();
    while (i > 0)
    {
      i--;
      if (paramString.charAt(i) > ' ')
        return false;
    }
    return true;
  }

  public static int rTrimSize(String paramString)
  {
    int i = paramString.length();
    while (i > 0)
    {
      i--;
      if (paramString.charAt(i) != ' ')
        return i + 1;
    }
    return 0;
  }

  public static int skipSpaces(String paramString, int paramInt)
  {
    int i = paramString.length();
    for (int j = paramInt; (j < i) && (paramString.charAt(j) == ' '); j++);
    return j;
  }

  public static String[] split(String paramString1, String paramString2)
  {
    HsqlArrayList localHsqlArrayList = new HsqlArrayList();
    int i = 0;
    int j = 1;
    while (j != 0)
    {
      int k = paramString1.indexOf(paramString2, i);
      if (k == -1)
      {
        k = paramString1.length();
        j = 0;
      }
      localHsqlArrayList.add(paramString1.substring(i, k));
      i = k + paramString2.length();
    }
    return (String[])localHsqlArrayList.toArray(new String[localHsqlArrayList.size()]);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.lib.StringUtil
 * JD-Core Version:    0.6.0
 */