package org.hsqldb.lib;

import java.lang.reflect.Array;

public class HsqlArrayList extends BaseList
  implements HsqlList
{
  private static final int DEFAULT_INITIAL_CAPACITY = 10;
  private static final float DEFAULT_RESIZE_FACTOR = 2.0F;
  private Object[] elementData;
  private boolean minimizeOnClear;

  public HsqlArrayList()
  {
    this.elementData = new Object[10];
  }

  public HsqlArrayList(boolean paramBoolean)
  {
    this.elementData = new Object[10];
    this.minimizeOnClear = paramBoolean;
  }

  public HsqlArrayList(int paramInt)
  {
    if (paramInt < 0)
      throw new NegativeArraySizeException("Invalid initial capacity given");
    if (paramInt == 0)
      this.elementData = new Object[1];
    else
      this.elementData = new Object[paramInt];
  }

  public void add(int paramInt, Object paramObject)
  {
    if (paramInt > this.elementCount)
      throw new IndexOutOfBoundsException("Index out of bounds: " + paramInt + ">" + this.elementCount);
    if (paramInt < 0)
      throw new IndexOutOfBoundsException("Index out of bounds: " + paramInt + " < 0");
    if (this.elementCount >= this.elementData.length)
      increaseCapacity();
    for (int i = this.elementCount; i > paramInt; i--)
      this.elementData[i] = this.elementData[(i - 1)];
    this.elementData[paramInt] = paramObject;
    this.elementCount += 1;
  }

  public boolean add(Object paramObject)
  {
    if (this.elementCount >= this.elementData.length)
      increaseCapacity();
    this.elementData[this.elementCount] = paramObject;
    this.elementCount += 1;
    return true;
  }

  public Object get(int paramInt)
  {
    if (paramInt >= this.elementCount)
      throw new IndexOutOfBoundsException("Index out of bounds: " + paramInt + " >= " + this.elementCount);
    if (paramInt < 0)
      throw new IndexOutOfBoundsException("Index out of bounds: " + paramInt + " < 0");
    return this.elementData[paramInt];
  }

  public int indexOf(Object paramObject)
  {
    for (int i = 0; i < this.elementCount; i++)
      if (this.elementData[i].equals(paramObject))
        return i;
    return -1;
  }

  public Object remove(int paramInt)
  {
    if (paramInt >= this.elementCount)
      throw new IndexOutOfBoundsException("Index out of bounds: " + paramInt + " >= " + this.elementCount);
    if (paramInt < 0)
      throw new IndexOutOfBoundsException("Index out of bounds: " + paramInt + " < 0");
    Object localObject = this.elementData[paramInt];
    for (int i = paramInt; i < this.elementCount - 1; i++)
      this.elementData[i] = this.elementData[(i + 1)];
    this.elementCount -= 1;
    this.elementData[this.elementCount] = null;
    if ((this.minimizeOnClear) && (this.elementCount == 0))
      this.elementData = new Object[10];
    return localObject;
  }

  public Object set(int paramInt, Object paramObject)
  {
    if (paramInt >= this.elementCount)
      throw new IndexOutOfBoundsException("Index out of bounds: " + paramInt + " >= " + this.elementCount);
    if (paramInt < 0)
      throw new IndexOutOfBoundsException("Index out of bounds: " + paramInt + " < 0");
    Object localObject = this.elementData[paramInt];
    this.elementData[paramInt] = paramObject;
    return localObject;
  }

  public final int size()
  {
    return this.elementCount;
  }

  private void increaseCapacity()
  {
    int i = this.elementData.length == 0 ? 1 : this.elementData.length;
    Object[] arrayOfObject = new Object[(int)(i * 2.0F)];
    System.arraycopy(this.elementData, 0, arrayOfObject, 0, this.elementData.length);
    this.elementData = arrayOfObject;
    arrayOfObject = null;
  }

  public void trim()
  {
    Object[] arrayOfObject = new Object[this.elementCount];
    System.arraycopy(this.elementData, 0, arrayOfObject, 0, this.elementCount);
    this.elementData = arrayOfObject;
    arrayOfObject = null;
  }

  public void clear()
  {
    if ((this.minimizeOnClear) && (this.elementData.length > 10))
    {
      this.elementData = new Object[10];
      this.elementCount = 0;
      return;
    }
    for (int i = 0; i < this.elementCount; i++)
      this.elementData[i] = null;
    this.elementCount = 0;
  }

  public void setSize(int paramInt)
  {
    if (paramInt < this.elementCount)
    {
      if ((this.minimizeOnClear) && (paramInt == 0) && (this.elementData.length > 10))
      {
        this.elementData = new Object[10];
        this.elementCount = 0;
        return;
      }
      for (int i = paramInt; i < this.elementCount; i++)
        this.elementData[i] = null;
    }
    this.elementCount = paramInt;
    while (this.elementCount > this.elementData.length)
      increaseCapacity();
  }

  public Object[] toArray()
  {
    Object[] arrayOfObject = new Object[this.elementCount];
    System.arraycopy(this.elementData, 0, arrayOfObject, 0, this.elementCount);
    return arrayOfObject;
  }

  public Object[] toArray(int paramInt1, int paramInt2)
  {
    Object[] arrayOfObject = new Object[this.elementCount - paramInt2];
    System.arraycopy(this.elementData, paramInt1, arrayOfObject, 0, this.elementCount - paramInt2);
    return arrayOfObject;
  }

  public Object toArray(Object paramObject)
  {
    if (Array.getLength(paramObject) < this.elementCount)
      paramObject = Array.newInstance(paramObject.getClass().getComponentType(), this.elementCount);
    System.arraycopy(this.elementData, 0, paramObject, 0, this.elementCount);
    return paramObject;
  }

  public void sort(ObjectComparator paramObjectComparator)
  {
    if (this.elementCount < 2)
      return;
    Sort.sort(this.elementData, paramObjectComparator, 0, this.elementCount - 1);
  }

  public Object[] getArray()
  {
    return this.elementData;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.lib.HsqlArrayList
 * JD-Core Version:    0.6.0
 */