package org.hsqldb.lib;

import java.util.NoSuchElementException;

abstract class BaseList
{
  protected int elementCount;

  abstract Object get(int paramInt);

  abstract Object remove(int paramInt);

  abstract boolean add(Object paramObject);

  abstract int size();

  public boolean contains(Object paramObject)
  {
    return find(paramObject) != -1;
  }

  public boolean remove(Object paramObject)
  {
    int i = find(paramObject);
    if (i == -1)
      return false;
    remove(i);
    return true;
  }

  int find(Object paramObject)
  {
    int i = 0;
    int j = size();
    while (i < j)
    {
      Object localObject = get(i);
      if (localObject == null)
      {
        if (paramObject == null)
          return i;
      }
      else if (localObject.equals(paramObject))
        return i;
      i++;
    }
    return -1;
  }

  public boolean addAll(Collection paramCollection)
  {
    int i = 0;
    Iterator localIterator = paramCollection.iterator();
    while (localIterator.hasNext())
    {
      i = 1;
      add(localIterator.next());
    }
    return i;
  }

  public boolean isEmpty()
  {
    return this.elementCount == 0;
  }

  public String toString()
  {
    StringBuffer localStringBuffer = new StringBuffer(32 + this.elementCount * 3);
    localStringBuffer.append("List : size=");
    localStringBuffer.append(this.elementCount);
    localStringBuffer.append(' ');
    localStringBuffer.append('{');
    Iterator localIterator = iterator();
    while (localIterator.hasNext())
    {
      localStringBuffer.append(localIterator.next());
      if (!localIterator.hasNext())
        continue;
      localStringBuffer.append(',');
      localStringBuffer.append(' ');
    }
    localStringBuffer.append('}');
    return localStringBuffer.toString();
  }

  public Iterator iterator()
  {
    return new BaseListIterator(null);
  }

  private class BaseListIterator
    implements Iterator
  {
    int counter;
    boolean removed;
    private final BaseList this$0;

    private BaseListIterator()
    {
      this.this$0 = this$1;
      this.counter = 0;
    }

    public boolean hasNext()
    {
      return this.counter < this.this$0.elementCount;
    }

    public Object next()
    {
      if (this.counter < this.this$0.elementCount)
      {
        this.removed = false;
        Object localObject = this.this$0.get(this.counter);
        this.counter += 1;
        return localObject;
      }
      throw new NoSuchElementException();
    }

    public int nextInt()
    {
      throw new NoSuchElementException();
    }

    public long nextLong()
    {
      throw new NoSuchElementException();
    }

    public void remove()
    {
      if (this.removed)
        throw new NoSuchElementException("Iterator");
      this.removed = true;
      if (this.counter != 0)
      {
        this.this$0.remove(this.counter - 1);
        this.counter -= 1;
        return;
      }
      throw new NoSuchElementException();
    }

    BaseListIterator(BaseList.1 arg2)
    {
      this();
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.lib.BaseList
 * JD-Core Version:    0.6.0
 */