package org.hsqldb.jdbc;

import java.sql.SQLException;
import java.sql.SQLWarning;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Trace;

public class Util
{
  static final void throwError(HsqlException paramHsqlException)
    throws SQLException
  {
    throw new SQLException(paramHsqlException.getMessage(), paramHsqlException.getSQLState(), paramHsqlException.getErrorCode());
  }

  static final void throwError(Result paramResult)
    throws SQLException
  {
    throw new SQLException(paramResult.getMainString(), paramResult.getSubString(), paramResult.getStatementID());
  }

  public static final SQLException sqlException(HsqlException paramHsqlException)
  {
    return new SQLException(paramHsqlException.getMessage(), paramHsqlException.getSQLState(), paramHsqlException.getErrorCode());
  }

  public static final SQLWarning sqlWarning(HsqlException paramHsqlException)
  {
    return new SQLWarning(paramHsqlException.getMessage(), paramHsqlException.getSQLState(), paramHsqlException.getErrorCode());
  }

  static final SQLException sqlException(int paramInt)
  {
    return sqlException(Trace.error(paramInt));
  }

  static final SQLException sqlException(int paramInt, String paramString)
  {
    return sqlException(Trace.error(paramInt, paramString));
  }

  static final SQLException sqlException(int paramInt1, int paramInt2, Object[] paramArrayOfObject)
  {
    return sqlException(Trace.error(paramInt1, paramInt2, paramArrayOfObject));
  }

  static final SQLException notSupported()
  {
    return sqlException(Trace.error(20));
  }

  public static SQLException nullArgument()
  {
    return sqlException(62);
  }

  static SQLException nullArgument(String paramString)
  {
    return sqlException(62, paramString + ": null");
  }

  public static SQLException invalidArgument()
  {
    return sqlException(62);
  }

  public static SQLException invalidArgument(String paramString)
  {
    return sqlException(62, paramString);
  }

  public static SQLException outOfRangeArgument()
  {
    return sqlException(62);
  }

  public static SQLException outOfRangeArgument(String paramString)
  {
    return sqlException(62, paramString);
  }

  public static SQLException connectionClosedException()
  {
    return sqlException(2);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.jdbc.Util
 * JD-Core Version:    0.6.0
 */