package org.hsqldb;

import org.hsqldb.persist.Logger;

class Transaction
{
  boolean isDelete;
  Table tTable;
  Row row;
  long SCN;

  Transaction(boolean paramBoolean, Table paramTable, Row paramRow, long paramLong)
  {
    this.isDelete = paramBoolean;
    this.tTable = paramTable;
    this.row = paramRow;
  }

  void rollback(Session paramSession, boolean paramBoolean)
  {
    try
    {
      if (this.isDelete)
        this.tTable.insertNoCheckRollback(paramSession, this.row, paramBoolean);
      else
        this.tTable.deleteNoCheckRollback(paramSession, this.row, paramBoolean);
    }
    catch (Exception localException)
    {
    }
  }

  void commit(Session paramSession)
  {
    try
    {
      if (this.isDelete)
        this.tTable.removeRowFromStore(this.row);
      else
        this.tTable.commitRowToStore(this.row);
    }
    catch (Exception localException)
    {
    }
  }

  void logRollback(Session paramSession)
  {
    try
    {
      if (this.isDelete)
        this.tTable.database.logger.writeInsertStatement(paramSession, this.tTable, this.row.getData());
      else
        this.tTable.database.logger.writeDeleteStatement(paramSession, this.tTable, this.row.getData());
    }
    catch (Exception localException)
    {
    }
  }

  void logAction(Session paramSession)
  {
    try
    {
      if (this.isDelete)
        this.tTable.database.logger.writeDeleteStatement(paramSession, this.tTable, this.row.getData());
      else
        this.tTable.database.logger.writeInsertStatement(paramSession, this.tTable, this.row.getData());
    }
    catch (Exception localException)
    {
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.Transaction
 * JD-Core Version:    0.6.0
 */