package org.hsqldb;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.hsqldb.lib.HashSet;
import org.hsqldb.store.ValuePool;

public class SetFunction
{
  private HashSet distinctValues;
  private boolean isDistinct;
  private int setType;
  private int type;
  private int count;
  private boolean hasNull;
  private boolean every = true;
  private boolean some = false;
  private long currentLong;
  private double currentDouble;
  private BigDecimal currentBigDecimal;
  private Object currentValue;
  static BigInteger multiplier = BigInteger.valueOf(4294967296L);
  long hi;
  long lo;
  private double sk;
  private double vk;
  private long n;
  private boolean initialized;
  private boolean sample;

  SetFunction(int paramInt1, int paramInt2, boolean paramBoolean)
  {
    this.setType = paramInt1;
    this.type = paramInt2;
    if (paramBoolean)
    {
      this.isDistinct = true;
      this.distinctValues = new HashSet();
    }
    if ((paramInt1 == 50) || (paramInt1 == 48))
      this.sample = true;
  }

  void add(Session paramSession, Object paramObject)
    throws HsqlException
  {
    if (paramObject == null)
    {
      this.hasNull = true;
      return;
    }
    if ((this.isDistinct) && (!this.distinctValues.add(paramObject)))
      return;
    this.count += 1;
    switch (this.setType)
    {
    case 40:
      return;
    case 41:
    case 44:
      switch (this.type)
      {
      case -6:
      case 4:
      case 5:
        this.currentLong += ((Number)paramObject).intValue();
        return;
      case -5:
        addLong(((Number)paramObject).longValue());
        return;
      case 6:
      case 7:
      case 8:
        this.currentDouble += ((Number)paramObject).doubleValue();
        return;
      case 2:
      case 3:
        if (this.currentBigDecimal == null)
          this.currentBigDecimal = ((BigDecimal)paramObject);
        else
          this.currentBigDecimal = this.currentBigDecimal.add((BigDecimal)paramObject);
        return;
      case -4:
      case -3:
      case -2:
      case -1:
      case 0:
      case 1:
      }
      throw Trace.error(15);
    case 42:
      if (this.currentValue == null)
      {
        this.currentValue = paramObject;
        return;
      }
      if (Column.compare(paramSession.database.collation, this.currentValue, paramObject, this.type) > 0)
        this.currentValue = paramObject;
      return;
    case 43:
      if (this.currentValue == null)
      {
        this.currentValue = paramObject;
        return;
      }
      if (Column.compare(paramSession.database.collation, this.currentValue, paramObject, this.type) < 0)
        this.currentValue = paramObject;
      return;
    case 45:
      if (!(paramObject instanceof Boolean))
        throw Trace.error(16);
      this.every &= ((Boolean)paramObject).booleanValue();
      return;
    case 46:
      if (!(paramObject instanceof Boolean))
        throw Trace.error(16);
      this.some |= ((Boolean)paramObject).booleanValue();
      return;
    case 47:
    case 48:
    case 49:
    case 50:
      if (!(paramObject instanceof Number))
        throw Trace.error(16);
      addDataPoint((Number)paramObject);
      return;
    }
  }

  Object getValue()
    throws HsqlException
  {
    if (this.setType == 40)
      return ValuePool.getInt(this.count);
    if (this.count == 0)
      return null;
    switch (this.setType)
    {
    case 44:
      switch (this.type)
      {
      case -6:
      case 4:
      case 5:
        return new Long(this.currentLong / this.count);
      case -5:
        long l = getLongSum().divide(BigInteger.valueOf(this.count)).longValue();
        return new Long(l);
      case 6:
      case 7:
      case 8:
        return new Double(this.currentDouble / this.count);
      case 2:
      case 3:
        return this.currentBigDecimal.divide(new BigDecimal(this.count), 5);
      case -4:
      case -3:
      case -2:
      case -1:
      case 0:
      case 1:
      }
      throw Trace.error(15);
    case 41:
      switch (this.type)
      {
      case -6:
      case 4:
      case 5:
        return new Long(this.currentLong);
      case -5:
        return new BigDecimal(getLongSum());
      case 6:
      case 7:
      case 8:
        return new Double(this.currentDouble);
      case 2:
      case 3:
        return this.currentBigDecimal;
      case -4:
      case -3:
      case -2:
      case -1:
      case 0:
      case 1:
      }
      throw Trace.error(15);
    case 42:
    case 43:
      return this.currentValue;
    case 45:
      return this.every ? Boolean.TRUE : Boolean.FALSE;
    case 46:
      return this.some ? Boolean.TRUE : Boolean.FALSE;
    case 47:
    case 48:
      return getStdDev();
    case 49:
    case 50:
      return getVariance();
    }
    throw Trace.error(95);
  }

  static int getType(int paramInt1, int paramInt2)
    throws HsqlException
  {
    switch (paramInt1)
    {
    case 40:
      return 4;
    case 44:
      switch (paramInt2)
      {
      case -6:
      case -5:
      case 4:
      case 5:
        return -5;
      case 6:
      case 7:
      case 8:
        return 8;
      case 2:
      case 3:
        return 3;
      case -4:
      case -3:
      case -2:
      case -1:
      case 0:
      case 1:
      }
      return 0;
    case 41:
      switch (paramInt2)
      {
      case -6:
      case 4:
      case 5:
        return -5;
      case -5:
        return 3;
      case 6:
      case 7:
      case 8:
        return 8;
      case 2:
      case 3:
        return 3;
      case -4:
      case -3:
      case -2:
      case -1:
      case 0:
      case 1:
      }
      return 0;
    case 42:
    case 43:
      return paramInt2;
    case 45:
    case 46:
      return 16;
    case 47:
    case 48:
    case 49:
    case 50:
      return 8;
    }
    throw Trace.error(95);
  }

  void addLong(long paramLong)
  {
    if (paramLong != 0L)
      if (paramLong > 0L)
      {
        this.hi += (paramLong >> 32);
        this.lo += (paramLong & 0xFFFFFFFF);
      }
      else if (paramLong == -9223372036854775808L)
      {
        this.hi -= 2147483648L;
      }
      else
      {
        long l = (paramLong ^ 0xFFFFFFFF) + 1L;
        this.hi -= (l >> 32);
        this.lo -= (l & 0xFFFFFFFF);
      }
  }

  BigInteger getLongSum()
    throws HsqlException
  {
    BigInteger localBigInteger1 = BigInteger.valueOf(this.lo);
    BigInteger localBigInteger2 = BigInteger.valueOf(this.hi);
    BigInteger localBigInteger3 = localBigInteger2.multiply(multiplier).add(localBigInteger1);
    return localBigInteger3;
  }

  private void addDataPoint(Number paramNumber)
  {
    if (paramNumber == null)
      return;
    double d1 = paramNumber.doubleValue();
    if (!this.initialized)
    {
      this.n = 1L;
      this.sk = d1;
      this.vk = 0.0D;
      this.initialized = true;
      return;
    }
    this.n += 1L;
    long l = this.n - 1L;
    double d2 = this.sk - d1 * l;
    this.vk += d2 * d2 / this.n / l;
    this.sk += d1;
  }

  private Number getVariance()
  {
    if (!this.initialized)
      return null;
    return this.sample ? new Double(this.vk / (this.n - 1L)) : this.n == 1L ? null : new Double(this.vk / this.n);
  }

  private Number getStdDev()
  {
    if (!this.initialized)
      return null;
    return this.sample ? new Double(Math.sqrt(this.vk / (this.n - 1L))) : this.n == 1L ? null : new Double(Math.sqrt(this.vk / this.n));
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.SetFunction
 * JD-Core Version:    0.6.0
 */