package org.hsqldb;

import org.hsqldb.lib.StringUtil;

class Like
{
  private char[] cLike;
  private int[] wildCardType;
  private int iLen;
  private boolean isIgnoreCase;
  private int iFirstWildCard;
  private boolean isNull;
  Character escapeChar;
  boolean hasCollation;
  boolean optimised;
  static final int UNDERSCORE_CHAR = 1;
  static final int PERCENT_CHAR = 2;

  Like(Character paramCharacter, boolean paramBoolean)
  {
    this.escapeChar = paramCharacter;
    this.hasCollation = paramBoolean;
  }

  void setParams(Session paramSession, String paramString, boolean paramBoolean)
  {
    this.isIgnoreCase = paramBoolean;
    normalize(paramSession, paramString);
    this.optimised = true;
  }

  void resetPattern(Session paramSession, String paramString)
  {
    normalize(paramSession, paramString);
  }

  private String getStartsWith()
  {
    if (this.iLen == 0)
      return "";
    StringBuffer localStringBuffer = new StringBuffer();
    for (int i = 0; (i < this.iLen) && (this.wildCardType[i] == 0); i++)
      localStringBuffer.append(this.cLike[i]);
    if (i == 0)
      return null;
    return localStringBuffer.toString();
  }

  Boolean compare(Session paramSession, String paramString)
  {
    if (paramString == null)
      return null;
    if (this.isIgnoreCase)
      paramString = paramSession.database.collation.toUpperCase(paramString);
    return compareAt(paramString, 0, 0, paramString.length()) ? Boolean.TRUE : Boolean.FALSE;
  }

  private boolean compareAt(String paramString, int paramInt1, int paramInt2, int paramInt3)
  {
    while (paramInt1 < this.iLen)
    {
      switch (this.wildCardType[paramInt1])
      {
      case 0:
        if ((paramInt2 < paramInt3) && (this.cLike[paramInt1] == paramString.charAt(paramInt2++)))
          break;
        return false;
      case 1:
        if (paramInt2++ < paramInt3)
          break;
        return false;
      case 2:
        paramInt1++;
        if (paramInt1 >= this.iLen)
          return true;
        while (paramInt2 < paramInt3)
        {
          if ((this.cLike[paramInt1] == paramString.charAt(paramInt2)) && (compareAt(paramString, paramInt1, paramInt2, paramInt3)))
            return true;
          paramInt2++;
        }
        return false;
      }
      paramInt1++;
    }
    return paramInt2 == paramInt3;
  }

  private void normalize(Session paramSession, String paramString)
  {
    this.isNull = (paramString == null);
    if ((!this.isNull) && (this.isIgnoreCase))
      paramString = paramSession.database.collation.toUpperCase(paramString);
    this.iLen = 0;
    this.iFirstWildCard = -1;
    int i = paramString == null ? 0 : paramString.length();
    this.cLike = new char[i];
    this.wildCardType = new int[i];
    int j = 0;
    int k = 0;
    for (int m = 0; m < i; m++)
    {
      int n = paramString.charAt(m);
      if (j == 0)
      {
        if ((this.escapeChar != null) && (this.escapeChar.charValue() == n))
        {
          j = 1;
          continue;
        }
        if (n == 95)
        {
          this.wildCardType[this.iLen] = 1;
          if (this.iFirstWildCard == -1)
            this.iFirstWildCard = this.iLen;
        }
        else if (n == 37)
        {
          if (k != 0)
            continue;
          k = 1;
          this.wildCardType[this.iLen] = 2;
          if (this.iFirstWildCard == -1)
            this.iFirstWildCard = this.iLen;
        }
        else
        {
          k = 0;
        }
      }
      else
      {
        k = 0;
        j = 0;
      }
      this.cLike[(this.iLen++)] = n;
    }
    for (m = 0; m < this.iLen - 1; m++)
    {
      if ((this.wildCardType[m] != 2) || (this.wildCardType[(m + 1)] != 1))
        continue;
      this.wildCardType[m] = 1;
      this.wildCardType[(m + 1)] = 2;
    }
  }

  boolean hasWildcards()
  {
    return this.iFirstWildCard != -1;
  }

  boolean isEquivalentToFalsePredicate()
  {
    return this.isNull;
  }

  boolean isEquivalentToEqualsPredicate()
  {
    return this.iFirstWildCard == -1;
  }

  boolean isEquivalentToNotNullPredicate()
  {
    if ((this.isNull) || (!hasWildcards()))
      return false;
    for (int i = 0; i < this.wildCardType.length; i++)
      if (this.wildCardType[i] != 2)
        return false;
    return true;
  }

  boolean isEquivalentToBetweenPredicate()
  {
    return (this.iFirstWildCard > 0) && (this.iFirstWildCard == this.wildCardType.length - 1) && (this.cLike[this.iFirstWildCard] == '%');
  }

  boolean isEquivalentToBetweenPredicateAugmentedWithLike()
  {
    return (this.iFirstWildCard > 0) && (this.cLike[this.iFirstWildCard] == '%');
  }

  String getRangeLow()
  {
    return getStartsWith();
  }

  String getRangeHigh()
  {
    String str = getStartsWith();
    return str == null ? null : str.concat("￿");
  }

  public String describe(Session paramSession)
  {
    StringBuffer localStringBuffer = new StringBuffer();
    localStringBuffer.append(super.toString()).append("[\n");
    localStringBuffer.append("escapeChar=").append(this.escapeChar).append('\n');
    localStringBuffer.append("isNull=").append(this.isNull).append('\n');
    localStringBuffer.append("optimised=").append(this.optimised).append('\n');
    localStringBuffer.append("isIgnoreCase=").append(this.isIgnoreCase).append('\n');
    localStringBuffer.append("iLen=").append(this.iLen).append('\n');
    localStringBuffer.append("iFirstWildCard=").append(this.iFirstWildCard).append('\n');
    localStringBuffer.append("cLike=");
    localStringBuffer.append(StringUtil.arrayToString(this.cLike));
    localStringBuffer.append('\n');
    localStringBuffer.append("wildCardType=");
    localStringBuffer.append(StringUtil.arrayToString(this.wildCardType));
    localStringBuffer.append(']');
    return localStringBuffer.toString();
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.Like
 * JD-Core Version:    0.6.0
 */