package org.hsqldb;

import java.sql.Connection;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Random;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.store.ValuePool;

public class Library
{
  static final SimpleDateFormat tocharFormat = new SimpleDateFormat();
  static final SimpleDateFormat daynameFormat = new SimpleDateFormat("EEEE", Locale.ENGLISH);
  static final SimpleDateFormat monthnameFormat = new SimpleDateFormat("MMMM", Locale.ENGLISH);
  static final StringBuffer daynameBuffer = new StringBuffer();
  static final StringBuffer monthnameBuffer = new StringBuffer();
  static final FieldPosition monthPosition = new FieldPosition(2);
  static final FieldPosition dayPosition = new FieldPosition(9);
  public static final String[][] sNumeric = { { "ABS", "org.hsqldb.Library.abs" }, { "ACOS", "java.lang.Math.acos" }, { "ASIN", "java.lang.Math.asin" }, { "ATAN", "java.lang.Math.atan" }, { "ATAN2", "java.lang.Math.atan2" }, { "CEILING", "java.lang.Math.ceil" }, { "COS", "java.lang.Math.cos" }, { "COT", "org.hsqldb.Library.cot" }, { "DEGREES", "java.lang.Math.toDegrees" }, { "EXP", "java.lang.Math.exp" }, { "FLOOR", "java.lang.Math.floor" }, { "LOG", "java.lang.Math.log" }, { "LOG10", "org.hsqldb.Library.log10" }, { "MOD", "org.hsqldb.Library.mod" }, { "PI", "org.hsqldb.Library.pi" }, { "POWER", "java.lang.Math.pow" }, { "RADIANS", "java.lang.Math.toRadians" }, { "RAND", "java.lang.Math.random" }, { "ROUND", "org.hsqldb.Library.round" }, { "SIGN", "org.hsqldb.Library.sign" }, { "SIN", "java.lang.Math.sin" }, { "SQRT", "java.lang.Math.sqrt" }, { "TAN", "java.lang.Math.tan" }, { "TRUNCATE", "org.hsqldb.Library.truncate" }, { "BITAND", "org.hsqldb.Library.bitand" }, { "BITOR", "org.hsqldb.Library.bitor" }, { "BITXOR", "org.hsqldb.Library.bitxor" }, { "ROUNDMAGIC", "org.hsqldb.Library.roundMagic" } };
  public static final String[][] sString = { { "ASCII", "org.hsqldb.Library.ascii" }, { "BIT_LENGTH", "org.hsqldb.Library.bitLength" }, { "CHAR", "org.hsqldb.Library.character" }, { "CHAR_LENGTH", "org.hsqldb.Library.length" }, { "CHARACTER_LENGTH", "org.hsqldb.Library.length" }, { "CONCAT", "org.hsqldb.Library.concat" }, { "DIFFERENCE", "org.hsqldb.Library.difference" }, { "HEXTORAW", "org.hsqldb.Library.hexToRaw" }, { "INSERT", "org.hsqldb.Library.insert" }, { "LCASE", "org.hsqldb.Library.lcase" }, { "LEFT", "org.hsqldb.Library.left" }, { "LENGTH", "org.hsqldb.Library.length" }, { "LOCATE", "org.hsqldb.Library.locate" }, { "LTRIM", "org.hsqldb.Library.ltrim" }, { "OCTET_LENGTH", "org.hsqldb.Library.octetLength" }, { "RAWTOHEX", "org.hsqldb.Library.rawToHex" }, { "REPEAT", "org.hsqldb.Library.repeat" }, { "REPLACE", "org.hsqldb.Library.replace" }, { "RIGHT", "org.hsqldb.Library.right" }, { "RTRIM", "org.hsqldb.Library.rtrim" }, { "SOUNDEX", "org.hsqldb.Library.soundex" }, { "SPACE", "org.hsqldb.Library.space" }, { "SUBSTR", "org.hsqldb.Library.substring" }, { "SUBSTRING", "org.hsqldb.Library.substring" }, { "UCASE", "org.hsqldb.Library.ucase" }, { "LOWER", "org.hsqldb.Library.lcase" }, { "UPPER", "org.hsqldb.Library.ucase" } };
  public static final String[][] sTimeDate = { { "CURDATE", "org.hsqldb.Library.curdate" }, { "CURTIME", "org.hsqldb.Library.curtime" }, { "DATEDIFF", "org.hsqldb.Library.datediff" }, { "DAYNAME", "org.hsqldb.Library.dayname" }, { "DAY", "org.hsqldb.Library.dayofmonth" }, { "DAYOFMONTH", "org.hsqldb.Library.dayofmonth" }, { "DAYOFWEEK", "org.hsqldb.Library.dayofweek" }, { "DAYOFYEAR", "org.hsqldb.Library.dayofyear" }, { "HOUR", "org.hsqldb.Library.hour" }, { "MINUTE", "org.hsqldb.Library.minute" }, { "MONTH", "org.hsqldb.Library.month" }, { "MONTHNAME", "org.hsqldb.Library.monthname" }, { "NOW", "org.hsqldb.Library.now" }, { "QUARTER", "org.hsqldb.Library.quarter" }, { "SECOND", "org.hsqldb.Library.second" }, { "WEEK", "org.hsqldb.Library.week" }, { "YEAR", "org.hsqldb.Library.year" }, { "TO_CHAR", "org.hsqldb.Library.to_char" } };
  public static final String[][] sSystem = { { "DATABASE", "org.hsqldb.Library.database" }, { "USER", "org.hsqldb.Library.user" }, { "IDENTITY", "org.hsqldb.Library.identity" } };
  private static final Random rRandom = new Random();
  private static final double LOG10_FACTOR = 0.4342944819032518D;
  static final int abs = 0;
  static final int ascii = 1;
  static final int bitand = 2;
  static final int bitLength = 3;
  static final int bitor = 4;
  static final int bitxor = 5;
  static final int character = 6;
  static final int concat = 7;
  static final int cot = 8;
  static final int curdate = 9;
  static final int curtime = 10;
  static final int database = 11;
  static final int datediff = 12;
  static final int day = 13;
  static final int dayname = 14;
  static final int dayofmonth = 15;
  static final int dayofweek = 16;
  static final int dayofyear = 17;
  static final int difference = 18;
  static final int getAutoCommit = 19;
  static final int getDatabaseFullProductVersion = 20;
  static final int getDatabaseMajorVersion = 21;
  static final int getDatabaseMinorVersion = 22;
  static final int getDatabaseProductName = 23;
  static final int getDatabaseProductVersion = 24;
  static final int hexToRaw = 25;
  static final int hour = 26;
  static final int identity = 27;
  static final int insert = 28;
  static final int isReadOnlyConnection = 29;
  static final int isReadOnlyDatabase = 30;
  static final int isReadOnlyDatabaseFiles = 31;
  static final int lcase = 32;
  static final int left = 33;
  static final int length = 34;
  static final int locate = 35;
  static final int log10 = 36;
  static final int ltrim = 37;
  static final int minute = 38;
  static final int mod = 39;
  static final int month = 40;
  static final int monthname = 41;
  static final int now = 42;
  static final int octetLength = 43;
  static final int pi = 44;
  static final int position = 45;
  static final int quarter = 46;
  static final int rand = 47;
  static final int rawToHex = 48;
  static final int repeat = 49;
  static final int replace = 50;
  static final int right = 51;
  static final int round = 52;
  static final int roundMagic = 53;
  static final int rtrim = 54;
  static final int second = 55;
  static final int sign = 56;
  static final int soundex = 57;
  static final int space = 58;
  static final int substring = 59;
  static final int to_char = 60;
  static final int trim = 61;
  static final int truncate = 62;
  static final int ucase = 63;
  static final int user = 64;
  static final int week = 65;
  static final int year = 66;
  private static final IntValueHashMap functionMap = new IntValueHashMap(67);
  static final Double piValue = new Double(pi());
  static final String prefix = "org.hsqldb.Library.";
  static final int prefixLength;

  static HashMap getAliasMap()
  {
    HashMap localHashMap = new HashMap(83, 1.0F);
    register(localHashMap, sNumeric);
    register(localHashMap, sString);
    register(localHashMap, sTimeDate);
    register(localHashMap, sSystem);
    return localHashMap;
  }

  private static void register(HashMap paramHashMap, String[][] paramArrayOfString)
  {
    for (int i = 0; i < paramArrayOfString.length; i++)
      paramHashMap.put(paramArrayOfString[i][0], paramArrayOfString[i][1]);
  }

  public static double rand(Integer paramInteger)
  {
    synchronized (rRandom)
    {
      if (paramInteger != null)
        rRandom.setSeed(paramInteger.intValue());
      return rRandom.nextDouble();
    }
  }

  public static double abs(double paramDouble)
  {
    return Math.abs(paramDouble);
  }

  public static double log10(double paramDouble)
  {
    return roundMagic(Math.log(paramDouble) * 0.4342944819032518D);
  }

  public static double roundMagic(double paramDouble)
  {
    if ((paramDouble < 1.0E-13D) && (paramDouble > -1.0E-13D))
      return 0.0D;
    if ((paramDouble > 1000000000000.0D) || (paramDouble < -1000000000000.0D))
      return paramDouble;
    StringBuffer localStringBuffer = new StringBuffer();
    localStringBuffer.append(paramDouble);
    int i = localStringBuffer.length();
    if (i < 16)
      return paramDouble;
    int j = localStringBuffer.charAt(i - 1);
    int k = localStringBuffer.charAt(i - 2);
    int m = localStringBuffer.charAt(i - 3);
    int n = localStringBuffer.charAt(i - 4);
    if ((k == 48) && (m == 48) && (n == 48) && (j != 46))
    {
      localStringBuffer.setCharAt(i - 1, '0');
    }
    else if ((k == 57) && (m == 57) && (n == 57) && (j != 46))
    {
      localStringBuffer.setCharAt(i - 1, '9');
      localStringBuffer.append('9');
      localStringBuffer.append('9');
    }
    return Double.valueOf(localStringBuffer.toString()).doubleValue();
  }

  public static double cot(double paramDouble)
  {
    return 1.0D / Math.tan(paramDouble);
  }

  public static int mod(int paramInt1, int paramInt2)
  {
    return paramInt1 % paramInt2;
  }

  public static double pi()
  {
    return 3.141592653589793D;
  }

  public static double round(double paramDouble, int paramInt)
  {
    double d = Math.pow(10.0D, paramInt);
    return Math.round(paramDouble * d) / d;
  }

  public static int sign(double paramDouble)
  {
    return paramDouble > 0.0D ? 1 : paramDouble < 0.0D ? -1 : 0;
  }

  public static double truncate(double paramDouble, int paramInt)
  {
    double d1 = Math.pow(10.0D, paramInt);
    double d2 = paramDouble * d1;
    return (paramDouble < 0.0D ? Math.ceil(d2) : Math.floor(d2)) / d1;
  }

  public static int bitand(int paramInt1, int paramInt2)
  {
    return paramInt1 & paramInt2;
  }

  public static int bitor(int paramInt1, int paramInt2)
  {
    return paramInt1 | paramInt2;
  }

  public static int bitxor(int paramInt1, int paramInt2)
  {
    return paramInt1 ^ paramInt2;
  }

  public static Integer ascii(String paramString)
  {
    if ((paramString == null) || (paramString.length() == 0))
      return null;
    return ValuePool.getInt(paramString.charAt(0));
  }

  public static String character(int paramInt)
  {
    return String.valueOf((char)paramInt);
  }

  public static String concat(String paramString1, String paramString2)
  {
    if (paramString1 == null)
    {
      if (paramString2 == null)
        return null;
      return paramString2;
    }
    if (paramString2 == null)
      return paramString1;
    return paramString1.concat(paramString2);
  }

  public static int difference(String paramString1, String paramString2)
  {
    if ((paramString1 == null) || (paramString2 == null))
      return 0;
    paramString1 = soundex(paramString1);
    paramString2 = soundex(paramString2);
    int i = 0;
    for (int j = 0; j < 4; j++)
    {
      if (paramString1.charAt(j) == paramString2.charAt(j))
        continue;
      i++;
    }
    return i;
  }

  public static String hexToRaw(String paramString)
  {
    if (paramString == null)
      return null;
    StringBuffer localStringBuffer = new StringBuffer();
    int i = paramString.length();
    if (i % 4 != 0)
      return null;
    for (int j = 0; j < i; j += 4)
    {
      char c = (char)Integer.parseInt(paramString.substring(j, j + 4), 16);
      localStringBuffer.append(c);
    }
    return localStringBuffer.toString();
  }

  public static String insert(String paramString1, int paramInt1, int paramInt2, String paramString2)
  {
    if (paramString1 == null)
      return paramString2;
    if (paramString2 == null)
      return paramString1;
    int i = paramString1.length();
    int j = paramString2.length();
    paramInt1--;
    if ((paramInt1 < 0) || (paramInt2 <= 0) || (j == 0) || (paramInt1 > i))
      return paramString1;
    if (paramInt1 + paramInt2 > i)
      paramInt2 = i - paramInt1;
    return paramString1.substring(0, paramInt1) + paramString2 + paramString1.substring(paramInt1 + paramInt2);
  }

  public static String lcase(String paramString)
  {
    return paramString == null ? null : paramString.toLowerCase();
  }

  public static String left(String paramString, int paramInt)
  {
    if (paramString == null)
      return null;
    return paramString.substring(0, paramInt < paramString.length() ? paramInt : paramInt < 0 ? 0 : paramString.length());
  }

  public static Integer length(String paramString)
  {
    return paramString == null ? null : ValuePool.getInt(paramString.length());
  }

  public static Integer octetLength(String paramString)
  {
    return paramString == null ? null : ValuePool.getInt(paramString.length() * 2);
  }

  public static Integer bitLength(String paramString)
  {
    return paramString == null ? null : ValuePool.getInt(paramString.length() * 16);
  }

  public static int locate(String paramString1, String paramString2, Integer paramInteger)
  {
    if ((paramString2 == null) || (paramString1 == null))
      return 0;
    int i = paramInteger == null ? 0 : paramInteger.intValue() - 1;
    return paramString2.indexOf(paramString1, i < 0 ? 0 : i) + 1;
  }

  public static int position(String paramString1, String paramString2)
  {
    return locate(paramString1, paramString2, null);
  }

  public static String ltrim(String paramString)
  {
    if (paramString == null)
      return paramString;
    int i = paramString.length();
    for (int j = 0; (j < i) && (paramString.charAt(j) <= ' '); j++);
    return j == 0 ? paramString : paramString.substring(j);
  }

  public static String rawToHex(String paramString)
  {
    if (paramString == null)
      return null;
    char[] arrayOfChar = paramString.toCharArray();
    StringBuffer localStringBuffer = new StringBuffer(4 * paramString.length());
    for (int i = 0; i < arrayOfChar.length; i++)
    {
      String str = Integer.toHexString(arrayOfChar[i] & 0xFFFF);
      for (int j = str.length(); j < 4; j++)
        localStringBuffer.append('0');
      localStringBuffer.append(str);
    }
    return localStringBuffer.toString();
  }

  public static String repeat(String paramString, Integer paramInteger)
  {
    if ((paramString == null) || (paramInteger == null) || (paramInteger.intValue() < 0))
      return null;
    int i = paramInteger.intValue();
    StringBuffer localStringBuffer = new StringBuffer(paramString.length() * i);
    while (i-- > 0)
      localStringBuffer.append(paramString);
    return localStringBuffer.toString();
  }

  public static String replace(String paramString1, String paramString2, String paramString3)
  {
    if ((paramString1 == null) || (paramString2 == null))
      return paramString1;
    if (paramString3 == null)
      paramString3 = "";
    StringBuffer localStringBuffer = new StringBuffer();
    int i = 0;
    int j = paramString2.length();
    while (true)
    {
      int k = paramString1.indexOf(paramString2, i);
      if (k == -1)
      {
        localStringBuffer.append(paramString1.substring(i));
        break;
      }
      localStringBuffer.append(paramString1.substring(i, k));
      localStringBuffer.append(paramString3);
      i = k + j;
    }
    return localStringBuffer.toString();
  }

  public static String right(String paramString, int paramInt)
  {
    if (paramString == null)
      return null;
    paramInt = paramString.length() - paramInt;
    return paramString.substring(paramInt < paramString.length() ? paramInt : paramInt < 0 ? 0 : paramString.length());
  }

  public static String rtrim(String paramString)
  {
    if (paramString == null)
      return paramString;
    int i = paramString.length() - 1;
    for (int j = i; (j >= 0) && (paramString.charAt(j) == ' '); j--);
    return j == i ? paramString : paramString.substring(0, j + 1);
  }

  public static String trim(String paramString1, String paramString2, boolean paramBoolean1, boolean paramBoolean2)
  {
    if (paramString1 == null)
      return paramString1;
    int i = paramString2.charAt(0);
    int j = paramString1.length();
    if (paramBoolean2)
    {
      j--;
      while ((j >= 0) && (paramString1.charAt(j) == i))
        j--;
      j++;
    }
    if (j == 0)
      return "";
    int k = 0;
    if (paramBoolean1)
      while ((k < j) && (paramString1.charAt(k) == i))
        k++;
    if ((k == 0) && (j == paramString1.length()))
      return paramString1;
    return paramString1.substring(k, j);
  }

  public static String soundex(String paramString)
  {
    if (paramString == null)
      return paramString;
    paramString = paramString.toUpperCase(Locale.ENGLISH);
    int i = paramString.length();
    char[] arrayOfChar = { '0', '0', '0', '0' };
    int j = 48;
    int k = 0;
    int m = 0;
    while ((k < i) && (m < 4))
    {
      int n = paramString.charAt(k);
      int i1;
      if ("AEIOUY".indexOf(n) != -1)
      {
        i1 = 55;
      }
      else if ((n == 72) || (n == 87))
      {
        i1 = 56;
      }
      else if ("BFPV".indexOf(n) != -1)
      {
        i1 = 49;
      }
      else if ("CGJKQSXZ".indexOf(n) != -1)
      {
        i1 = 50;
      }
      else if ((n == 68) || (n == 84))
      {
        i1 = 51;
      }
      else if (n == 76)
      {
        i1 = 52;
      }
      else if ((n == 77) || (n == 78))
      {
        i1 = 53;
      }
      else
      {
        if (n != 82)
          break label272;
        i1 = 54;
      }
      if (m == 0)
      {
        arrayOfChar[(m++)] = n;
        j = i1;
      }
      else if (i1 <= 54)
      {
        if (i1 != j)
        {
          arrayOfChar[(m++)] = i1;
          j = i1;
        }
      }
      else if (i1 == 55)
      {
        j = i1;
      }
      label272: k++;
    }
    return new String(arrayOfChar, 0, 4);
  }

  public static String space(int paramInt)
  {
    if (paramInt < 0)
      return null;
    char[] arrayOfChar = new char[paramInt];
    while (paramInt > 0)
    {
      paramInt--;
      arrayOfChar[paramInt] = ' ';
    }
    return new String(arrayOfChar);
  }

  public static String substring(String paramString, int paramInt, Integer paramInteger)
  {
    if (paramString == null)
      return null;
    int i = paramString.length();
    int j = paramInteger == null ? i : paramInteger.intValue();
    if (j < 1)
      return null;
    if (paramInt < 0)
      paramInt = i + paramInt;
    else if (paramInt > 0)
      paramInt--;
    if ((paramInt < 0) || (paramInt >= i))
      return null;
    if (paramInt > i - j)
      j = i - paramInt;
    return paramString.substring(paramInt, paramInt + j);
  }

  public static String ucase(String paramString)
  {
    return paramString == null ? null : paramString.toUpperCase();
  }

  public static java.sql.Date curdate(Connection paramConnection)
  {
    return null;
  }

  public static Time curtime(Connection paramConnection)
  {
    return null;
  }

  public static String dayname(java.sql.Date paramDate)
  {
    if (paramDate == null)
      return null;
    synchronized (daynameBuffer)
    {
      daynameBuffer.setLength(0);
      return daynameFormat.format(paramDate, daynameBuffer, dayPosition).toString();
    }
  }

  public static Integer dayofmonth(java.sql.Date paramDate)
  {
    if (paramDate == null)
      return null;
    return ValuePool.getInt(HsqlDateTime.getDateTimePart(paramDate, 5));
  }

  public static Integer dayofweek(java.sql.Date paramDate)
  {
    if (paramDate == null)
      return null;
    return ValuePool.getInt(HsqlDateTime.getDateTimePart(paramDate, 7));
  }

  public static Integer dayofyear(java.sql.Date paramDate)
  {
    if (paramDate == null)
      return null;
    return ValuePool.getInt(HsqlDateTime.getDateTimePart(paramDate, 6));
  }

  public static Integer hour(Time paramTime)
  {
    if (paramTime == null)
      return null;
    return ValuePool.getInt(HsqlDateTime.getDateTimePart(paramTime, 11));
  }

  public static Integer minute(Time paramTime)
  {
    if (paramTime == null)
      return null;
    return ValuePool.getInt(HsqlDateTime.getDateTimePart(paramTime, 12));
  }

  public static Integer month(java.sql.Date paramDate)
  {
    if (paramDate == null)
      return null;
    return ValuePool.getInt(HsqlDateTime.getDateTimePart(paramDate, 2) + 1);
  }

  public static String monthname(java.sql.Date paramDate)
  {
    if (paramDate == null)
      return null;
    synchronized (monthnameBuffer)
    {
      monthnameBuffer.setLength(0);
      return monthnameFormat.format(paramDate, monthnameBuffer, monthPosition).toString();
    }
  }

  public static Timestamp now(Connection paramConnection)
  {
    return null;
  }

  public static Integer quarter(java.sql.Date paramDate)
  {
    if (paramDate == null)
      return null;
    return ValuePool.getInt(HsqlDateTime.getDateTimePart(paramDate, 2) / 3 + 1);
  }

  public static Integer second(Time paramTime)
  {
    if (paramTime == null)
      return null;
    return ValuePool.getInt(HsqlDateTime.getDateTimePart(paramTime, 13));
  }

  public static Integer week(java.sql.Date paramDate)
  {
    if (paramDate == null)
      return null;
    return ValuePool.getInt(HsqlDateTime.getDateTimePart(paramDate, 3));
  }

  public static Integer year(java.sql.Date paramDate)
  {
    if (paramDate == null)
      return null;
    return ValuePool.getInt(HsqlDateTime.getDateTimePart(paramDate, 1));
  }

  public static String to_char(java.util.Date paramDate, String paramString)
  {
    if ((paramDate == null) || (paramString == null))
      return null;
    synchronized (tocharFormat)
    {
      tocharFormat.applyPattern(HsqlDateTime.toJavaDatePattern(paramString));
      return tocharFormat.format(paramDate);
    }
  }

  public static Long datediff(String paramString, Timestamp paramTimestamp1, Timestamp paramTimestamp2)
    throws HsqlException
  {
    if ((paramTimestamp1 == null) || (paramTimestamp2 == null))
      return null;
    if (("yy".equalsIgnoreCase(paramString)) || ("year".equalsIgnoreCase(paramString)))
      return ValuePool.getLong(getElapsed(1, paramTimestamp1, paramTimestamp2));
    if (("mm".equalsIgnoreCase(paramString)) || ("month".equalsIgnoreCase(paramString)))
      return ValuePool.getLong(getElapsed(2, paramTimestamp1, paramTimestamp2));
    if (("dd".equalsIgnoreCase(paramString)) || ("day".equalsIgnoreCase(paramString)))
      return ValuePool.getLong(getElapsed(5, paramTimestamp1, paramTimestamp2));
    if (("hh".equalsIgnoreCase(paramString)) || ("hour".equalsIgnoreCase(paramString)))
      return ValuePool.getLong(getElapsed(10, paramTimestamp1, paramTimestamp2));
    if (("mi".equalsIgnoreCase(paramString)) || ("minute".equalsIgnoreCase(paramString)))
      return ValuePool.getLong(getElapsed(12, paramTimestamp1, paramTimestamp2));
    if (("ss".equalsIgnoreCase(paramString)) || ("second".equalsIgnoreCase(paramString)))
      return ValuePool.getLong(getElapsed(13, paramTimestamp1, paramTimestamp2));
    if (("ms".equalsIgnoreCase(paramString)) || ("millisecond".equalsIgnoreCase(paramString)))
      return ValuePool.getLong(getElapsed(14, paramTimestamp1, paramTimestamp2));
    throw Trace.error(95);
  }

  private static long getElapsed(int paramInt, java.util.Date paramDate1, java.util.Date paramDate2)
  {
    if (paramInt == 14)
      return paramDate2.getTime() - paramDate1.getTime();
    Object localObject1 = Calendar.getInstance();
    Object localObject2 = Calendar.getInstance();
    ((Calendar)localObject1).setTime(paramDate1);
    ((Calendar)localObject2).setTime(paramDate2);
    ((Calendar)localObject1).set(14, 0);
    ((Calendar)localObject2).set(14, 0);
    if (paramInt == 13)
      return (((Calendar)localObject2).getTime().getTime() - ((Calendar)localObject1).getTime().getTime()) / 1000L;
    ((Calendar)localObject1).set(13, 0);
    ((Calendar)localObject2).set(13, 0);
    if (paramInt == 12)
      return (((Calendar)localObject2).getTime().getTime() - ((Calendar)localObject1).getTime().getTime()) / 60000L;
    ((Calendar)localObject1).set(12, 0);
    ((Calendar)localObject2).set(12, 0);
    if (paramInt == 10)
      return (((Calendar)localObject2).getTime().getTime() - ((Calendar)localObject1).getTime().getTime()) / 3600000L;
    long l = 0L;
    int i = 1;
    if (((Calendar)localObject2).before(localObject1))
    {
      i = -1;
      Object localObject3 = localObject1;
      localObject1 = localObject2;
      localObject2 = localObject3;
    }
    ((Calendar)localObject1).set(11, 0);
    ((Calendar)localObject2).set(11, 0);
    if ((paramInt == 2) || (paramInt == 1))
    {
      ((Calendar)localObject1).set(5, 1);
      ((Calendar)localObject2).set(5, 1);
    }
    if (paramInt == 1)
    {
      ((Calendar)localObject1).set(2, 1);
      ((Calendar)localObject2).set(2, 1);
    }
    while (((Calendar)localObject1).before(localObject2))
    {
      ((Calendar)localObject1).add(paramInt, 1);
      l += 1L;
    }
    return i * l;
  }

  public static String database(Connection paramConnection)
    throws HsqlException
  {
    return null;
  }

  public static String user(Connection paramConnection)
    throws HsqlException
  {
    return null;
  }

  public static int identity()
    throws HsqlException
  {
    return 0;
  }

  public static boolean getAutoCommit(Connection paramConnection)
  {
    return false;
  }

  public static String getDatabaseFullProductVersion()
  {
    return "1.8.0.8";
  }

  public static String getDatabaseProductName()
  {
    return "HSQL Database Engine";
  }

  public static String getDatabaseProductVersion()
  {
    return "1.8.0";
  }

  public static int getDatabaseMajorVersion()
  {
    return 1;
  }

  public static int getDatabaseMinorVersion()
  {
    return 8;
  }

  public static boolean isReadOnlyConnection(Connection paramConnection)
  {
    return false;
  }

  public static boolean isReadOnlyDatabase(Connection paramConnection)
  {
    return false;
  }

  public static boolean isReadOnlyDatabaseFiles(Connection paramConnection)
  {
    return false;
  }

  static Object invoke(int paramInt, Object[] paramArrayOfObject)
    throws HsqlException
  {
    try
    {
      switch (paramInt)
      {
      case 0:
        return new Double(abs(((Number)paramArrayOfObject[0]).doubleValue()));
      case 1:
        return ascii((String)paramArrayOfObject[0]);
      case 2:
        return ValuePool.getInt(bitand(((Number)paramArrayOfObject[0]).intValue(), ((Number)paramArrayOfObject[1]).intValue()));
      case 3:
        return bitLength((String)paramArrayOfObject[0]);
      case 4:
        return ValuePool.getInt(bitor(((Number)paramArrayOfObject[0]).intValue(), ((Number)paramArrayOfObject[1]).intValue()));
      case 5:
        return ValuePool.getInt(bitxor(((Number)paramArrayOfObject[0]).intValue(), ((Number)paramArrayOfObject[1]).intValue()));
      case 6:
        return character(((Number)paramArrayOfObject[0]).intValue());
      case 7:
        return concat((String)paramArrayOfObject[0], (String)paramArrayOfObject[1]);
      case 8:
        return new Double(cot(((Number)paramArrayOfObject[0]).doubleValue()));
      case 9:
        return null;
      case 10:
        return null;
      case 11:
        return null;
      case 12:
        return datediff((String)paramArrayOfObject[0], (Timestamp)paramArrayOfObject[1], (Timestamp)paramArrayOfObject[2]);
      case 14:
        return dayname((java.sql.Date)paramArrayOfObject[0]);
      case 13:
      case 15:
        return dayofmonth((java.sql.Date)paramArrayOfObject[0]);
      case 16:
        return dayofweek((java.sql.Date)paramArrayOfObject[0]);
      case 17:
        return dayofyear((java.sql.Date)paramArrayOfObject[0]);
      case 18:
        return ValuePool.getInt(difference((String)paramArrayOfObject[0], (String)paramArrayOfObject[1]));
      case 19:
        return null;
      case 20:
        return getDatabaseFullProductVersion();
      case 21:
        return ValuePool.getInt(getDatabaseMajorVersion());
      case 22:
        return ValuePool.getInt(getDatabaseMinorVersion());
      case 23:
        return getDatabaseProductName();
      case 24:
        return getDatabaseProductVersion();
      case 25:
        return hexToRaw((String)paramArrayOfObject[0]);
      case 26:
        return hour((Time)paramArrayOfObject[0]);
      case 27:
        return null;
      case 28:
        return insert((String)paramArrayOfObject[0], ((Number)paramArrayOfObject[1]).intValue(), ((Number)paramArrayOfObject[2]).intValue(), (String)paramArrayOfObject[3]);
      case 29:
        return null;
      case 30:
        return null;
      case 32:
        return lcase((String)paramArrayOfObject[0]);
      case 33:
        return left((String)paramArrayOfObject[0], ((Number)paramArrayOfObject[1]).intValue());
      case 34:
        return length((String)paramArrayOfObject[0]);
      case 35:
        return ValuePool.getInt(locate((String)paramArrayOfObject[0], (String)paramArrayOfObject[1], (Integer)paramArrayOfObject[2]));
      case 36:
        return new Double(log10(((Number)paramArrayOfObject[0]).doubleValue()));
      case 37:
        return ltrim((String)paramArrayOfObject[0]);
      case 38:
        return minute((Time)paramArrayOfObject[0]);
      case 39:
        return ValuePool.getInt(mod(((Number)paramArrayOfObject[0]).intValue(), ((Number)paramArrayOfObject[1]).intValue()));
      case 40:
        return month((java.sql.Date)paramArrayOfObject[0]);
      case 41:
        return ValuePool.getString(monthname((java.sql.Date)paramArrayOfObject[0]));
      case 42:
        return null;
      case 43:
        return octetLength((String)paramArrayOfObject[0]);
      case 45:
        return ValuePool.getInt(position((String)paramArrayOfObject[0], (String)paramArrayOfObject[1]));
      case 44:
        return piValue;
      case 46:
        return quarter((java.sql.Date)paramArrayOfObject[0]);
      case 47:
        return new Double(rand((Integer)paramArrayOfObject[0]));
      case 48:
        return rawToHex((String)paramArrayOfObject[0]);
      case 49:
        return repeat((String)paramArrayOfObject[0], (Integer)paramArrayOfObject[1]);
      case 50:
        return replace((String)paramArrayOfObject[0], (String)paramArrayOfObject[1], (String)paramArrayOfObject[2]);
      case 51:
        return right((String)paramArrayOfObject[0], ((Number)paramArrayOfObject[1]).intValue());
      case 52:
        return new Double(round(((Number)paramArrayOfObject[0]).doubleValue(), ((Number)paramArrayOfObject[1]).intValue()));
      case 53:
        return new Double(roundMagic(((Number)paramArrayOfObject[0]).doubleValue()));
      case 54:
        return rtrim((String)paramArrayOfObject[0]);
      case 55:
        return second((Time)paramArrayOfObject[0]);
      case 56:
        return ValuePool.getInt(sign(((Number)paramArrayOfObject[0]).doubleValue()));
      case 57:
        return soundex((String)paramArrayOfObject[0]);
      case 58:
        return space(((Number)paramArrayOfObject[0]).intValue());
      case 59:
        return substring((String)paramArrayOfObject[0], ((Number)paramArrayOfObject[1]).intValue(), (Integer)paramArrayOfObject[2]);
      case 61:
        return trim((String)paramArrayOfObject[0], (String)paramArrayOfObject[1], ((Boolean)paramArrayOfObject[2]).booleanValue(), ((Boolean)paramArrayOfObject[3]).booleanValue());
      case 62:
        return new Double(truncate(((Number)paramArrayOfObject[0]).doubleValue(), ((Number)paramArrayOfObject[1]).intValue()));
      case 63:
        return ucase((String)paramArrayOfObject[0]);
      case 64:
        return null;
      case 65:
        return week((java.sql.Date)paramArrayOfObject[0]);
      case 66:
        return year((java.sql.Date)paramArrayOfObject[0]);
      case 60:
        return to_char((java.util.Date)paramArrayOfObject[0], (String)paramArrayOfObject[1]);
      case 31:
        return null;
      }
      Trace.doAssert(false);
      return null;
    }
    catch (Exception localException)
    {
    }
    throw Trace.error(198, localException.toString());
  }

  static int functionID(String paramString)
  {
    return paramString.startsWith("org.hsqldb.Library.") ? functionMap.get(paramString.substring(prefixLength), -1) : -1;
  }

  static
  {
    functionMap.put("abs", 0);
    functionMap.put("ascii", 1);
    functionMap.put("bitand", 2);
    functionMap.put("bitlength", 3);
    functionMap.put("bitor", 4);
    functionMap.put("bitxor", 4);
    functionMap.put("character", 6);
    functionMap.put("concat", 7);
    functionMap.put("cot", 8);
    functionMap.put("curdate", 9);
    functionMap.put("curtime", 10);
    functionMap.put("database", 11);
    functionMap.put("datediff", 12);
    functionMap.put("dayname", 14);
    functionMap.put("day", 13);
    functionMap.put("dayofmonth", 15);
    functionMap.put("dayofweek", 16);
    functionMap.put("dayofyear", 17);
    functionMap.put("difference", 18);
    functionMap.put("getAutoCommit", 19);
    functionMap.put("getDatabaseFullProductVersion", 20);
    functionMap.put("getDatabaseMajorVersion", 21);
    functionMap.put("getDatabaseMinorVersion", 22);
    functionMap.put("getDatabaseProductName", 23);
    functionMap.put("getDatabaseProductVersion", 24);
    functionMap.put("hexToRaw", 25);
    functionMap.put("hour", 26);
    functionMap.put("identity", 27);
    functionMap.put("insert", 28);
    functionMap.put("isReadOnlyConnection", 29);
    functionMap.put("isReadOnlyDatabase", 30);
    functionMap.put("isReadOnlyDatabaseFiles", 31);
    functionMap.put("lcase", 32);
    functionMap.put("left", 33);
    functionMap.put("length", 34);
    functionMap.put("locate", 35);
    functionMap.put("log10", 36);
    functionMap.put("ltrim", 37);
    functionMap.put("minute", 38);
    functionMap.put("mod", 39);
    functionMap.put("month", 40);
    functionMap.put("monthname", 41);
    functionMap.put("now", 42);
    functionMap.put("octetLength", 43);
    functionMap.put("pi", 44);
    functionMap.put("position", 45);
    functionMap.put("quarter", 46);
    functionMap.put("rand", 47);
    functionMap.put("rawToHex", 48);
    functionMap.put("repeat", 49);
    functionMap.put("replace", 50);
    functionMap.put("right", 51);
    functionMap.put("round", 52);
    functionMap.put("roundMagic", 53);
    functionMap.put("rtrim", 54);
    functionMap.put("second", 55);
    functionMap.put("sign", 56);
    functionMap.put("soundex", 57);
    functionMap.put("space", 58);
    functionMap.put("substring", 59);
    functionMap.put("to_char", 60);
    functionMap.put("trim", 61);
    functionMap.put("truncate", 62);
    functionMap.put("ucase", 63);
    functionMap.put("user", 64);
    functionMap.put("week", 65);
    functionMap.put("year", 66);
    prefixLength = "org.hsqldb.Library.".length();
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.Library
 * JD-Core Version:    0.6.0
 */