package org.hsqldb;

import java.util.NoSuchElementException;
import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.ArrayUtil;

public class Index
{
  static final int MEMORY_INDEX = 0;
  static final int DISK_INDEX = 1;
  static final int POINTER_INDEX = 2;
  private final HsqlNameManager.HsqlName indexName;
  final boolean[] colCheck;
  private final int[] colIndex;
  private final int[] colTypes;
  final int[] pkCols;
  final int[] pkTypes;
  private final boolean isUnique;
  private final boolean useRowId;
  final boolean isConstraint;
  final boolean isForward;
  final boolean isTemp;
  private Node root;
  private int depth;
  final Collation collation;
  static IndexRowIterator emptyIterator = new IndexRowIterator(null, null, null, null);
  IndexRowIterator updatableIterators;
  final boolean onCommitPreserve;
  final Table table;

  Index(Database paramDatabase, HsqlNameManager.HsqlName paramHsqlName, Table paramTable, int[] paramArrayOfInt1, int[] paramArrayOfInt2, boolean paramBoolean1, boolean paramBoolean2, boolean paramBoolean3, boolean paramBoolean4, int[] paramArrayOfInt3, int[] paramArrayOfInt4, boolean paramBoolean5)
  {
    this.table = paramTable;
    this.indexName = paramHsqlName;
    this.colIndex = paramArrayOfInt1;
    this.colTypes = paramArrayOfInt2;
    this.pkCols = paramArrayOfInt3;
    this.pkTypes = paramArrayOfInt4;
    this.isUnique = paramBoolean2;
    this.isConstraint = paramBoolean3;
    this.isForward = paramBoolean4;
    this.useRowId = (((!this.isUnique) && (this.pkCols.length == 0)) || (this.colIndex.length == 0));
    this.colCheck = paramTable.getNewColumnCheckList();
    ArrayUtil.intIndexesToBooleanArray(this.colIndex, this.colCheck);
    this.updatableIterators = new IndexRowIterator(null, null, null, null);
    this.updatableIterators.next = (this.updatableIterators.last = this.updatableIterators);
    this.collation = paramDatabase.collation;
    this.isTemp = paramBoolean5;
    this.onCommitPreserve = paramTable.onCommitPreserve;
  }

  HsqlNameManager.HsqlName getName()
  {
    return this.indexName;
  }

  void setName(String paramString, boolean paramBoolean)
    throws HsqlException
  {
    this.indexName.rename(paramString, paramBoolean);
  }

  int getVisibleColumns()
  {
    return this.colIndex.length;
  }

  boolean isUnique()
  {
    return this.isUnique;
  }

  boolean isConstraint()
  {
    return this.isConstraint;
  }

  int[] getColumns()
  {
    return this.colIndex;
  }

  int[] getColumnTypes()
  {
    return this.colTypes;
  }

  String getColumnNameList()
  {
    String str = "";
    for (int i = 0; i < this.colIndex.length; i++)
    {
      str = str + this.table.getColumn(this.colIndex[i]).columnName.statementName;
      if (i >= this.colIndex.length - 1)
        continue;
      str = str + ",";
    }
    return str;
  }

  int size(Session paramSession)
    throws HsqlException
  {
    int i = 0;
    RowIterator localRowIterator = firstRow(paramSession);
    while (localRowIterator.hasNext())
    {
      localRowIterator.next();
      i++;
    }
    return i;
  }

  boolean isEmpty(Session paramSession)
  {
    return getRoot(paramSession) == null;
  }

  public int sizeEstimate()
    throws HsqlException
  {
    firstRow(null);
    return (int)(1L << this.depth);
  }

  void clearAll(Session paramSession)
  {
    setRoot(paramSession, null);
    this.depth = 0;
    this.updatableIterators.next = (this.updatableIterators.last = this.updatableIterators);
  }

  void clearIterators()
  {
    this.updatableIterators.next = (this.updatableIterators.last = this.updatableIterators);
  }

  void setRoot(Session paramSession, Node paramNode)
  {
    if (this.isTemp)
      paramSession.setIndexRoot(this.indexName, this.onCommitPreserve, paramNode);
    else
      this.root = paramNode;
  }

  int getRoot()
  {
    return this.root == null ? -1 : this.root.getKey();
  }

  private Node getRoot(Session paramSession)
  {
    if ((this.isTemp) && (paramSession != null))
      return paramSession.getIndexRoot(this.indexName, this.onCommitPreserve);
    return this.root;
  }

  void insert(Session paramSession, Row paramRow, int paramInt)
    throws HsqlException
  {
    Node localNode1 = getRoot(paramSession);
    Node localNode2 = localNode1;
    boolean bool = true;
    int i = -1;
    while (true)
    {
      if (localNode1 == null)
      {
        if (localNode2 == null)
        {
          setRoot(paramSession, paramRow.getNode(paramInt));
          return;
        }
        set(localNode2, bool, paramRow.getNode(paramInt));
        break;
      }
      i = compareRowForInsert(paramSession, paramRow, localNode1.getRow());
      if (i == 0)
      {
        int j = 9;
        String str = this.indexName.statementName;
        if (this.isConstraint)
        {
          Constraint localConstraint = this.table.getUniqueOrPKConstraintForIndex(this);
          if (localConstraint != null)
          {
            str = localConstraint.getName().name;
            j = 104;
          }
        }
        throw Trace.error(j, new Object[] { str, getColumnNameList() });
      }
      bool = i < 0;
      localNode2 = localNode1;
      localNode1 = child(localNode2, bool);
    }
    balance(paramSession, localNode2, bool);
  }

  private void balance(Session paramSession, Node paramNode, boolean paramBoolean)
    throws HsqlException
  {
    while (true)
    {
      int i = paramBoolean ? 1 : -1;
      paramNode = paramNode.getUpdatedNode();
      switch (paramNode.getBalance() * i)
      {
      case 1:
        paramNode.setBalance(0);
        return;
      case 0:
        paramNode.setBalance(-i);
        break;
      case -1:
        Node localNode1 = child(paramNode, paramBoolean);
        if (localNode1.getBalance() == -i)
        {
          replace(paramSession, paramNode, localNode1);
          set(paramNode, paramBoolean, child(localNode1, !paramBoolean));
          set(localNode1, !paramBoolean, paramNode);
          paramNode = paramNode.getUpdatedNode();
          paramNode.setBalance(0);
          localNode1 = localNode1.getUpdatedNode();
          localNode1.setBalance(0);
        }
        else
        {
          Node localNode2 = child(localNode1, !paramBoolean);
          replace(paramSession, paramNode, localNode2);
          set(localNode1, !paramBoolean, child(localNode2.getUpdatedNode(), paramBoolean));
          set(localNode2, paramBoolean, localNode1);
          set(paramNode, paramBoolean, child(localNode2.getUpdatedNode(), !paramBoolean));
          set(localNode2, !paramBoolean, paramNode);
          int j = localNode2.getUpdatedNode().getBalance();
          paramNode.getUpdatedNode().setBalance(j == -i ? i : 0);
          localNode1.getUpdatedNode().setBalance(j == i ? -i : 0);
          localNode2.getUpdatedNode().setBalance(0);
        }
        return;
      }
      paramNode = paramNode.getUpdatedNode();
      if (paramNode.isRoot())
        return;
      paramBoolean = paramNode.isFromLeft();
      paramNode = paramNode.getParent();
    }
  }

  void delete(Session paramSession, Node paramNode)
    throws HsqlException
  {
    if (paramNode == null)
      return;
    for (Object localObject = this.updatableIterators.next; localObject != this.updatableIterators; localObject = ((IndexRowIterator)localObject).next)
      ((IndexRowIterator)localObject).updateForDelete(paramNode);
    int i;
    Node localNode3;
    Node localNode5;
    if (paramNode.getLeft() == null)
    {
      localObject = paramNode.getRight();
    }
    else if (paramNode.getRight() == null)
    {
      localObject = paramNode.getLeft();
    }
    else
    {
      Node localNode1 = paramNode;
      paramNode = paramNode.getLeft();
      Node localNode2 = paramNode;
      while ((localNode2 = localNode2.getRight()) != null)
        paramNode = localNode2;
      localObject = paramNode.getLeft();
      i = paramNode.getBalance();
      paramNode = paramNode.getUpdatedNode();
      paramNode.setBalance(localNode1.getBalance());
      localNode1 = localNode1.getUpdatedNode();
      localNode1.setBalance(i);
      localNode3 = paramNode.getParent();
      Node localNode4 = localNode1.getParent();
      paramNode = paramNode.getUpdatedNode();
      if (localNode1.isRoot())
        setRoot(paramSession, paramNode);
      paramNode.setParent(localNode4);
      if (localNode4 != null)
      {
        localNode4 = localNode4.getUpdatedNode();
        if (localNode4.isRight(localNode1))
          localNode4.setRight(paramNode);
        else
          localNode4.setLeft(paramNode);
      }
      localNode1 = localNode1.getUpdatedNode();
      if (localNode1.equals(localNode3))
      {
        localNode1.setParent(paramNode);
        if (localNode1.isLeft(paramNode))
        {
          paramNode = paramNode.getUpdatedNode();
          paramNode.setLeft(localNode1);
          localNode5 = localNode1.getRight();
          paramNode = paramNode.getUpdatedNode();
          paramNode.setRight(localNode5);
        }
        else
        {
          paramNode.setRight(localNode1);
          localNode5 = localNode1.getLeft();
          paramNode = paramNode.getUpdatedNode();
          paramNode.setLeft(localNode5);
        }
      }
      else
      {
        localNode1.setParent(localNode3);
        localNode3 = localNode3.getUpdatedNode();
        localNode3.setRight(localNode1);
        localNode5 = localNode1.getLeft();
        Node localNode6 = localNode1.getRight();
        paramNode = paramNode.getUpdatedNode();
        paramNode.setLeft(localNode5);
        paramNode.setRight(localNode6);
      }
      paramNode.getRight().setParent(paramNode);
      paramNode.getLeft().setParent(paramNode);
      localNode1 = localNode1.getUpdatedNode();
      localNode1.setLeft((Node)localObject);
      if (localObject != null)
      {
        localObject = ((Node)localObject).getUpdatedNode();
        ((Node)localObject).setParent(localNode1);
      }
      localNode1 = localNode1.getUpdatedNode();
      localNode1.setRight(null);
      paramNode = localNode1;
    }
    boolean bool = paramNode.isFromLeft();
    replace(paramSession, paramNode, (Node)localObject);
    localObject = paramNode.getParent();
    paramNode = paramNode.getUpdatedNode();
    paramNode.delete();
    while (localObject != null)
    {
      paramNode = (Node)localObject;
      i = bool ? 1 : -1;
      paramNode = paramNode.getUpdatedNode();
      switch (paramNode.getBalance() * i)
      {
      case -1:
        paramNode.setBalance(0);
        break;
      case 0:
        paramNode.setBalance(i);
        return;
      case 1:
        localNode3 = child(paramNode, !bool);
        int j = localNode3.getBalance();
        if (j * i >= 0)
        {
          replace(paramSession, paramNode, localNode3);
          set(paramNode, !bool, child(localNode3, bool));
          set(localNode3, bool, paramNode);
          if (j == 0)
          {
            paramNode = paramNode.getUpdatedNode();
            paramNode.setBalance(i);
            localNode3 = localNode3.getUpdatedNode();
            localNode3.setBalance(-i);
            return;
          }
          paramNode = paramNode.getUpdatedNode();
          paramNode.setBalance(0);
          localNode3 = localNode3.getUpdatedNode();
          localNode3.setBalance(0);
          paramNode = localNode3;
        }
        else
        {
          localNode5 = child(localNode3, bool);
          replace(paramSession, paramNode, localNode5);
          localNode5 = localNode5.getUpdatedNode();
          j = localNode5.getBalance();
          set(localNode3, bool, child(localNode5, !bool));
          set(localNode5, !bool, localNode3);
          set(paramNode, !bool, child(localNode5, bool));
          set(localNode5, bool, paramNode);
          paramNode = paramNode.getUpdatedNode();
          paramNode.setBalance(j == i ? -i : 0);
          localNode3 = localNode3.getUpdatedNode();
          localNode3.setBalance(j == -i ? i : 0);
          localNode5 = localNode5.getUpdatedNode();
          localNode5.setBalance(0);
          paramNode = localNode5;
        }
      }
      bool = paramNode.isFromLeft();
      localObject = paramNode.getParent();
    }
  }

  RowIterator findFirstRow(Session paramSession, Object[] paramArrayOfObject, int[] paramArrayOfInt)
    throws HsqlException
  {
    Node localNode = findNotNull(paramSession, paramArrayOfObject, paramArrayOfInt, true);
    return getIterator(paramSession, localNode);
  }

  RowIterator findFirstRowForDelete(Session paramSession, Object[] paramArrayOfObject, int[] paramArrayOfInt)
    throws HsqlException
  {
    Node localNode = findNotNull(paramSession, paramArrayOfObject, paramArrayOfInt, true);
    IndexRowIterator localIndexRowIterator = getIterator(paramSession, localNode);
    if (localNode != null)
      this.updatableIterators.link(localIndexRowIterator);
    return localIndexRowIterator;
  }

  Row findRow(Session paramSession, Row paramRow)
    throws HsqlException
  {
    Node localNode = search(paramSession, paramRow);
    return localNode == null ? null : localNode.getRow();
  }

  boolean exists(Session paramSession, Object[] paramArrayOfObject, int[] paramArrayOfInt)
    throws HsqlException
  {
    return findNotNull(paramSession, paramArrayOfObject, paramArrayOfInt, true) != null;
  }

  RowIterator emptyIterator()
  {
    return emptyIterator;
  }

  private Node findNotNull(Session paramSession, Object[] paramArrayOfObject, int[] paramArrayOfInt, boolean paramBoolean)
    throws HsqlException
  {
    Object localObject1 = getRoot(paramSession);
    Object localObject2 = null;
    if (isNull(paramArrayOfObject, paramArrayOfInt))
      return null;
    while (localObject1 != null)
    {
      int i = compareRowNonUnique(paramSession, paramArrayOfObject, paramArrayOfInt, ((Node)localObject1).getData());
      Node localNode;
      if (i == 0)
      {
        if (!paramBoolean)
        {
          localObject2 = localObject1;
          break;
        }
        if (localObject2 == localObject1)
          break;
        localObject2 = localObject1;
        localNode = ((Node)localObject1).getLeft();
      }
      else if (i > 0)
      {
        localNode = ((Node)localObject1).getRight();
      }
      else
      {
        localNode = ((Node)localObject1).getLeft();
      }
      if (localNode == null)
        break;
      localObject1 = localNode;
    }
    return (Node)localObject2;
  }

  static boolean isNull(Object[] paramArrayOfObject, int[] paramArrayOfInt)
  {
    int i = paramArrayOfInt.length;
    for (int j = 0; j < i; j++)
      if (paramArrayOfObject[paramArrayOfInt[j]] == null)
        return true;
    return false;
  }

  boolean isNull(Object[] paramArrayOfObject)
  {
    int i = this.colIndex.length;
    for (int j = 0; j < i; j++)
    {
      int k = this.colIndex[j];
      if (paramArrayOfObject[k] == null)
        return true;
    }
    return false;
  }

  RowIterator findFirstRow(Session paramSession, Object[] paramArrayOfObject)
    throws HsqlException
  {
    Node localNode1 = getRoot(paramSession);
    Node localNode2 = null;
    int i = (this.isUnique) && (!isNull(paramArrayOfObject)) ? 1 : 0;
    while (localNode1 != null)
    {
      int j = compareRowNonUnique(paramSession, paramArrayOfObject, this.colIndex, localNode1.getData());
      if (j == 0)
      {
        localNode2 = localNode1;
        if (i != 0)
          break;
        localNode1 = localNode1.getLeft();
        continue;
      }
      if (j < 0)
      {
        localNode1 = localNode1.getLeft();
        continue;
      }
      localNode1 = localNode1.getRight();
    }
    return getIterator(paramSession, localNode2);
  }

  RowIterator findFirstRow(Session paramSession, Object paramObject, int paramInt)
    throws HsqlException
  {
    int i = (paramInt == 21) || (paramInt == 34) ? 1 : 0;
    Object localObject1 = getRoot(paramSession);
    int j = 1;
    if (paramInt == 23)
      j = 0;
    if ((paramObject == null) && (i == 0))
      return emptyIterator;
    while (localObject1 != null)
    {
      int k = Column.compare(this.collation, paramObject, localObject1.getData()[this.colIndex[0]], this.colTypes[0]) >= j ? 1 : 0;
      if (k != 0)
      {
        localNode = ((Node)localObject1).getRight();
        if (localNode == null)
          break;
        localObject1 = localNode;
        continue;
      }
      Node localNode = ((Node)localObject1).getLeft();
      if (localNode == null)
        break;
      localObject1 = localNode;
    }
    while (localObject1 != null)
    {
      Object localObject2 = localObject1.getData()[this.colIndex[0]];
      int m = Column.compare(this.collation, paramObject, localObject2, this.colTypes[0]);
      if (m >= j)
      {
        localObject1 = next((Node)localObject1);
        continue;
      }
      if (i != 0)
      {
        if (m == 0)
          break;
        localObject1 = null;
        break;
      }
      if (localObject2 != null)
        break;
      localObject1 = next((Node)localObject1);
    }
    return (RowIterator)getIterator(paramSession, (Node)localObject1);
  }

  RowIterator findFirstRowNotNull(Session paramSession)
    throws HsqlException
  {
    Object localObject1 = getRoot(paramSession);
    while (localObject1 != null)
    {
      int i = Column.compare(this.collation, null, localObject1.getData()[this.colIndex[0]], this.colTypes[0]) >= 0 ? 1 : 0;
      if (i != 0)
      {
        localNode = ((Node)localObject1).getRight();
        if (localNode == null)
          break;
        localObject1 = localNode;
        continue;
      }
      Node localNode = ((Node)localObject1).getLeft();
      if (localNode == null)
        break;
      localObject1 = localNode;
    }
    while (localObject1 != null)
    {
      Object localObject2 = localObject1.getData()[this.colIndex[0]];
      if (localObject2 != null)
        break;
      localObject1 = next((Node)localObject1);
    }
    return (RowIterator)getIterator(paramSession, (Node)localObject1);
  }

  RowIterator firstRow(Session paramSession)
    throws HsqlException
  {
    this.depth = 0;
    Object localObject1 = getRoot(paramSession);
    Object localObject2 = localObject1;
    while (localObject2 != null)
    {
      localObject1 = localObject2;
      localObject2 = ((Node)localObject1).getLeft();
      this.depth += 1;
    }
    return (RowIterator)(RowIterator)getIterator(paramSession, (Node)localObject1);
  }

  Row lastRow(Session paramSession)
    throws HsqlException
  {
    Object localObject1 = getRoot(paramSession);
    for (Object localObject2 = localObject1; localObject2 != null; localObject2 = ((Node)localObject1).getRight())
      localObject1 = localObject2;
    return localObject1 == null ? null : (Row)(Row)((Node)localObject1).getRow();
  }

  Node next(Node paramNode)
    throws HsqlException
  {
    if (paramNode == null)
      return null;
    Node localNode1 = paramNode.getRight();
    if (localNode1 != null)
    {
      paramNode = localNode1;
      for (localNode2 = paramNode.getLeft(); localNode2 != null; localNode2 = paramNode.getLeft())
        paramNode = localNode2;
      return paramNode;
    }
    Node localNode2 = paramNode;
    for (paramNode = paramNode.getParent(); (paramNode != null) && (localNode2.equals(paramNode.getRight())); paramNode = paramNode.getParent())
      localNode2 = paramNode;
    return paramNode;
  }

  private Node child(Node paramNode, boolean paramBoolean)
    throws HsqlException
  {
    return paramBoolean ? paramNode.getLeft() : paramNode.getRight();
  }

  private void replace(Session paramSession, Node paramNode1, Node paramNode2)
    throws HsqlException
  {
    if (paramNode1.isRoot())
    {
      if (paramNode2 != null)
      {
        paramNode2 = paramNode2.getUpdatedNode();
        paramNode2.setParent(null);
      }
      setRoot(paramSession, paramNode2);
    }
    else
    {
      set(paramNode1.getParent(), paramNode1.isFromLeft(), paramNode2);
    }
  }

  private void set(Node paramNode1, boolean paramBoolean, Node paramNode2)
    throws HsqlException
  {
    paramNode1 = paramNode1.getUpdatedNode();
    if (paramBoolean)
      paramNode1.setLeft(paramNode2);
    else
      paramNode1.setRight(paramNode2);
    if (paramNode2 != null)
    {
      paramNode2 = paramNode2.getUpdatedNode();
      paramNode2.setParent(paramNode1);
    }
  }

  private Node search(Session paramSession, Row paramRow)
    throws HsqlException
  {
    Object[] arrayOfObject = paramRow.getData();
    Node localNode = getRoot(paramSession);
    while (localNode != null)
    {
      int i = compareRowForInsert(paramSession, paramRow, localNode.getRow());
      if (i == 0)
        return localNode;
      if (i < 0)
      {
        localNode = localNode.getLeft();
        continue;
      }
      localNode = localNode.getRight();
    }
    return null;
  }

  int compareRowNonUnique(Session paramSession, Object[] paramArrayOfObject1, int[] paramArrayOfInt, Object[] paramArrayOfObject2)
    throws HsqlException
  {
    int i = Column.compare(this.collation, paramArrayOfObject1[paramArrayOfInt[0]], paramArrayOfObject2[this.colIndex[0]], this.colTypes[0]);
    if (i != 0)
      return i;
    int j = paramArrayOfInt.length;
    for (int k = 1; k < j; k++)
    {
      i = Column.compare(this.collation, paramArrayOfObject1[paramArrayOfInt[k]], paramArrayOfObject2[this.colIndex[k]], this.colTypes[k]);
      if (i != 0)
        return i;
    }
    return 0;
  }

  static int compareRows(Session paramSession, Object[] paramArrayOfObject1, Object[] paramArrayOfObject2, int[] paramArrayOfInt1, int[] paramArrayOfInt2)
    throws HsqlException
  {
    int i = paramArrayOfInt1.length;
    for (int j = 0; j < i; j++)
    {
      int k = Column.compare(paramSession.database.collation, paramArrayOfObject1[paramArrayOfInt1[j]], paramArrayOfObject2[paramArrayOfInt1[j]], paramArrayOfInt2[paramArrayOfInt1[j]]);
      if (k != 0)
        return k;
    }
    return 0;
  }

  private int compareRowForInsert(Session paramSession, Row paramRow1, Row paramRow2)
    throws HsqlException
  {
    Object[] arrayOfObject1 = paramRow1.getData();
    Object[] arrayOfObject2 = paramRow2.getData();
    int i = 0;
    int j = 0;
    Object localObject;
    int m;
    while (i < this.colIndex.length)
    {
      localObject = arrayOfObject1[this.colIndex[i]];
      m = Column.compare(this.collation, localObject, arrayOfObject2[this.colIndex[i]], this.colTypes[i]);
      if (m != 0)
        return m;
      if (localObject == null)
        j = 1;
      i++;
    }
    if ((this.isUnique) && (!this.useRowId) && (j == 0))
      return 0;
    for (i = 0; i < this.pkCols.length; i++)
    {
      localObject = arrayOfObject1[this.pkCols[i]];
      m = Column.compare(this.collation, localObject, arrayOfObject2[this.pkCols[i]], this.pkTypes[i]);
      if (m != 0)
        return m;
    }
    if (this.useRowId)
    {
      int k = paramRow1.getPos() - paramRow2.getPos();
      if (k < 0)
        k = -1;
      else if (k > 0)
        k = 1;
      return k;
    }
    return 0;
  }

  int getIndexOrderValue()
  {
    int i = 0;
    if (this.isConstraint)
      return this.isUnique ? 0 : this.isForward ? 4 : 1;
    return 2;
  }

  private IndexRowIterator getIterator(Session paramSession, Node paramNode)
  {
    if (paramNode == null)
      return emptyIterator;
    IndexRowIterator localIndexRowIterator = new IndexRowIterator(paramSession, this, paramNode, null);
    return localIndexRowIterator;
  }

  static class IndexRowIterator
    implements RowIterator
  {
    Session session;
    Index index;
    Node nextnode;
    protected IndexRowIterator last;
    protected IndexRowIterator next;

    private IndexRowIterator(Session paramSession, Index paramIndex, Node paramNode)
    {
      if (paramIndex == null)
        return;
      this.session = paramSession;
      this.index = paramIndex;
      this.nextnode = paramNode;
    }

    public boolean hasNext()
    {
      return this.nextnode != null;
    }

    public Row next()
    {
      if (hasNext())
        try
        {
          Row localRow = this.nextnode.getRow();
          this.nextnode = this.index.next(this.nextnode);
          return localRow;
        }
        catch (Exception localException)
        {
          throw new NoSuchElementException(localException.getMessage());
        }
      return null;
    }

    void updateForDelete(Node paramNode)
    {
      try
      {
        if (paramNode.equals(this.nextnode))
          this.nextnode = this.index.next(paramNode);
      }
      catch (Exception localException)
      {
      }
    }

    void link(IndexRowIterator paramIndexRowIterator)
    {
      paramIndexRowIterator.next = this.next;
      paramIndexRowIterator.last = this;
      this.next.last = paramIndexRowIterator;
      this.next = paramIndexRowIterator;
    }

    public void release()
    {
      if (this.last != null)
        this.last.next = this.next;
      if (this.next != null)
        this.next.last = this.last;
    }

    IndexRowIterator(Session paramSession, Index paramIndex, Node paramNode, Index.1 param1)
    {
      this(paramSession, paramIndex, paramNode);
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.Index
 * JD-Core Version:    0.6.0
 */