package org.hsqldb;

import org.hsqldb.lib.StringConverter;

public class HsqlNameManager
{
  private static HsqlNameManager staticManager = new HsqlNameManager();
  private int serialNumber = 1;
  private int sysNumber = 0;

  static HsqlName newHsqlSystemObjectName(String paramString)
  {
    return new HsqlName(staticManager, paramString, null);
  }

  public HsqlName newHsqlName(String paramString, boolean paramBoolean)
  {
    return new HsqlName(this, paramString, paramBoolean, null);
  }

  HsqlName newHsqlName(String paramString1, String paramString2, boolean paramBoolean)
  {
    return new HsqlName(this, paramString1, paramString2, paramBoolean, null);
  }

  HsqlName newHsqlName(String paramString)
  {
    return new HsqlName(this, paramString, null);
  }

  public HsqlName newAutoName(String paramString)
  {
    return newAutoName(paramString, null);
  }

  HsqlName newAutoName(String paramString1, String paramString2)
  {
    StringBuffer localStringBuffer = new StringBuffer();
    if (paramString1 != null)
    {
      if (paramString1.length() != 0)
      {
        localStringBuffer.append("SYS_");
        localStringBuffer.append(paramString1);
        localStringBuffer.append('_');
        if (paramString2 != null)
        {
          localStringBuffer.append(paramString2);
          localStringBuffer.append('_');
        }
        localStringBuffer.append(++this.sysNumber);
      }
    }
    else
      localStringBuffer.append(paramString2);
    return new HsqlName(this, localStringBuffer.toString(), null);
  }

  void resetNumbering()
  {
    this.sysNumber = 0;
    this.serialNumber = 0;
  }

  static
  {
    staticManager.serialNumber = -2147483648;
  }

  public static class HsqlName
  {
    HsqlNameManager manager;
    public String name;
    boolean isNameQuoted;
    public String statementName;
    public HsqlName schema;
    private final int hashCode;
    static final String[] sysPrefixes = { "SYS_IDX_", "SYS_PK_", "SYS_REF_", "SYS_CT_", "SYS_FK_" };

    private HsqlName(HsqlNameManager paramHsqlNameManager)
    {
      this.manager = paramHsqlNameManager;
      this.hashCode = HsqlNameManager.access$308(this.manager);
    }

    private HsqlName(HsqlNameManager paramHsqlNameManager, String paramString, boolean paramBoolean)
    {
      this(paramHsqlNameManager);
      rename(paramString, paramBoolean);
    }

    private HsqlName(HsqlNameManager paramHsqlNameManager, String paramString1, String paramString2, boolean paramBoolean)
    {
      this(paramHsqlNameManager);
      rename(paramString1, paramString2, paramBoolean);
    }

    private HsqlName(HsqlNameManager paramHsqlNameManager, String paramString)
    {
      this(paramHsqlNameManager);
      this.name = (this.statementName = paramString);
    }

    public void rename(String paramString, boolean paramBoolean)
    {
      this.name = paramString;
      this.statementName = paramString;
      this.isNameQuoted = paramBoolean;
      if (this.isNameQuoted)
        this.statementName = StringConverter.toQuotedString(paramString, '"', true);
      if (paramString.startsWith("SYS_"))
      {
        int i = sysPrefixLength(paramString);
        if (i > 0)
          try
          {
            int j = Integer.parseInt(paramString.substring(i));
            if (j > this.manager.sysNumber)
              HsqlNameManager.access$402(this.manager, j);
          }
          catch (NumberFormatException localNumberFormatException)
          {
          }
      }
    }

    void rename(String paramString1, String paramString2, boolean paramBoolean)
    {
      StringBuffer localStringBuffer = new StringBuffer(paramString1);
      localStringBuffer.append('_');
      localStringBuffer.append(paramString2);
      rename(localStringBuffer.toString(), paramBoolean);
    }

    public boolean equals(Object paramObject)
    {
      if ((paramObject instanceof HsqlName))
        return this.hashCode == ((HsqlName)paramObject).hashCode;
      return false;
    }

    public int hashCode()
    {
      return this.hashCode;
    }

    static int sysPrefixLength(String paramString)
    {
      for (int i = 0; i < sysPrefixes.length; i++)
        if (paramString.startsWith(sysPrefixes[i]))
          return sysPrefixes[i].length();
      return 0;
    }

    static boolean isReservedName(String paramString)
    {
      return sysPrefixLength(paramString) > 0;
    }

    boolean isReservedName()
    {
      return isReservedName(this.name);
    }

    public String toString()
    {
      return getClass().getName() + super.hashCode() + "[this.hashCode()=" + this.hashCode + ", name=" + this.name + ", name.hashCode()=" + this.name.hashCode() + ", isNameQuoted=" + this.isNameQuoted + "]";
    }

    public int compareTo(Object paramObject)
    {
      return this.hashCode - paramObject.hashCode();
    }

    static boolean isRegularIdentifier(String paramString)
    {
      int i = 0;
      int j = paramString.length();
      while (i < j)
      {
        int k = paramString.charAt(i);
        if (((k < 65) || (k > 90)) && ((k != 95) || (i <= 0)) && ((k < 48) || (k > 57)))
          return false;
        i++;
      }
      return !Token.isKeyword(paramString);
    }

    HsqlName(HsqlNameManager paramHsqlNameManager, String paramString, HsqlNameManager.1 param1)
    {
      this(paramHsqlNameManager, paramString);
    }

    HsqlName(HsqlNameManager paramHsqlNameManager, String paramString, boolean paramBoolean, HsqlNameManager.1 param1)
    {
      this(paramHsqlNameManager, paramString, paramBoolean);
    }

    HsqlName(HsqlNameManager paramHsqlNameManager, String paramString1, String paramString2, boolean paramBoolean, HsqlNameManager.1 param1)
    {
      this(paramHsqlNameManager, paramString1, paramString2, paramBoolean);
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.HsqlNameManager
 * JD-Core Version:    0.6.0
 */