package org.hsqldb;

import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;

public class Grantee
{
  boolean isRole;
  private boolean isAdminDirect = false;
  private boolean isAdmin = false;
  private IntValueHashMap fullRightsMap = new IntValueHashMap();
  private String granteeName;
  private IntValueHashMap rightsMap = new IntValueHashMap();
  HashSet roles = new HashSet();
  private Grantee pubGrantee;
  private GranteeManager granteeManager;

  Grantee(String paramString, Grantee paramGrantee, GranteeManager paramGranteeManager)
    throws HsqlException
  {
    this.granteeName = paramString;
    this.granteeManager = paramGranteeManager;
    this.pubGrantee = paramGrantee;
  }

  String getName()
  {
    return this.granteeName;
  }

  IntValueHashMap getRights()
  {
    return this.rightsMap;
  }

  public void grant(String paramString)
    throws HsqlException
  {
    this.roles.add(paramString);
  }

  public void revoke(String paramString)
    throws HsqlException
  {
    if (!hasRoleDirect(paramString))
      throw Trace.error(246, paramString);
    this.roles.remove(paramString);
  }

  public HashSet getDirectRoles()
  {
    return this.roles;
  }

  String getDirectRolesString()
  {
    return setToString(this.roles);
  }

  String getAllRolesString()
  {
    return setToString(getAllRoles());
  }

  public String setToString(Set paramSet)
  {
    Iterator localIterator = paramSet.iterator();
    StringBuffer localStringBuffer = new StringBuffer();
    while (localIterator.hasNext())
    {
      if (localStringBuffer.length() > 0)
        localStringBuffer.append(',');
      localStringBuffer.append(localIterator.next());
    }
    return localStringBuffer.toString();
  }

  public HashSet getAllRoles()
  {
    HashSet localHashSet = new HashSet();
    addGranteeAndRoles(localHashSet);
    localHashSet.remove(this.granteeName);
    return localHashSet;
  }

  private HashSet addGranteeAndRoles(HashSet paramHashSet)
  {
    paramHashSet.add(this.granteeName);
    Iterator localIterator = this.roles.iterator();
    while (localIterator.hasNext())
    {
      String str = (String)localIterator.next();
      if (paramHashSet.contains(str))
        continue;
      try
      {
        this.granteeManager.getRole(str).addGranteeAndRoles(paramHashSet);
      }
      catch (HsqlException localHsqlException)
      {
        throw new RuntimeException(localHsqlException.getMessage());
      }
    }
    return paramHashSet;
  }

  public boolean hasRoleDirect(String paramString)
  {
    return this.roles.contains(paramString);
  }

  public boolean hasRole(String paramString)
  {
    return getAllRoles().contains(paramString);
  }

  public String allRolesString()
  {
    HashSet localHashSet = getAllRoles();
    if (localHashSet.size() < 1)
      return null;
    Iterator localIterator = getAllRoles().iterator();
    StringBuffer localStringBuffer = new StringBuffer();
    while (localIterator.hasNext())
    {
      if (localStringBuffer.length() > 0)
        localStringBuffer.append(',');
      localStringBuffer.append((String)localIterator.next());
    }
    return localStringBuffer.toString();
  }

  void grant(Object paramObject, int paramInt)
  {
    if (paramInt == 0)
      return;
    int i = this.rightsMap.get(paramObject, 0);
    i |= paramInt;
    this.rightsMap.put(paramObject, i);
  }

  void revoke(Object paramObject, int paramInt)
  {
    if (paramInt == 0)
      return;
    int i = this.rightsMap.get(paramObject, 0);
    if (i == 0)
      return;
    paramInt = i & 15 - paramInt;
    if (paramInt == 0)
      this.rightsMap.remove(paramObject);
    else
      this.rightsMap.put(paramObject, paramInt);
  }

  void revokeDbObject(Object paramObject)
  {
    this.rightsMap.remove(paramObject);
    this.fullRightsMap.remove(paramObject);
  }

  void clearPrivileges()
  {
    this.roles.clear();
    this.rightsMap.clear();
    this.fullRightsMap.clear();
    this.isAdminDirect = false;
  }

  void check(HsqlNameManager.HsqlName paramHsqlName, int paramInt)
    throws HsqlException
  {
    if (!isAccessible(paramHsqlName, paramInt))
      throw Trace.error(33);
  }

  void check(String paramString)
    throws HsqlException
  {
    if (!isAccessible(paramString))
      throw Trace.error(33);
  }

  boolean isAccessible(HsqlNameManager.HsqlName paramHsqlName, int paramInt)
    throws HsqlException
  {
    if (this.isAdmin)
      return true;
    if ((this.pubGrantee != null) && (this.pubGrantee.isAccessible(paramHsqlName, paramInt)))
      return true;
    int i = this.fullRightsMap.get(paramHsqlName, 0);
    if (i != 0)
      return (i & paramInt) != 0;
    return false;
  }

  boolean isAccessible(String paramString)
    throws HsqlException
  {
    if ((paramString.startsWith("org.hsqldb.Library")) || (paramString.startsWith("java.lang.Math")))
      return true;
    if (this.isAdmin)
      return true;
    if ((this.pubGrantee != null) && (this.pubGrantee.isAccessible(paramString)))
      return true;
    int i = this.fullRightsMap.get(paramString, 0);
    return i != 0;
  }

  protected boolean isDirectlyAccessible(Object paramObject, int paramInt)
    throws HsqlException
  {
    int i = this.rightsMap.get(paramObject, 0);
    if (i != 0)
      return (i & paramInt) != 0;
    return false;
  }

  boolean isAccessible(HsqlNameManager.HsqlName paramHsqlName)
    throws HsqlException
  {
    return isAccessible(paramHsqlName, 15);
  }

  void checkAdmin()
    throws HsqlException
  {
    if (!isAdmin())
      throw Trace.error(33);
  }

  boolean isAdmin()
  {
    return this.isAdmin;
  }

  boolean isAdminDirect()
  {
    return this.isAdminDirect;
  }

  HashSet getGrantedClassNames(boolean paramBoolean)
    throws HsqlException
  {
    IntValueHashMap localIntValueHashMap = this.rightsMap;
    HashSet localHashSet = getGrantedClassNamesDirect();
    if ((paramBoolean) && (this.pubGrantee != null))
    {
      localIntValueHashMap = this.pubGrantee.rightsMap;
      Iterator localIterator1 = localIntValueHashMap.keySet().iterator();
      while (localIterator1.hasNext())
      {
        Object localObject = localIterator1.next();
        if (!(localObject instanceof String))
          continue;
        int i = localIntValueHashMap.get(localObject, 0);
        if (i != 15)
          continue;
        localHashSet.add(localObject);
      }
    }
    Iterator localIterator2 = getAllRoles().iterator();
    while (localIterator2.hasNext())
      localHashSet.addAll(this.granteeManager.getRole((String)localIterator2.next()).getGrantedClassNamesDirect());
    return localHashSet;
  }

  HashSet getGrantedClassNamesDirect()
    throws HsqlException
  {
    IntValueHashMap localIntValueHashMap = this.rightsMap;
    HashSet localHashSet = new HashSet();
    Iterator localIterator = this.rightsMap.keySet().iterator();
    while (localIterator.hasNext())
    {
      Object localObject = localIterator.next();
      if (!(localObject instanceof String))
        continue;
      int i = localIntValueHashMap.get(localObject, 0);
      if (i != 15)
        continue;
      localHashSet.add(localObject);
    }
    return localHashSet;
  }

  String[] listGrantedTablePrivileges(HsqlNameManager.HsqlName paramHsqlName)
  {
    return GranteeManager.getRightsArray(this.rightsMap.get(paramHsqlName, 0));
  }

  void setAdminDirect()
  {
    this.isAdmin = (this.isAdminDirect = 1);
  }

  boolean updateNestedRoles(String paramString)
  {
    boolean bool1 = false;
    boolean bool2 = paramString.equals(this.granteeName);
    if (!bool2)
    {
      Iterator localIterator = this.roles.iterator();
      while (localIterator.hasNext())
      {
        String str = (String)localIterator.next();
        try
        {
          Grantee localGrantee = this.granteeManager.getRole(str);
          bool1 |= localGrantee.updateNestedRoles(paramString);
        }
        catch (HsqlException localHsqlException)
        {
        }
      }
    }
    if (bool1)
      updateAllRights();
    return (bool1) || (bool2);
  }

  void updateAllRights()
  {
    this.fullRightsMap.clear();
    this.isAdmin = this.isAdminDirect;
    Iterator localIterator = this.roles.iterator();
    while (localIterator.hasNext())
    {
      String str = (String)localIterator.next();
      try
      {
        Grantee localGrantee = this.granteeManager.getRole(str);
        this.fullRightsMap.putAll(localGrantee.fullRightsMap);
        this.isAdmin |= localGrantee.isAdmin();
      }
      catch (HsqlException localHsqlException)
      {
      }
    }
    this.fullRightsMap.putAll(this.rightsMap);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.Grantee
 * JD-Core Version:    0.6.0
 */