/*     */ package org.apache.xml.resolver.tools;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import org.apache.xml.resolver.Catalog;
/*     */ import org.apache.xml.resolver.CatalogManager;
/*     */ import org.apache.xml.resolver.helpers.Debug;
/*     */ import org.apache.xml.resolver.helpers.FileURL;
/*     */ import org.xml.sax.Attributes;
/*     */ import org.xml.sax.InputSource;
/*     */ import org.xml.sax.SAXException;
/*     */ import org.xml.sax.XMLReader;
/*     */ import org.xml.sax.helpers.XMLFilterImpl;
/*     */ 
/*     */ public class ResolvingXMLFilter extends XMLFilterImpl
/*     */ {
/*  60 */   public static boolean suppressExplanation = false;
/*     */ 
/*  63 */   private CatalogManager catalogManager = CatalogManager.getStaticManager();
/*     */ 
/*  66 */   private CatalogResolver catalogResolver = null;
/*     */ 
/*  69 */   private CatalogResolver piCatalogResolver = null;
/*     */ 
/*  72 */   private boolean allowXMLCatalogPI = false;
/*     */ 
/*  75 */   private boolean oasisXMLCatalogPI = false;
/*     */ 
/*  78 */   private URL baseURL = null;
/*     */ 
/*     */   public ResolvingXMLFilter()
/*     */   {
/*  83 */     this.catalogResolver = new CatalogResolver(this.catalogManager);
/*     */   }
/*     */ 
/*     */   public ResolvingXMLFilter(XMLReader parent)
/*     */   {
/*  88 */     super(parent);
/*  89 */     this.catalogResolver = new CatalogResolver(this.catalogManager);
/*     */   }
/*     */ 
/*     */   public ResolvingXMLFilter(CatalogManager manager)
/*     */   {
/*  95 */     this.catalogManager = manager;
/*  96 */     this.catalogResolver = new CatalogResolver(this.catalogManager);
/*     */   }
/*     */ 
/*     */   public ResolvingXMLFilter(XMLReader parent, CatalogManager manager)
/*     */   {
/* 101 */     super(parent);
/* 102 */     this.catalogManager = manager;
/* 103 */     this.catalogResolver = new CatalogResolver(this.catalogManager);
/*     */   }
/*     */ 
/*     */   public Catalog getCatalog()
/*     */   {
/* 110 */     return this.catalogResolver.getCatalog();
/*     */   }
/*     */ 
/*     */   public void parse(InputSource input)
/*     */     throws IOException, SAXException
/*     */   {
/* 136 */     this.allowXMLCatalogPI = true;
/*     */ 
/* 138 */     setupBaseURI(input.getSystemId());
/*     */     try
/*     */     {
/* 141 */       super.parse(input);
/*     */     } catch (InternalError ie) {
/* 143 */       explain(input.getSystemId());
/* 144 */       throw ie;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void parse(String systemId)
/*     */     throws IOException, SAXException
/*     */   {
/* 154 */     this.allowXMLCatalogPI = true;
/*     */ 
/* 156 */     setupBaseURI(systemId);
/*     */     try
/*     */     {
/* 159 */       super.parse(systemId);
/*     */     } catch (InternalError ie) {
/* 161 */       explain(systemId);
/* 162 */       throw ie;
/*     */     }
/*     */   }
/*     */ 
/*     */   public InputSource resolveEntity(String publicId, String systemId)
/*     */   {
/* 172 */     this.allowXMLCatalogPI = false;
/* 173 */     String resolved = this.catalogResolver.getResolvedEntity(publicId, systemId);
/*     */ 
/* 175 */     if ((resolved == null) && (this.piCatalogResolver != null)) {
/* 176 */       resolved = this.piCatalogResolver.getResolvedEntity(publicId, systemId);
/*     */     }
/*     */ 
/* 179 */     if (resolved != null) {
/*     */       try {
/* 181 */         InputSource iSource = new InputSource(resolved);
/* 182 */         iSource.setPublicId(publicId);
/*     */ 
/* 195 */         URL url = new URL(resolved);
/* 196 */         InputStream iStream = url.openStream();
/* 197 */         iSource.setByteStream(iStream);
/*     */ 
/* 199 */         return iSource;
/*     */       } catch (Exception e) {
/* 201 */         this.catalogManager.debug.message(1, "Failed to create InputSource (" + e.toString() + ")", resolved);
/*     */ 
/* 205 */         return null;
/*     */       }
/*     */     }
/* 208 */     return null;
/*     */   }
/*     */ 
/*     */   public void notationDecl(String name, String publicId, String systemId)
/*     */     throws SAXException
/*     */   {
/* 220 */     this.allowXMLCatalogPI = false;
/* 221 */     super.notationDecl(name, publicId, systemId);
/*     */   }
/*     */ 
/*     */   public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName)
/*     */     throws SAXException
/*     */   {
/* 235 */     this.allowXMLCatalogPI = false;
/* 236 */     super.unparsedEntityDecl(name, publicId, systemId, notationName);
/*     */   }
/*     */ 
/*     */   public void startElement(String uri, String localName, String qName, Attributes atts)
/*     */     throws SAXException
/*     */   {
/* 248 */     this.allowXMLCatalogPI = false;
/* 249 */     super.startElement(uri, localName, qName, atts);
/*     */   }
/*     */ 
/*     */   public void processingInstruction(String target, String pidata)
/*     */     throws SAXException
/*     */   {
/* 258 */     if (target.equals("oasis-xml-catalog")) {
/* 259 */       URL catalog = null;
/* 260 */       String data = pidata;
/*     */ 
/* 262 */       int pos = data.indexOf("catalog=");
/* 263 */       if (pos >= 0) {
/* 264 */         data = data.substring(pos + 8);
/* 265 */         if (data.length() > 1) {
/* 266 */           String quote = data.substring(0, 1);
/* 267 */           data = data.substring(1);
/* 268 */           pos = data.indexOf(quote);
/* 269 */           if (pos >= 0) {
/* 270 */             data = data.substring(0, pos);
/*     */             try {
/* 272 */               if (this.baseURL != null)
/* 273 */                 catalog = new URL(this.baseURL, data);
/*     */               else {
/* 275 */                 catalog = new URL(data);
/*     */               }
/*     */             }
/*     */             catch (MalformedURLException mue)
/*     */             {
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/* 284 */       if (this.allowXMLCatalogPI) {
/* 285 */         if (this.catalogManager.getAllowOasisXMLCatalogPI()) {
/* 286 */           this.catalogManager.debug.message(4, "oasis-xml-catalog PI", pidata);
/*     */ 
/* 288 */           if (catalog != null) {
/*     */             try {
/* 290 */               this.catalogManager.debug.message(4, "oasis-xml-catalog", catalog.toString());
/* 291 */               this.oasisXMLCatalogPI = true;
/*     */ 
/* 293 */               if (this.piCatalogResolver == null) {
/* 294 */                 this.piCatalogResolver = new CatalogResolver(true);
/*     */               }
/*     */ 
/* 297 */               this.piCatalogResolver.getCatalog().parseCatalog(catalog.toString());
/*     */             } catch (Exception e) {
/* 299 */               this.catalogManager.debug.message(3, "Exception parsing oasis-xml-catalog: " + catalog.toString());
/*     */             }
/*     */           }
/*     */           else
/* 303 */             this.catalogManager.debug.message(3, "PI oasis-xml-catalog unparseable: " + pidata);
/*     */         }
/*     */         else {
/* 306 */           this.catalogManager.debug.message(4, "PI oasis-xml-catalog ignored: " + pidata);
/*     */         }
/*     */       }
/* 309 */       else this.catalogManager.debug.message(3, "PI oasis-xml-catalog occurred in an invalid place: " + pidata);
/*     */     }
/*     */     else
/*     */     {
/* 313 */       super.processingInstruction(target, pidata);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void setupBaseURI(String systemId)
/*     */   {
/* 319 */     URL cwd = null;
/*     */     try
/*     */     {
/* 322 */       cwd = FileURL.makeURL("basename");
/*     */     } catch (MalformedURLException mue) {
/* 324 */       cwd = null;
/*     */     }
/*     */     try
/*     */     {
/* 328 */       this.baseURL = new URL(systemId);
/*     */     } catch (MalformedURLException mue) {
/* 330 */       if (cwd != null) {
/*     */         try {
/* 332 */           this.baseURL = new URL(cwd, systemId);
/*     */         }
/*     */         catch (MalformedURLException mue2) {
/* 335 */           this.baseURL = null;
/*     */         }
/*     */       }
/*     */       else
/* 339 */         this.baseURL = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   private void explain(String systemId)
/*     */   {
/* 346 */     if (!suppressExplanation) {
/* 347 */       System.out.println("XMLReader probably encountered bad URI in " + systemId);
/* 348 */       System.out.println("For example, replace '/some/uri' with 'file:/some/uri'.");
/*     */     }
/* 350 */     suppressExplanation = true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.xml.resolver.tools.ResolvingXMLFilter
 * JD-Core Version:    0.6.0
 */