/*     */ package org.apache.xml.resolver.readers;
/*     */ 
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.net.URLConnection;
/*     */ import java.net.UnknownHostException;
/*     */ import java.util.Hashtable;
/*     */ import javax.xml.parsers.ParserConfigurationException;
/*     */ import javax.xml.parsers.SAXParser;
/*     */ import javax.xml.parsers.SAXParserFactory;
/*     */ import org.apache.xml.resolver.Catalog;
/*     */ import org.apache.xml.resolver.CatalogException;
/*     */ import org.apache.xml.resolver.CatalogManager;
/*     */ import org.apache.xml.resolver.helpers.Debug;
/*     */ import org.xml.sax.AttributeList;
/*     */ import org.xml.sax.Attributes;
/*     */ import org.xml.sax.ContentHandler;
/*     */ import org.xml.sax.DocumentHandler;
/*     */ import org.xml.sax.EntityResolver;
/*     */ import org.xml.sax.InputSource;
/*     */ import org.xml.sax.Locator;
/*     */ import org.xml.sax.Parser;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ public class SAXCatalogReader
/*     */   implements CatalogReader, ContentHandler, DocumentHandler
/*     */ {
/*  81 */   protected SAXParserFactory parserFactory = null;
/*     */ 
/*  84 */   protected String parserClass = null;
/*     */ 
/*  93 */   protected Hashtable namespaceMap = new Hashtable();
/*     */ 
/*  96 */   private SAXCatalogParser saxParser = null;
/*     */ 
/* 101 */   private boolean abandonHope = false;
/*     */ 
/* 104 */   private ClassLoader loader = null;
/*     */   private Catalog catalog;
/* 148 */   protected Debug debug = CatalogManager.getStaticManager().debug;
/*     */ 
/*     */   public void setParserFactory(SAXParserFactory parserFactory)
/*     */   {
/* 112 */     this.parserFactory = parserFactory;
/*     */   }
/*     */ 
/*     */   public void setParserClass(String parserClass)
/*     */   {
/* 118 */     this.parserClass = parserClass;
/*     */   }
/*     */ 
/*     */   public SAXParserFactory getParserFactory()
/*     */   {
/* 123 */     return this.parserFactory;
/*     */   }
/*     */ 
/*     */   public String getParserClass()
/*     */   {
/* 128 */     return this.parserClass;
/*     */   }
/*     */ 
/*     */   public void setClassLoader(ClassLoader loader)
/*     */   {
/* 136 */     this.loader = loader;
/*     */   }
/*     */ 
/*     */   public SAXCatalogReader()
/*     */   {
/* 152 */     this.parserFactory = null;
/* 153 */     this.parserClass = null;
/*     */   }
/*     */ 
/*     */   public SAXCatalogReader(SAXParserFactory parserFactory)
/*     */   {
/* 158 */     this.parserFactory = parserFactory;
/*     */   }
/*     */ 
/*     */   public SAXCatalogReader(String parserClass)
/*     */   {
/* 163 */     this.parserClass = parserClass;
/*     */   }
/*     */ 
/*     */   public void setCatalogParser(String namespaceURI, String rootElement, String parserClass)
/*     */   {
/* 173 */     namespaceURI = namespaceURI != null ? namespaceURI.trim() : "";
/* 174 */     this.namespaceMap.put("{" + namespaceURI + "}" + rootElement, parserClass);
/*     */   }
/*     */ 
/*     */   public String getCatalogParser(String namespaceURI, String rootElement)
/*     */   {
/* 183 */     namespaceURI = namespaceURI != null ? namespaceURI.trim() : "";
/* 184 */     return (String)this.namespaceMap.get("{" + namespaceURI + "}" + rootElement);
/*     */   }
/*     */ 
/*     */   public void readCatalog(Catalog catalog, String fileUrl)
/*     */     throws MalformedURLException, IOException, CatalogException
/*     */   {
/* 200 */     URL url = null;
/*     */     try
/*     */     {
/* 203 */       url = new URL(fileUrl);
/*     */     } catch (MalformedURLException e) {
/* 205 */       url = new URL("file:///" + fileUrl);
/*     */     }
/*     */ 
/* 208 */     this.debug = catalog.getCatalogManager().debug;
/*     */     try
/*     */     {
/* 211 */       URLConnection urlCon = url.openConnection();
/* 212 */       readCatalog(catalog, urlCon.getInputStream());
/*     */     } catch (FileNotFoundException e) {
/* 214 */       catalog.getCatalogManager().debug.message(1, "Failed to load catalog, file not found", url.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void readCatalog(Catalog catalog, InputStream is)
/*     */     throws IOException, CatalogException
/*     */   {
/* 233 */     if ((this.parserFactory == null) && (this.parserClass == null)) {
/* 234 */       this.debug.message(1, "Cannot read SAX catalog without a parser");
/* 235 */       throw new CatalogException(6);
/*     */     }
/*     */ 
/* 238 */     this.debug = catalog.getCatalogManager().debug;
/* 239 */     EntityResolver bResolver = catalog.getCatalogManager().getBootstrapResolver();
/*     */ 
/* 241 */     this.catalog = catalog;
/*     */     try
/*     */     {
/* 244 */       if (this.parserFactory != null) {
/* 245 */         SAXParser parser = this.parserFactory.newSAXParser();
/* 246 */         SAXParserHandler spHandler = new SAXParserHandler();
/* 247 */         spHandler.setContentHandler(this);
/* 248 */         if (bResolver != null) {
/* 249 */           spHandler.setEntityResolver(bResolver);
/*     */         }
/* 251 */         parser.parse(new InputSource(is), spHandler);
/*     */       } else {
/* 253 */         Parser parser = (Parser)Class.forName(this.parserClass, true, this.loader != null ? this.loader : getClass().getClassLoader()).newInstance();
/* 254 */         parser.setDocumentHandler(this);
/* 255 */         if (bResolver != null) {
/* 256 */           parser.setEntityResolver(bResolver);
/*     */         }
/* 258 */         parser.parse(new InputSource(is));
/*     */       }
/*     */     } catch (ClassNotFoundException cnfe) {
/* 261 */       throw new CatalogException(6);
/*     */     } catch (IllegalAccessException iae) {
/* 263 */       throw new CatalogException(6);
/*     */     } catch (InstantiationException ie) {
/* 265 */       throw new CatalogException(6);
/*     */     } catch (ParserConfigurationException pce) {
/* 267 */       throw new CatalogException(5);
/*     */     } catch (SAXException se) {
/* 269 */       Exception e = se.getException();
/*     */ 
/* 271 */       UnknownHostException uhe = new UnknownHostException();
/* 272 */       FileNotFoundException fnfe = new FileNotFoundException();
/* 273 */       if (e != null) {
/* 274 */         if (e.getClass() == uhe.getClass()) {
/* 275 */           throw new CatalogException(7, e.toString());
/*     */         }
/* 277 */         if (e.getClass() == fnfe.getClass()) {
/* 278 */           throw new CatalogException(7, e.toString());
/*     */         }
/*     */       }
/*     */ 
/* 282 */       throw new CatalogException(se);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setDocumentLocator(Locator locator)
/*     */   {
/* 291 */     if (this.saxParser != null)
/* 292 */       this.saxParser.setDocumentLocator(locator);
/*     */   }
/*     */ 
/*     */   public void startDocument()
/*     */     throws SAXException
/*     */   {
/* 298 */     this.saxParser = null;
/* 299 */     this.abandonHope = false;
/*     */   }
/*     */ 
/*     */   public void endDocument()
/*     */     throws SAXException
/*     */   {
/* 305 */     if (this.saxParser != null)
/* 306 */       this.saxParser.endDocument();
/*     */   }
/*     */ 
/*     */   public void startElement(String name, AttributeList atts)
/*     */     throws SAXException
/*     */   {
/* 320 */     if (this.abandonHope) {
/* 321 */       return;
/*     */     }
/*     */ 
/* 324 */     if (this.saxParser == null) {
/* 325 */       String prefix = "";
/* 326 */       if (name.indexOf(':') > 0) {
/* 327 */         prefix = name.substring(0, name.indexOf(':'));
/*     */       }
/*     */ 
/* 330 */       String localName = name;
/* 331 */       if (localName.indexOf(':') > 0) {
/* 332 */         localName = localName.substring(localName.indexOf(':') + 1);
/*     */       }
/*     */ 
/* 335 */       String namespaceURI = null;
/* 336 */       if (prefix.equals(""))
/* 337 */         namespaceURI = atts.getValue("xmlns");
/*     */       else {
/* 339 */         namespaceURI = atts.getValue("xmlns:" + prefix);
/*     */       }
/*     */ 
/* 342 */       String saxParserClass = getCatalogParser(namespaceURI, localName);
/*     */ 
/* 345 */       if (saxParserClass == null) {
/* 346 */         this.abandonHope = true;
/* 347 */         if (namespaceURI == null)
/* 348 */           this.debug.message(2, "No Catalog parser for " + name);
/*     */         else {
/* 350 */           this.debug.message(2, "No Catalog parser for {" + namespaceURI + "}" + name);
/*     */         }
/*     */ 
/* 354 */         return;
/*     */       }
/*     */       try
/*     */       {
/* 358 */         this.saxParser = ((SAXCatalogParser)Class.forName(saxParserClass, true, this.loader != null ? this.loader : getClass().getClassLoader()).newInstance());
/*     */ 
/* 361 */         this.saxParser.setCatalog(this.catalog);
/* 362 */         this.saxParser.startDocument();
/* 363 */         this.saxParser.startElement(name, atts);
/*     */       } catch (ClassNotFoundException cnfe) {
/* 365 */         this.saxParser = null;
/* 366 */         this.abandonHope = true;
/* 367 */         this.debug.message(2, cnfe.toString());
/*     */       } catch (InstantiationException ie) {
/* 369 */         this.saxParser = null;
/* 370 */         this.abandonHope = true;
/* 371 */         this.debug.message(2, ie.toString());
/*     */       } catch (IllegalAccessException iae) {
/* 373 */         this.saxParser = null;
/* 374 */         this.abandonHope = true;
/* 375 */         this.debug.message(2, iae.toString());
/*     */       } catch (ClassCastException cce) {
/* 377 */         this.saxParser = null;
/* 378 */         this.abandonHope = true;
/* 379 */         this.debug.message(2, cce.toString());
/*     */       }
/*     */     } else {
/* 382 */       this.saxParser.startElement(name, atts);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void startElement(String namespaceURI, String localName, String qName, Attributes atts)
/*     */     throws SAXException
/*     */   {
/* 398 */     if (this.abandonHope) {
/* 399 */       return;
/*     */     }
/*     */ 
/* 402 */     if (this.saxParser == null) {
/* 403 */       String saxParserClass = getCatalogParser(namespaceURI, localName);
/*     */ 
/* 406 */       if (saxParserClass == null) {
/* 407 */         this.abandonHope = true;
/* 408 */         if (namespaceURI == null)
/* 409 */           this.debug.message(2, "No Catalog parser for " + localName);
/*     */         else {
/* 411 */           this.debug.message(2, "No Catalog parser for {" + namespaceURI + "}" + localName);
/*     */         }
/*     */ 
/* 415 */         return;
/*     */       }
/*     */       try
/*     */       {
/* 419 */         this.saxParser = ((SAXCatalogParser)Class.forName(saxParserClass, true, this.loader != null ? this.loader : getClass().getClassLoader()).newInstance());
/*     */ 
/* 422 */         this.saxParser.setCatalog(this.catalog);
/* 423 */         this.saxParser.startDocument();
/* 424 */         this.saxParser.startElement(namespaceURI, localName, qName, atts);
/*     */       } catch (ClassNotFoundException cnfe) {
/* 426 */         this.saxParser = null;
/* 427 */         this.abandonHope = true;
/* 428 */         this.debug.message(2, cnfe.toString());
/*     */       } catch (InstantiationException ie) {
/* 430 */         this.saxParser = null;
/* 431 */         this.abandonHope = true;
/* 432 */         this.debug.message(2, ie.toString());
/*     */       } catch (IllegalAccessException iae) {
/* 434 */         this.saxParser = null;
/* 435 */         this.abandonHope = true;
/* 436 */         this.debug.message(2, iae.toString());
/*     */       } catch (ClassCastException cce) {
/* 438 */         this.saxParser = null;
/* 439 */         this.abandonHope = true;
/* 440 */         this.debug.message(2, cce.toString());
/*     */       }
/*     */     } else {
/* 443 */       this.saxParser.startElement(namespaceURI, localName, qName, atts);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void endElement(String name) throws SAXException
/*     */   {
/* 449 */     if (this.saxParser != null)
/* 450 */       this.saxParser.endElement(name);
/*     */   }
/*     */ 
/*     */   public void endElement(String namespaceURI, String localName, String qName)
/*     */     throws SAXException
/*     */   {
/* 458 */     if (this.saxParser != null)
/* 459 */       this.saxParser.endElement(namespaceURI, localName, qName);
/*     */   }
/*     */ 
/*     */   public void characters(char[] ch, int start, int length)
/*     */     throws SAXException
/*     */   {
/* 466 */     if (this.saxParser != null)
/* 467 */       this.saxParser.characters(ch, start, length);
/*     */   }
/*     */ 
/*     */   public void ignorableWhitespace(char[] ch, int start, int length)
/*     */     throws SAXException
/*     */   {
/* 474 */     if (this.saxParser != null)
/* 475 */       this.saxParser.ignorableWhitespace(ch, start, length);
/*     */   }
/*     */ 
/*     */   public void processingInstruction(String target, String data)
/*     */     throws SAXException
/*     */   {
/* 482 */     if (this.saxParser != null)
/* 483 */       this.saxParser.processingInstruction(target, data);
/*     */   }
/*     */ 
/*     */   public void startPrefixMapping(String prefix, String uri)
/*     */     throws SAXException
/*     */   {
/* 490 */     if (this.saxParser != null)
/* 491 */       this.saxParser.startPrefixMapping(prefix, uri);
/*     */   }
/*     */ 
/*     */   public void endPrefixMapping(String prefix)
/*     */     throws SAXException
/*     */   {
/* 498 */     if (this.saxParser != null)
/* 499 */       this.saxParser.endPrefixMapping(prefix);
/*     */   }
/*     */ 
/*     */   public void skippedEntity(String name)
/*     */     throws SAXException
/*     */   {
/* 506 */     if (this.saxParser != null)
/* 507 */       this.saxParser.skippedEntity(name);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.xml.resolver.readers.SAXCatalogReader
 * JD-Core Version:    0.6.0
 */