/*     */ package org.apache.commons.collections.map;
/*     */ 
/*     */ import java.util.Comparator;
/*     */ import java.util.SortedMap;
/*     */ import org.apache.commons.collections.Predicate;
/*     */ 
/*     */ public class PredicatedSortedMap extends PredicatedMap
/*     */   implements SortedMap
/*     */ {
/*     */   private static final long serialVersionUID = 3359846175935304332L;
/*     */ 
/*     */   public static SortedMap decorate(SortedMap map, Predicate keyPredicate, Predicate valuePredicate)
/*     */   {
/*  61 */     return new PredicatedSortedMap(map, keyPredicate, valuePredicate);
/*     */   }
/*     */ 
/*     */   protected PredicatedSortedMap(SortedMap map, Predicate keyPredicate, Predicate valuePredicate)
/*     */   {
/*  74 */     super(map, keyPredicate, valuePredicate);
/*     */   }
/*     */ 
/*     */   protected SortedMap getSortedMap()
/*     */   {
/*  84 */     return (SortedMap)this.map;
/*     */   }
/*     */ 
/*     */   public Object firstKey()
/*     */   {
/*  89 */     return getSortedMap().firstKey();
/*     */   }
/*     */ 
/*     */   public Object lastKey() {
/*  93 */     return getSortedMap().lastKey();
/*     */   }
/*     */ 
/*     */   public Comparator comparator() {
/*  97 */     return getSortedMap().comparator();
/*     */   }
/*     */ 
/*     */   public SortedMap subMap(Object fromKey, Object toKey) {
/* 101 */     SortedMap map = getSortedMap().subMap(fromKey, toKey);
/* 102 */     return new PredicatedSortedMap(map, this.keyPredicate, this.valuePredicate);
/*     */   }
/*     */ 
/*     */   public SortedMap headMap(Object toKey) {
/* 106 */     SortedMap map = getSortedMap().headMap(toKey);
/* 107 */     return new PredicatedSortedMap(map, this.keyPredicate, this.valuePredicate);
/*     */   }
/*     */ 
/*     */   public SortedMap tailMap(Object fromKey) {
/* 111 */     SortedMap map = getSortedMap().tailMap(fromKey);
/* 112 */     return new PredicatedSortedMap(map, this.keyPredicate, this.valuePredicate);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.map.PredicatedSortedMap
 * JD-Core Version:    0.6.0
 */