/*     */ package org.apache.commons.collections.functors;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import org.apache.commons.collections.Closure;
/*     */ import org.apache.commons.collections.Predicate;
/*     */ 
/*     */ public class IfClosure
/*     */   implements Closure, Serializable
/*     */ {
/*     */   static final long serialVersionUID = 3518477308466486130L;
/*     */   private final Predicate iPredicate;
/*     */   private final Closure iTrueClosure;
/*     */   private final Closure iFalseClosure;
/*     */ 
/*     */   public static Closure getInstance(Predicate predicate, Closure trueClosure, Closure falseClosure)
/*     */   {
/*  54 */     if (predicate == null) {
/*  55 */       throw new IllegalArgumentException("Predicate must not be null");
/*     */     }
/*  57 */     if ((trueClosure == null) || (falseClosure == null)) {
/*  58 */       throw new IllegalArgumentException("Closures must not be null");
/*     */     }
/*  60 */     return new IfClosure(predicate, trueClosure, falseClosure);
/*     */   }
/*     */ 
/*     */   public IfClosure(Predicate predicate, Closure trueClosure, Closure falseClosure)
/*     */   {
/*  73 */     this.iPredicate = predicate;
/*  74 */     this.iTrueClosure = trueClosure;
/*  75 */     this.iFalseClosure = falseClosure;
/*     */   }
/*     */ 
/*     */   public void execute(Object input)
/*     */   {
/*  84 */     if (this.iPredicate.evaluate(input) == true)
/*  85 */       this.iTrueClosure.execute(input);
/*     */     else
/*  87 */       this.iFalseClosure.execute(input);
/*     */   }
/*     */ 
/*     */   public Predicate getPredicate()
/*     */   {
/*  98 */     return this.iPredicate;
/*     */   }
/*     */ 
/*     */   public Closure getTrueClosure()
/*     */   {
/* 108 */     return this.iTrueClosure;
/*     */   }
/*     */ 
/*     */   public Closure getFalseClosure()
/*     */   {
/* 118 */     return this.iFalseClosure;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.functors.IfClosure
 * JD-Core Version:    0.6.0
 */