/*     */ package org.apache.commons.collections;
/*     */ 
/*     */ import java.util.AbstractCollection;
/*     */ import java.util.Iterator;
/*     */ import java.util.NoSuchElementException;
/*     */ 
/*     */ /** @deprecated */
/*     */ public class UnboundedFifoBuffer extends AbstractCollection
/*     */   implements Buffer
/*     */ {
/*     */   protected Object[] m_buffer;
/*     */   protected int m_head;
/*     */   protected int m_tail;
/*     */ 
/*     */   public UnboundedFifoBuffer()
/*     */   {
/*  68 */     this(32);
/*     */   }
/*     */ 
/*     */   public UnboundedFifoBuffer(int initialSize)
/*     */   {
/*  79 */     if (initialSize <= 0) {
/*  80 */       throw new IllegalArgumentException("The size must be greater than 0");
/*     */     }
/*  82 */     this.m_buffer = new Object[initialSize + 1];
/*  83 */     this.m_head = 0;
/*  84 */     this.m_tail = 0;
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/*  93 */     int size = 0;
/*     */ 
/*  95 */     if (this.m_tail < this.m_head)
/*  96 */       size = this.m_buffer.length - this.m_head + this.m_tail;
/*     */     else {
/*  98 */       size = this.m_tail - this.m_head;
/*     */     }
/*     */ 
/* 101 */     return size;
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 110 */     return size() == 0;
/*     */   }
/*     */ 
/*     */   public boolean add(Object obj)
/*     */   {
/* 122 */     if (obj == null) {
/* 123 */       throw new NullPointerException("Attempted to add null object to buffer");
/*     */     }
/*     */ 
/* 126 */     if (size() + 1 >= this.m_buffer.length) {
/* 127 */       Object[] tmp = new Object[(this.m_buffer.length - 1) * 2 + 1];
/*     */ 
/* 129 */       int j = 0;
/* 130 */       for (int i = this.m_head; i != this.m_tail; ) {
/* 131 */         tmp[j] = this.m_buffer[i];
/* 132 */         this.m_buffer[i] = null;
/*     */ 
/* 134 */         j++;
/* 135 */         i++;
/* 136 */         if (i == this.m_buffer.length) {
/* 137 */           i = 0;
/*     */         }
/*     */       }
/*     */ 
/* 141 */       this.m_buffer = tmp;
/* 142 */       this.m_head = 0;
/* 143 */       this.m_tail = j;
/*     */     }
/*     */ 
/* 146 */     this.m_buffer[this.m_tail] = obj;
/* 147 */     this.m_tail += 1;
/* 148 */     if (this.m_tail >= this.m_buffer.length) {
/* 149 */       this.m_tail = 0;
/*     */     }
/* 151 */     return true;
/*     */   }
/*     */ 
/*     */   public Object get()
/*     */   {
/* 161 */     if (isEmpty()) {
/* 162 */       throw new BufferUnderflowException("The buffer is already empty");
/*     */     }
/*     */ 
/* 165 */     return this.m_buffer[this.m_head];
/*     */   }
/*     */ 
/*     */   public Object remove()
/*     */   {
/* 175 */     if (isEmpty()) {
/* 176 */       throw new BufferUnderflowException("The buffer is already empty");
/*     */     }
/*     */ 
/* 179 */     Object element = this.m_buffer[this.m_head];
/*     */ 
/* 181 */     if (null != element) {
/* 182 */       this.m_buffer[this.m_head] = null;
/*     */ 
/* 184 */       this.m_head += 1;
/* 185 */       if (this.m_head >= this.m_buffer.length) {
/* 186 */         this.m_head = 0;
/*     */       }
/*     */     }
/*     */ 
/* 190 */     return element;
/*     */   }
/*     */ 
/*     */   private int increment(int index)
/*     */   {
/* 200 */     index++;
/* 201 */     if (index >= this.m_buffer.length) {
/* 202 */       index = 0;
/*     */     }
/* 204 */     return index;
/*     */   }
/*     */ 
/*     */   private int decrement(int index)
/*     */   {
/* 214 */     index--;
/* 215 */     if (index < 0) {
/* 216 */       index = this.m_buffer.length - 1;
/*     */     }
/* 218 */     return index;
/*     */   }
/*     */ 
/*     */   public Iterator iterator()
/*     */   {
/* 227 */     return new Iterator()
/*     */     {
/* 229 */       private int index = UnboundedFifoBuffer.this.m_head;
/* 230 */       private int lastReturnedIndex = -1;
/*     */ 
/*     */       public boolean hasNext() {
/* 233 */         return this.index != UnboundedFifoBuffer.this.m_tail;
/*     */       }
/*     */ 
/*     */       public Object next()
/*     */       {
/* 238 */         if (!hasNext())
/* 239 */           throw new NoSuchElementException();
/* 240 */         this.lastReturnedIndex = this.index;
/* 241 */         this.index = UnboundedFifoBuffer.this.increment(this.index);
/* 242 */         return UnboundedFifoBuffer.this.m_buffer[this.lastReturnedIndex];
/*     */       }
/*     */ 
/*     */       public void remove() {
/* 246 */         if (this.lastReturnedIndex == -1) {
/* 247 */           throw new IllegalStateException();
/*     */         }
/*     */ 
/* 250 */         if (this.lastReturnedIndex == UnboundedFifoBuffer.this.m_head) {
/* 251 */           UnboundedFifoBuffer.this.remove();
/* 252 */           this.lastReturnedIndex = -1;
/* 253 */           return;
/*     */         }
/*     */ 
/* 257 */         int i = this.lastReturnedIndex + 1;
/* 258 */         while (i != UnboundedFifoBuffer.this.m_tail) {
/* 259 */           if (i >= UnboundedFifoBuffer.this.m_buffer.length) {
/* 260 */             UnboundedFifoBuffer.this.m_buffer[(i - 1)] = UnboundedFifoBuffer.this.m_buffer[0];
/* 261 */             i = 0; continue;
/*     */           }
/* 263 */           UnboundedFifoBuffer.this.m_buffer[(i - 1)] = UnboundedFifoBuffer.this.m_buffer[i];
/* 264 */           i++;
/*     */         }
/*     */ 
/* 268 */         this.lastReturnedIndex = -1;
/* 269 */         UnboundedFifoBuffer.this.m_tail = UnboundedFifoBuffer.this.decrement(UnboundedFifoBuffer.this.m_tail);
/* 270 */         UnboundedFifoBuffer.this.m_buffer[UnboundedFifoBuffer.this.m_tail] = null;
/* 271 */         this.index = UnboundedFifoBuffer.this.decrement(this.index);
/*     */       }
/*     */     };
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.UnboundedFifoBuffer
 * JD-Core Version:    0.6.0
 */