/*    */ package javax.xml.bind.util;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import java.util.List;
/*    */ import javax.xml.bind.ValidationEvent;
/*    */ import javax.xml.bind.ValidationEventHandler;
/*    */ 
/*    */ public class ValidationEventCollector
/*    */   implements ValidationEventHandler
/*    */ {
/* 32 */   private final List<ValidationEvent> events = new ArrayList();
/*    */ 
/*    */   public ValidationEvent[] getEvents()
/*    */   {
/* 43 */     return (ValidationEvent[])this.events.toArray(new ValidationEvent[this.events.size()]);
/*    */   }
/*    */ 
/*    */   public void reset()
/*    */   {
/* 50 */     this.events.clear();
/*    */   }
/*    */ 
/*    */   public boolean hasEvents()
/*    */   {
/* 61 */     return !this.events.isEmpty();
/*    */   }
/*    */ 
/*    */   public boolean handleEvent(ValidationEvent event) {
/* 65 */     this.events.add(event);
/*    */ 
/* 67 */     boolean retVal = true;
/* 68 */     switch (event.getSeverity()) {
/*    */     case 0:
/* 70 */       retVal = true;
/* 71 */       break;
/*    */     case 1:
/* 73 */       retVal = true;
/* 74 */       break;
/*    */     case 2:
/* 76 */       retVal = false;
/* 77 */       break;
/*    */     default:
/* 79 */       _assert(false, Messages.format("ValidationEventCollector.UnrecognizedSeverity", Integer.valueOf(event.getSeverity())));
/*    */     }
/*    */ 
/* 85 */     return retVal;
/*    */   }
/*    */ 
/*    */   private static void _assert(boolean b, String msg) {
/* 89 */     if (!b)
/* 90 */       throw new InternalError(msg);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javax.xml.bind.util.ValidationEventCollector
 * JD-Core Version:    0.6.0
 */