/*     */ package javax.xml.bind;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.io.PrintWriter;
/*     */ 
/*     */ public class JAXBException extends Exception
/*     */ {
/*     */   private String errorCode;
/*     */   private Throwable linkedException;
/*     */   static final long serialVersionUID = -5621384651494307979L;
/*     */ 
/*     */   public JAXBException(String message)
/*     */   {
/*  43 */     this(message, null, null);
/*     */   }
/*     */ 
/*     */   public JAXBException(String message, String errorCode)
/*     */   {
/*  54 */     this(message, errorCode, null);
/*     */   }
/*     */ 
/*     */   public JAXBException(Throwable exception)
/*     */   {
/*  64 */     this(null, null, exception);
/*     */   }
/*     */ 
/*     */   public JAXBException(String message, Throwable exception)
/*     */   {
/*  75 */     this(message, null, exception);
/*     */   }
/*     */ 
/*     */   public JAXBException(String message, String errorCode, Throwable exception)
/*     */   {
/*  87 */     super(message);
/*  88 */     this.errorCode = errorCode;
/*  89 */     this.linkedException = exception;
/*     */   }
/*     */ 
/*     */   public String getErrorCode()
/*     */   {
/*  98 */     return this.errorCode;
/*     */   }
/*     */ 
/*     */   public Throwable getLinkedException()
/*     */   {
/* 107 */     return this.linkedException;
/*     */   }
/*     */ 
/*     */   public synchronized void setLinkedException(Throwable exception)
/*     */   {
/* 118 */     this.linkedException = exception;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 126 */     return super.toString() + "\n - with linked exception:\n[" + this.linkedException.toString() + "]";
/*     */   }
/*     */ 
/*     */   public void printStackTrace(PrintStream s)
/*     */   {
/* 139 */     super.printStackTrace(s);
/*     */   }
/*     */ 
/*     */   public void printStackTrace()
/*     */   {
/* 148 */     super.printStackTrace();
/*     */   }
/*     */ 
/*     */   public void printStackTrace(PrintWriter s)
/*     */   {
/* 158 */     super.printStackTrace(s);
/*     */   }
/*     */ 
/*     */   public Throwable getCause()
/*     */   {
/* 163 */     return this.linkedException;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javax.xml.bind.JAXBException
 * JD-Core Version:    0.6.0
 */