/*     */ package javassist.bytecode.annotation;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.lang.reflect.Method;
/*     */ import javassist.ClassPool;
/*     */ import javassist.bytecode.ConstPool;
/*     */ 
/*     */ public class CharMemberValue extends MemberValue
/*     */ {
/*     */   int valueIndex;
/*     */ 
/*     */   public CharMemberValue(int index, ConstPool cp)
/*     */   {
/*  39 */     super('C', cp);
/*  40 */     this.valueIndex = index;
/*     */   }
/*     */ 
/*     */   public CharMemberValue(char c, ConstPool cp)
/*     */   {
/*  49 */     super('C', cp);
/*  50 */     setValue(c);
/*     */   }
/*     */ 
/*     */   public CharMemberValue(ConstPool cp)
/*     */   {
/*  57 */     super('C', cp);
/*  58 */     setValue('\000');
/*     */   }
/*     */ 
/*     */   Object getValue(ClassLoader cl, ClassPool cp, Method m) {
/*  62 */     return new Character(getValue());
/*     */   }
/*     */ 
/*     */   Class getType(ClassLoader cl) {
/*  66 */     return Character.TYPE;
/*     */   }
/*     */ 
/*     */   public char getValue()
/*     */   {
/*  73 */     return (char)this.cp.getIntegerInfo(this.valueIndex);
/*     */   }
/*     */ 
/*     */   public void setValue(char newValue)
/*     */   {
/*  80 */     this.valueIndex = this.cp.addIntegerInfo(newValue);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/*  87 */     return Character.toString(getValue());
/*     */   }
/*     */ 
/*     */   public void write(AnnotationsWriter writer)
/*     */     throws IOException
/*     */   {
/*  94 */     writer.constValueIndex(getValue());
/*     */   }
/*     */ 
/*     */   public void accept(MemberValueVisitor visitor)
/*     */   {
/* 101 */     visitor.visitCharMemberValue(this);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javassist.bytecode.annotation.CharMemberValue
 * JD-Core Version:    0.6.0
 */