/*      */ package javassist.bytecode;
/*      */ 
/*      */ import javassist.CtClass;
/*      */ import javassist.CtPrimitiveType;
/*      */ 
/*      */ public class Bytecode extends ByteVector
/*      */   implements Cloneable, Opcode
/*      */ {
/*  109 */   public static final CtClass THIS = ConstPool.THIS;
/*      */   ConstPool constPool;
/*      */   int maxStack;
/*      */   int maxLocals;
/*      */   ExceptionTable tryblocks;
/*      */   private int stackDepth;
/*      */ 
/*      */   public Bytecode(ConstPool cp, int stacksize, int localvars)
/*      */   {
/*  130 */     this.constPool = cp;
/*  131 */     this.maxStack = stacksize;
/*  132 */     this.maxLocals = localvars;
/*  133 */     this.tryblocks = new ExceptionTable(cp);
/*  134 */     this.stackDepth = 0;
/*      */   }
/*      */ 
/*      */   public Bytecode(ConstPool cp)
/*      */   {
/*  147 */     this(cp, 0, 0);
/*      */   }
/*      */ 
/*      */   public Object clone()
/*      */   {
/*      */     try
/*      */     {
/*  157 */       Bytecode bc = (Bytecode)super.clone();
/*  158 */       bc.tryblocks = ((ExceptionTable)this.tryblocks.clone());
/*  159 */       return bc;
/*      */     } catch (CloneNotSupportedException cnse) {
/*      */     }
/*  162 */     throw new RuntimeException(cnse);
/*      */   }
/*      */ 
/*      */   public ConstPool getConstPool()
/*      */   {
/*  169 */     return this.constPool;
/*      */   }
/*      */ 
/*      */   public ExceptionTable getExceptionTable()
/*      */   {
/*  174 */     return this.tryblocks;
/*      */   }
/*      */ 
/*      */   public CodeAttribute toCodeAttribute()
/*      */   {
/*  180 */     return new CodeAttribute(this.constPool, this.maxStack, this.maxLocals, get(), this.tryblocks);
/*      */   }
/*      */ 
/*      */   public int length()
/*      */   {
/*  188 */     return getSize();
/*      */   }
/*      */ 
/*      */   public byte[] get()
/*      */   {
/*  195 */     return copy();
/*      */   }
/*      */ 
/*      */   public int getMaxStack()
/*      */   {
/*  201 */     return this.maxStack;
/*      */   }
/*      */ 
/*      */   public void setMaxStack(int size)
/*      */   {
/*  218 */     this.maxStack = size;
/*      */   }
/*      */ 
/*      */   public int getMaxLocals()
/*      */   {
/*  224 */     return this.maxLocals;
/*      */   }
/*      */ 
/*      */   public void setMaxLocals(int size)
/*      */   {
/*  230 */     this.maxLocals = size;
/*      */   }
/*      */ 
/*      */   public void setMaxLocals(boolean isStatic, CtClass[] params, int locals)
/*      */   {
/*  248 */     if (!isStatic) {
/*  249 */       locals++;
/*      */     }
/*  251 */     if (params != null) {
/*  252 */       CtClass doubleType = CtClass.doubleType;
/*  253 */       CtClass longType = CtClass.longType;
/*  254 */       int n = params.length;
/*  255 */       for (int i = 0; i < n; i++) {
/*  256 */         CtClass type = params[i];
/*  257 */         if ((type == doubleType) || (type == longType))
/*  258 */           locals += 2;
/*      */         else {
/*  260 */           locals++;
/*      */         }
/*      */       }
/*      */     }
/*  264 */     this.maxLocals = locals;
/*      */   }
/*      */ 
/*      */   public void incMaxLocals(int diff)
/*      */   {
/*  271 */     this.maxLocals += diff;
/*      */   }
/*      */ 
/*      */   public void addExceptionHandler(int start, int end, int handler, CtClass type)
/*      */   {
/*  279 */     addExceptionHandler(start, end, handler, this.constPool.addClassInfo(type));
/*      */   }
/*      */ 
/*      */   public void addExceptionHandler(int start, int end, int handler, String type)
/*      */   {
/*  290 */     addExceptionHandler(start, end, handler, this.constPool.addClassInfo(type));
/*      */   }
/*      */ 
/*      */   public void addExceptionHandler(int start, int end, int handler, int type)
/*      */   {
/*  299 */     this.tryblocks.add(start, end, handler, type);
/*      */   }
/*      */ 
/*      */   public int currentPc()
/*      */   {
/*  307 */     return getSize();
/*      */   }
/*      */ 
/*      */   public int read(int offset)
/*      */   {
/*  317 */     return super.read(offset);
/*      */   }
/*      */ 
/*      */   public int read16bit(int offset)
/*      */   {
/*  325 */     int v1 = read(offset);
/*  326 */     int v2 = read(offset + 1);
/*  327 */     return (v1 << 8) + (v2 & 0xFF);
/*      */   }
/*      */ 
/*      */   public int read32bit(int offset)
/*      */   {
/*  335 */     int v1 = read16bit(offset);
/*  336 */     int v2 = read16bit(offset + 2);
/*  337 */     return (v1 << 16) + (v2 & 0xFFFF);
/*      */   }
/*      */ 
/*      */   public void write(int offset, int value)
/*      */   {
/*  347 */     super.write(offset, value);
/*      */   }
/*      */ 
/*      */   public void write16bit(int offset, int value)
/*      */   {
/*  355 */     write(offset, value >> 8);
/*  356 */     write(offset + 1, value);
/*      */   }
/*      */ 
/*      */   public void write32bit(int offset, int value)
/*      */   {
/*  364 */     write16bit(offset, value >> 16);
/*  365 */     write16bit(offset + 2, value);
/*      */   }
/*      */ 
/*      */   public void add(int code)
/*      */   {
/*  372 */     super.add(code);
/*      */   }
/*      */ 
/*      */   public void add32bit(int value)
/*      */   {
/*  379 */     add(value >> 24);
/*  380 */     add(value >> 16);
/*  381 */     add(value >> 8);
/*  382 */     add(value);
/*      */   }
/*      */ 
/*      */   public void addGap(int length)
/*      */   {
/*  391 */     super.addGap(length);
/*      */   }
/*      */ 
/*      */   public void addOpcode(int code)
/*      */   {
/*  406 */     add(code);
/*  407 */     growStack(STACK_GROW[code]);
/*      */   }
/*      */ 
/*      */   public void growStack(int diff)
/*      */   {
/*  418 */     setStackDepth(this.stackDepth + diff);
/*      */   }
/*      */ 
/*      */   public int getStackDepth()
/*      */   {
/*  424 */     return this.stackDepth;
/*      */   }
/*      */ 
/*      */   public void setStackDepth(int depth)
/*      */   {
/*  434 */     this.stackDepth = depth;
/*  435 */     if (this.stackDepth > this.maxStack)
/*  436 */       this.maxStack = this.stackDepth;
/*      */   }
/*      */ 
/*      */   public void addIndex(int index)
/*      */   {
/*  444 */     add(index >> 8);
/*  445 */     add(index);
/*      */   }
/*      */ 
/*      */   public void addAload(int n)
/*      */   {
/*  454 */     if (n < 4) {
/*  455 */       addOpcode(42 + n);
/*  456 */     } else if (n < 256) {
/*  457 */       addOpcode(25);
/*  458 */       add(n);
/*      */     }
/*      */     else {
/*  461 */       addOpcode(196);
/*  462 */       addOpcode(25);
/*  463 */       addIndex(n);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addAstore(int n)
/*      */   {
/*  473 */     if (n < 4) {
/*  474 */       addOpcode(75 + n);
/*  475 */     } else if (n < 256) {
/*  476 */       addOpcode(58);
/*  477 */       add(n);
/*      */     }
/*      */     else {
/*  480 */       addOpcode(196);
/*  481 */       addOpcode(58);
/*  482 */       addIndex(n);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addIconst(int n)
/*      */   {
/*  492 */     if ((n < 6) && (-2 < n)) {
/*  493 */       addOpcode(3 + n);
/*  494 */     } else if ((n <= 127) && (-128 <= n)) {
/*  495 */       addOpcode(16);
/*  496 */       add(n);
/*      */     }
/*  498 */     else if ((n <= 32767) && (-32768 <= n)) {
/*  499 */       addOpcode(17);
/*  500 */       add(n >> 8);
/*  501 */       add(n);
/*      */     }
/*      */     else {
/*  504 */       addLdc(this.constPool.addIntegerInfo(n));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addConstZero(CtClass type)
/*      */   {
/*  514 */     if (type.isPrimitive()) {
/*  515 */       if (type == CtClass.longType) {
/*  516 */         addOpcode(9);
/*  517 */       } else if (type == CtClass.floatType) {
/*  518 */         addOpcode(11);
/*  519 */       } else if (type == CtClass.doubleType) {
/*  520 */         addOpcode(14); } else {
/*  521 */         if (type == CtClass.voidType) {
/*  522 */           throw new RuntimeException("void type?");
/*      */         }
/*  524 */         addOpcode(3);
/*      */       }
/*      */     }
/*  527 */     else addOpcode(1);
/*      */   }
/*      */ 
/*      */   public void addIload(int n)
/*      */   {
/*  536 */     if (n < 4) {
/*  537 */       addOpcode(26 + n);
/*  538 */     } else if (n < 256) {
/*  539 */       addOpcode(21);
/*  540 */       add(n);
/*      */     }
/*      */     else {
/*  543 */       addOpcode(196);
/*  544 */       addOpcode(21);
/*  545 */       addIndex(n);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addIstore(int n)
/*      */   {
/*  555 */     if (n < 4) {
/*  556 */       addOpcode(59 + n);
/*  557 */     } else if (n < 256) {
/*  558 */       addOpcode(54);
/*  559 */       add(n);
/*      */     }
/*      */     else {
/*  562 */       addOpcode(196);
/*  563 */       addOpcode(54);
/*  564 */       addIndex(n);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addLconst(long n)
/*      */   {
/*  574 */     if ((n == 0L) || (n == 1L))
/*  575 */       addOpcode(9 + (int)n);
/*      */     else
/*  577 */       addLdc2w(n);
/*      */   }
/*      */ 
/*      */   public void addLload(int n)
/*      */   {
/*  586 */     if (n < 4) {
/*  587 */       addOpcode(30 + n);
/*  588 */     } else if (n < 256) {
/*  589 */       addOpcode(22);
/*  590 */       add(n);
/*      */     }
/*      */     else {
/*  593 */       addOpcode(196);
/*  594 */       addOpcode(22);
/*  595 */       addIndex(n);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addLstore(int n)
/*      */   {
/*  605 */     if (n < 4) {
/*  606 */       addOpcode(63 + n);
/*  607 */     } else if (n < 256) {
/*  608 */       addOpcode(55);
/*  609 */       add(n);
/*      */     }
/*      */     else {
/*  612 */       addOpcode(196);
/*  613 */       addOpcode(55);
/*  614 */       addIndex(n);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addDconst(double d)
/*      */   {
/*  624 */     if ((d == 0.0D) || (d == 1.0D))
/*  625 */       addOpcode(14 + (int)d);
/*      */     else
/*  627 */       addLdc2w(d);
/*      */   }
/*      */ 
/*      */   public void addDload(int n)
/*      */   {
/*  636 */     if (n < 4) {
/*  637 */       addOpcode(38 + n);
/*  638 */     } else if (n < 256) {
/*  639 */       addOpcode(24);
/*  640 */       add(n);
/*      */     }
/*      */     else {
/*  643 */       addOpcode(196);
/*  644 */       addOpcode(24);
/*  645 */       addIndex(n);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addDstore(int n)
/*      */   {
/*  655 */     if (n < 4) {
/*  656 */       addOpcode(71 + n);
/*  657 */     } else if (n < 256) {
/*  658 */       addOpcode(57);
/*  659 */       add(n);
/*      */     }
/*      */     else {
/*  662 */       addOpcode(196);
/*  663 */       addOpcode(57);
/*  664 */       addIndex(n);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addFconst(float f)
/*      */   {
/*  674 */     if ((f == 0.0F) || (f == 1.0F) || (f == 2.0F))
/*  675 */       addOpcode(11 + (int)f);
/*      */     else
/*  677 */       addLdc(this.constPool.addFloatInfo(f));
/*      */   }
/*      */ 
/*      */   public void addFload(int n)
/*      */   {
/*  686 */     if (n < 4) {
/*  687 */       addOpcode(34 + n);
/*  688 */     } else if (n < 256) {
/*  689 */       addOpcode(23);
/*  690 */       add(n);
/*      */     }
/*      */     else {
/*  693 */       addOpcode(196);
/*  694 */       addOpcode(23);
/*  695 */       addIndex(n);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addFstore(int n)
/*      */   {
/*  705 */     if (n < 4) {
/*  706 */       addOpcode(67 + n);
/*  707 */     } else if (n < 256) {
/*  708 */       addOpcode(56);
/*  709 */       add(n);
/*      */     }
/*      */     else {
/*  712 */       addOpcode(196);
/*  713 */       addOpcode(56);
/*  714 */       addIndex(n);
/*      */     }
/*      */   }
/*      */ 
/*      */   public int addLoad(int n, CtClass type)
/*      */   {
/*  727 */     if (type.isPrimitive()) {
/*  728 */       if ((type == CtClass.booleanType) || (type == CtClass.charType) || (type == CtClass.byteType) || (type == CtClass.shortType) || (type == CtClass.intType))
/*      */       {
/*  731 */         addIload(n); } else {
/*  732 */         if (type == CtClass.longType) {
/*  733 */           addLload(n);
/*  734 */           return 2;
/*      */         }
/*  736 */         if (type == CtClass.floatType) {
/*  737 */           addFload(n); } else {
/*  738 */           if (type == CtClass.doubleType) {
/*  739 */             addDload(n);
/*  740 */             return 2;
/*      */           }
/*      */ 
/*  743 */           throw new RuntimeException("void type?");
/*      */         }
/*      */       }
/*      */     } else addAload(n);
/*      */ 
/*  748 */     return 1;
/*      */   }
/*      */ 
/*      */   public int addStore(int n, CtClass type)
/*      */   {
/*  760 */     if (type.isPrimitive()) {
/*  761 */       if ((type == CtClass.booleanType) || (type == CtClass.charType) || (type == CtClass.byteType) || (type == CtClass.shortType) || (type == CtClass.intType))
/*      */       {
/*  764 */         addIstore(n); } else {
/*  765 */         if (type == CtClass.longType) {
/*  766 */           addLstore(n);
/*  767 */           return 2;
/*      */         }
/*  769 */         if (type == CtClass.floatType) {
/*  770 */           addFstore(n); } else {
/*  771 */           if (type == CtClass.doubleType) {
/*  772 */             addDstore(n);
/*  773 */             return 2;
/*      */           }
/*      */ 
/*  776 */           throw new RuntimeException("void type?");
/*      */         }
/*      */       }
/*      */     } else addAstore(n);
/*      */ 
/*  781 */     return 1;
/*      */   }
/*      */ 
/*      */   public int addLoadParameters(CtClass[] params, int offset)
/*      */   {
/*  792 */     int stacksize = 0;
/*  793 */     if (params != null) {
/*  794 */       int n = params.length;
/*  795 */       for (int i = 0; i < n; i++) {
/*  796 */         stacksize += addLoad(stacksize + offset, params[i]);
/*      */       }
/*      */     }
/*  799 */     return stacksize;
/*      */   }
/*      */ 
/*      */   public void addCheckcast(CtClass c)
/*      */   {
/*  808 */     addOpcode(192);
/*  809 */     addIndex(this.constPool.addClassInfo(c));
/*      */   }
/*      */ 
/*      */   public void addCheckcast(String classname)
/*      */   {
/*  818 */     addOpcode(192);
/*  819 */     addIndex(this.constPool.addClassInfo(classname));
/*      */   }
/*      */ 
/*      */   public void addInstanceof(String classname)
/*      */   {
/*  828 */     addOpcode(193);
/*  829 */     addIndex(this.constPool.addClassInfo(classname));
/*      */   }
/*      */ 
/*      */   public void addGetfield(CtClass c, String name, String type)
/*      */   {
/*  842 */     add(180);
/*  843 */     int ci = this.constPool.addClassInfo(c);
/*  844 */     addIndex(this.constPool.addFieldrefInfo(ci, name, type));
/*  845 */     growStack(Descriptor.dataSize(type) - 1);
/*      */   }
/*      */ 
/*      */   public void addGetfield(String c, String name, String type)
/*      */   {
/*  858 */     add(180);
/*  859 */     int ci = this.constPool.addClassInfo(c);
/*  860 */     addIndex(this.constPool.addFieldrefInfo(ci, name, type));
/*  861 */     growStack(Descriptor.dataSize(type) - 1);
/*      */   }
/*      */ 
/*      */   public void addGetstatic(CtClass c, String name, String type)
/*      */   {
/*  874 */     add(178);
/*  875 */     int ci = this.constPool.addClassInfo(c);
/*  876 */     addIndex(this.constPool.addFieldrefInfo(ci, name, type));
/*  877 */     growStack(Descriptor.dataSize(type));
/*      */   }
/*      */ 
/*      */   public void addGetstatic(String c, String name, String type)
/*      */   {
/*  890 */     add(178);
/*  891 */     int ci = this.constPool.addClassInfo(c);
/*  892 */     addIndex(this.constPool.addFieldrefInfo(ci, name, type));
/*  893 */     growStack(Descriptor.dataSize(type));
/*      */   }
/*      */ 
/*      */   public void addInvokespecial(CtClass clazz, String name, CtClass returnType, CtClass[] paramTypes)
/*      */   {
/*  906 */     String desc = Descriptor.ofMethod(returnType, paramTypes);
/*  907 */     addInvokespecial(clazz, name, desc);
/*      */   }
/*      */ 
/*      */   public void addInvokespecial(CtClass clazz, String name, String desc)
/*      */   {
/*  921 */     addInvokespecial(this.constPool.addClassInfo(clazz), name, desc);
/*      */   }
/*      */ 
/*      */   public void addInvokespecial(String clazz, String name, String desc)
/*      */   {
/*  935 */     addInvokespecial(this.constPool.addClassInfo(clazz), name, desc);
/*      */   }
/*      */ 
/*      */   public void addInvokespecial(int clazz, String name, String desc)
/*      */   {
/*  950 */     add(183);
/*  951 */     addIndex(this.constPool.addMethodrefInfo(clazz, name, desc));
/*  952 */     growStack(Descriptor.dataSize(desc) - 1);
/*      */   }
/*      */ 
/*      */   public void addInvokestatic(CtClass clazz, String name, CtClass returnType, CtClass[] paramTypes)
/*      */   {
/*  965 */     String desc = Descriptor.ofMethod(returnType, paramTypes);
/*  966 */     addInvokestatic(clazz, name, desc);
/*      */   }
/*      */ 
/*      */   public void addInvokestatic(CtClass clazz, String name, String desc)
/*      */   {
/*  979 */     addInvokestatic(this.constPool.addClassInfo(clazz), name, desc);
/*      */   }
/*      */ 
/*      */   public void addInvokestatic(String classname, String name, String desc)
/*      */   {
/*  992 */     addInvokestatic(this.constPool.addClassInfo(classname), name, desc);
/*      */   }
/*      */ 
/*      */   public void addInvokestatic(int clazz, String name, String desc)
/*      */   {
/* 1006 */     add(184);
/* 1007 */     addIndex(this.constPool.addMethodrefInfo(clazz, name, desc));
/* 1008 */     growStack(Descriptor.dataSize(desc));
/*      */   }
/*      */ 
/*      */   public void addInvokevirtual(CtClass clazz, String name, CtClass returnType, CtClass[] paramTypes)
/*      */   {
/* 1025 */     String desc = Descriptor.ofMethod(returnType, paramTypes);
/* 1026 */     addInvokevirtual(clazz, name, desc);
/*      */   }
/*      */ 
/*      */   public void addInvokevirtual(CtClass clazz, String name, String desc)
/*      */   {
/* 1043 */     addInvokevirtual(this.constPool.addClassInfo(clazz), name, desc);
/*      */   }
/*      */ 
/*      */   public void addInvokevirtual(String classname, String name, String desc)
/*      */   {
/* 1060 */     addInvokevirtual(this.constPool.addClassInfo(classname), name, desc);
/*      */   }
/*      */ 
/*      */   public void addInvokevirtual(int clazz, String name, String desc)
/*      */   {
/* 1078 */     add(182);
/* 1079 */     addIndex(this.constPool.addMethodrefInfo(clazz, name, desc));
/* 1080 */     growStack(Descriptor.dataSize(desc) - 1);
/*      */   }
/*      */ 
/*      */   public void addInvokeinterface(CtClass clazz, String name, CtClass returnType, CtClass[] paramTypes, int count)
/*      */   {
/* 1095 */     String desc = Descriptor.ofMethod(returnType, paramTypes);
/* 1096 */     addInvokeinterface(clazz, name, desc, count);
/*      */   }
/*      */ 
/*      */   public void addInvokeinterface(CtClass clazz, String name, String desc, int count)
/*      */   {
/* 1111 */     addInvokeinterface(this.constPool.addClassInfo(clazz), name, desc, count);
/*      */   }
/*      */ 
/*      */   public void addInvokeinterface(String classname, String name, String desc, int count)
/*      */   {
/* 1127 */     addInvokeinterface(this.constPool.addClassInfo(classname), name, desc, count);
/*      */   }
/*      */ 
/*      */   public void addInvokeinterface(int clazz, String name, String desc, int count)
/*      */   {
/* 1144 */     add(185);
/* 1145 */     addIndex(this.constPool.addInterfaceMethodrefInfo(clazz, name, desc));
/* 1146 */     add(count);
/* 1147 */     add(0);
/* 1148 */     growStack(Descriptor.dataSize(desc) - 1);
/*      */   }
/*      */ 
/*      */   public void addLdc(String s)
/*      */   {
/* 1158 */     addLdc(this.constPool.addStringInfo(s));
/*      */   }
/*      */ 
/*      */   public void addLdc(int i)
/*      */   {
/* 1167 */     if (i > 255) {
/* 1168 */       addOpcode(19);
/* 1169 */       addIndex(i);
/*      */     }
/*      */     else {
/* 1172 */       addOpcode(18);
/* 1173 */       add(i);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addLdc2w(long l)
/*      */   {
/* 1181 */     addOpcode(20);
/* 1182 */     addIndex(this.constPool.addLongInfo(l));
/*      */   }
/*      */ 
/*      */   public void addLdc2w(double d)
/*      */   {
/* 1189 */     addOpcode(20);
/* 1190 */     addIndex(this.constPool.addDoubleInfo(d));
/*      */   }
/*      */ 
/*      */   public void addNew(CtClass clazz)
/*      */   {
/* 1199 */     addOpcode(187);
/* 1200 */     addIndex(this.constPool.addClassInfo(clazz));
/*      */   }
/*      */ 
/*      */   public void addNew(String classname)
/*      */   {
/* 1209 */     addOpcode(187);
/* 1210 */     addIndex(this.constPool.addClassInfo(classname));
/*      */   }
/*      */ 
/*      */   public void addAnewarray(String classname)
/*      */   {
/* 1219 */     addOpcode(189);
/* 1220 */     addIndex(this.constPool.addClassInfo(classname));
/*      */   }
/*      */ 
/*      */   public void addAnewarray(CtClass clazz, int length)
/*      */   {
/* 1230 */     addIconst(length);
/* 1231 */     addOpcode(189);
/* 1232 */     addIndex(this.constPool.addClassInfo(clazz));
/*      */   }
/*      */ 
/*      */   public void addNewarray(int atype, int length)
/*      */   {
/* 1242 */     addIconst(length);
/* 1243 */     addOpcode(188);
/* 1244 */     add(atype);
/*      */   }
/*      */ 
/*      */   public int addMultiNewarray(CtClass clazz, int[] dimensions)
/*      */   {
/* 1255 */     int len = dimensions.length;
/* 1256 */     for (int i = 0; i < len; i++) {
/* 1257 */       addIconst(dimensions[i]);
/*      */     }
/* 1259 */     growStack(len);
/* 1260 */     return addMultiNewarray(clazz, len);
/*      */   }
/*      */ 
/*      */   public int addMultiNewarray(CtClass clazz, int dim)
/*      */   {
/* 1272 */     add(197);
/* 1273 */     addIndex(this.constPool.addClassInfo(clazz));
/* 1274 */     add(dim);
/* 1275 */     growStack(1 - dim);
/* 1276 */     return dim;
/*      */   }
/*      */ 
/*      */   public int addMultiNewarray(String desc, int dim)
/*      */   {
/* 1287 */     add(197);
/* 1288 */     addIndex(this.constPool.addClassInfo(desc));
/* 1289 */     add(dim);
/* 1290 */     growStack(1 - dim);
/* 1291 */     return dim;
/*      */   }
/*      */ 
/*      */   public void addPutfield(CtClass c, String name, String desc)
/*      */   {
/* 1302 */     addPutfield0(c, null, name, desc);
/*      */   }
/*      */ 
/*      */   public void addPutfield(String classname, String name, String desc)
/*      */   {
/* 1314 */     addPutfield0(null, classname, name, desc);
/*      */   }
/*      */ 
/*      */   private void addPutfield0(CtClass target, String classname, String name, String desc)
/*      */   {
/* 1319 */     add(181);
/*      */ 
/* 1321 */     int ci = classname == null ? this.constPool.addClassInfo(target) : this.constPool.addClassInfo(classname);
/*      */ 
/* 1323 */     addIndex(this.constPool.addFieldrefInfo(ci, name, desc));
/* 1324 */     growStack(-1 - Descriptor.dataSize(desc));
/*      */   }
/*      */ 
/*      */   public void addPutstatic(CtClass c, String name, String desc)
/*      */   {
/* 1335 */     addPutstatic0(c, null, name, desc);
/*      */   }
/*      */ 
/*      */   public void addPutstatic(String classname, String fieldName, String desc)
/*      */   {
/* 1347 */     addPutstatic0(null, classname, fieldName, desc);
/*      */   }
/*      */ 
/*      */   private void addPutstatic0(CtClass target, String classname, String fieldName, String desc)
/*      */   {
/* 1352 */     add(179);
/*      */ 
/* 1354 */     int ci = classname == null ? this.constPool.addClassInfo(target) : this.constPool.addClassInfo(classname);
/*      */ 
/* 1356 */     addIndex(this.constPool.addFieldrefInfo(ci, fieldName, desc));
/* 1357 */     growStack(-Descriptor.dataSize(desc));
/*      */   }
/*      */ 
/*      */   public void addReturn(CtClass type)
/*      */   {
/* 1366 */     if (type == null) {
/* 1367 */       addOpcode(177);
/* 1368 */     } else if (type.isPrimitive()) {
/* 1369 */       CtPrimitiveType ptype = (CtPrimitiveType)type;
/* 1370 */       addOpcode(ptype.getReturnOp());
/*      */     }
/*      */     else {
/* 1373 */       addOpcode(176);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addRet(int var)
/*      */   {
/* 1382 */     if (var < 256) {
/* 1383 */       addOpcode(169);
/* 1384 */       add(var);
/*      */     }
/*      */     else {
/* 1387 */       addOpcode(196);
/* 1388 */       addOpcode(169);
/* 1389 */       addIndex(var);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addPrintln(String message)
/*      */   {
/* 1400 */     addGetstatic("java.lang.System", "err", "Ljava/io/PrintStream;");
/* 1401 */     addLdc(message);
/* 1402 */     addInvokevirtual("java.io.PrintStream", "println", "(Ljava/lang/String;)V");
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javassist.bytecode.Bytecode
 * JD-Core Version:    0.6.0
 */