/*    */ package javassist;
/*    */ 
/*    */ final class CtArray extends CtClass
/*    */ {
/*    */   protected ClassPool pool;
/*    */ 
/*    */   CtArray(String name, ClassPool cp)
/*    */   {
/* 26 */     super(name);
/* 27 */     this.pool = cp;
/*    */   }
/*    */ 
/*    */   public ClassPool getClassPool() {
/* 31 */     return this.pool;
/*    */   }
/*    */ 
/*    */   public boolean isArray() {
/* 35 */     return true;
/*    */   }
/*    */ 
/*    */   public boolean subtypeOf(CtClass clazz) throws NotFoundException {
/* 39 */     if (super.subtypeOf(clazz)) {
/* 40 */       return true;
/*    */     }
/* 42 */     String cname = clazz.getName();
/* 43 */     if ((cname.equals("java.lang.Object")) || (cname.equals("java.lang.Cloneable")) || (cname.equals("java.io.Serializable")))
/*    */     {
/* 46 */       return true;
/*    */     }
/* 48 */     return (clazz.isArray()) && (getComponentType().subtypeOf(clazz.getComponentType()));
/*    */   }
/*    */ 
/*    */   public CtClass getComponentType() throws NotFoundException
/*    */   {
/* 53 */     String name = getName();
/* 54 */     return this.pool.get(name.substring(0, name.length() - 2));
/*    */   }
/*    */ 
/*    */   public CtClass getSuperclass() throws NotFoundException {
/* 58 */     return this.pool.get("java.lang.Object");
/*    */   }
/*    */ 
/*    */   public CtMethod[] getMethods() {
/*    */     try {
/* 63 */       return getSuperclass().getMethods();
/*    */     } catch (NotFoundException e) {
/*    */     }
/* 66 */     return super.getMethods();
/*    */   }
/*    */ 
/*    */   public CtMethod getMethod(String name, String desc)
/*    */     throws NotFoundException
/*    */   {
/* 73 */     return getSuperclass().getMethod(name, desc);
/*    */   }
/*    */ 
/*    */   public CtConstructor[] getConstructors() {
/*    */     try {
/* 78 */       return getSuperclass().getConstructors();
/*    */     } catch (NotFoundException e) {
/*    */     }
/* 81 */     return super.getConstructors();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javassist.CtArray
 * JD-Core Version:    0.6.0
 */