/*    */ package gnu.trove.benchmark;
/*    */ 
/*    */ import java.io.OutputStreamWriter;
/*    */ import java.io.PrintWriter;
/*    */ 
/*    */ class TextReporter
/*    */   implements Reporter
/*    */ {
/*    */   PrintWriter out;
/*    */ 
/*    */   TextReporter()
/*    */   {
/* 27 */     this(new PrintWriter(new OutputStreamWriter(System.out), true));
/*    */   }
/*    */ 
/*    */   TextReporter(PrintWriter out) {
/* 31 */     this.out = out;
/*    */   }
/*    */ 
/*    */   public void report(Result result) {
/* 35 */     this.out.print(result);
/* 36 */     this.out.println("--------------------------------");
/*    */   }
/*    */ 
/*    */   public void start() {
/* 40 */     this.out.println("--------------------------------");
/* 41 */     this.out.println("GNU Trove Benchmark suite");
/* 42 */     this.out.println("--------------------------------");
/* 43 */     for (int i = 0; i < Reporter.ENV_PROPS.length; i++) {
/* 44 */       String key = Reporter.ENV_PROPS[i];
/* 45 */       this.out.println(key + "=" + System.getProperty(key));
/*    */     }
/* 47 */     this.out.println("--------------------------------");
/*    */   }
/*    */ 
/*    */   public void finish() {
/* 51 */     this.out.println("done");
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     gnu.trove.benchmark.TextReporter
 * JD-Core Version:    0.6.0
 */