/*     */ package gnu.trove;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ 
/*     */ public class TLongFloatHashMap extends TLongHash
/*     */   implements Serializable
/*     */ {
/*     */   protected transient float[] _values;
/*     */ 
/*     */   public TLongFloatHashMap()
/*     */   {
/*     */   }
/*     */ 
/*     */   public TLongFloatHashMap(int initialCapacity)
/*     */   {
/*  55 */     super(initialCapacity);
/*     */   }
/*     */ 
/*     */   public TLongFloatHashMap(int initialCapacity, float loadFactor)
/*     */   {
/*  67 */     super(initialCapacity, loadFactor);
/*     */   }
/*     */ 
/*     */   public TLongFloatHashMap(TLongHashingStrategy strategy)
/*     */   {
/*  76 */     super(strategy);
/*     */   }
/*     */ 
/*     */   public TLongFloatHashMap(int initialCapacity, TLongHashingStrategy strategy)
/*     */   {
/*  88 */     super(initialCapacity, strategy);
/*     */   }
/*     */ 
/*     */   public TLongFloatHashMap(int initialCapacity, float loadFactor, TLongHashingStrategy strategy)
/*     */   {
/* 101 */     super(initialCapacity, loadFactor, strategy);
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/* 108 */     TLongFloatHashMap m = (TLongFloatHashMap)super.clone();
/* 109 */     m._values = ((float[])this._values.clone());
/* 110 */     return m;
/*     */   }
/*     */ 
/*     */   public TLongFloatIterator iterator()
/*     */   {
/* 117 */     return new TLongFloatIterator(this);
/*     */   }
/*     */ 
/*     */   protected int setUp(int initialCapacity)
/*     */   {
/* 130 */     int capacity = super.setUp(initialCapacity);
/* 131 */     this._values = new float[capacity];
/* 132 */     return capacity;
/*     */   }
/*     */ 
/*     */   public float put(long key, float value)
/*     */   {
/* 145 */     float previous = 0.0F;
/* 146 */     int index = insertionIndex(key);
/* 147 */     boolean isNewMapping = true;
/* 148 */     if (index < 0) {
/* 149 */       index = -index - 1;
/* 150 */       previous = this._values[index];
/* 151 */       isNewMapping = false;
/*     */     }
/* 153 */     byte previousState = this._states[index];
/* 154 */     this._set[index] = key;
/* 155 */     this._states[index] = 1;
/* 156 */     this._values[index] = value;
/* 157 */     if (isNewMapping) {
/* 158 */       postInsertHook(previousState == 0);
/*     */     }
/*     */ 
/* 161 */     return previous;
/*     */   }
/*     */ 
/*     */   protected void rehash(int newCapacity)
/*     */   {
/* 170 */     int oldCapacity = this._set.length;
/* 171 */     long[] oldKeys = this._set;
/* 172 */     float[] oldVals = this._values;
/* 173 */     byte[] oldStates = this._states;
/*     */ 
/* 175 */     this._set = new long[newCapacity];
/* 176 */     this._values = new float[newCapacity];
/* 177 */     this._states = new byte[newCapacity];
/*     */ 
/* 179 */     for (int i = oldCapacity; i-- > 0; )
/* 180 */       if (oldStates[i] == 1) {
/* 181 */         long o = oldKeys[i];
/* 182 */         int index = insertionIndex(o);
/* 183 */         this._set[index] = o;
/* 184 */         this._values[index] = oldVals[i];
/* 185 */         this._states[index] = 1;
/*     */       }
/*     */   }
/*     */ 
/*     */   public float get(long key)
/*     */   {
/* 197 */     int index = index(key);
/* 198 */     return index < 0 ? 0.0F : this._values[index];
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 206 */     super.clear();
/* 207 */     long[] keys = this._set;
/* 208 */     float[] vals = this._values;
/* 209 */     byte[] states = this._states;
/*     */ 
/* 211 */     for (int i = keys.length; i-- > 0; ) {
/* 212 */       keys[i] = 0L;
/* 213 */       vals[i] = 0.0F;
/* 214 */       states[i] = 0;
/*     */     }
/*     */   }
/*     */ 
/*     */   public float remove(long key)
/*     */   {
/* 225 */     float prev = 0.0F;
/* 226 */     int index = index(key);
/* 227 */     if (index >= 0) {
/* 228 */       prev = this._values[index];
/* 229 */       removeAt(index);
/*     */     }
/* 231 */     return prev;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object other)
/*     */   {
/* 242 */     if (!(other instanceof TLongFloatHashMap)) {
/* 243 */       return false;
/*     */     }
/* 245 */     TLongFloatHashMap that = (TLongFloatHashMap)other;
/* 246 */     if (that.size() != size()) {
/* 247 */       return false;
/*     */     }
/* 249 */     return forEachEntry(new EqProcedure(that));
/*     */   }
/*     */ 
/*     */   public int hashCode() {
/* 253 */     HashProcedure p = new HashProcedure(null);
/* 254 */     forEachEntry(p);
/* 255 */     return p.getHashCode();
/*     */   }
/*     */ 
/*     */   protected void removeAt(int index)
/*     */   {
/* 301 */     super.removeAt(index);
/* 302 */     this._values[index] = 0.0F;
/*     */   }
/*     */ 
/*     */   public float[] getValues()
/*     */   {
/* 311 */     float[] vals = new float[size()];
/* 312 */     float[] v = this._values;
/* 313 */     byte[] states = this._states;
/*     */ 
/* 315 */     int i = v.length; for (int j = 0; i-- > 0; ) {
/* 316 */       if (states[i] == 1) {
/* 317 */         vals[(j++)] = v[i];
/*     */       }
/*     */     }
/* 320 */     return vals;
/*     */   }
/*     */ 
/*     */   public long[] keys()
/*     */   {
/* 329 */     long[] keys = new long[size()];
/* 330 */     long[] k = this._set;
/* 331 */     byte[] states = this._states;
/*     */ 
/* 333 */     int i = k.length; for (int j = 0; i-- > 0; ) {
/* 334 */       if (states[i] == 1) {
/* 335 */         keys[(j++)] = k[i];
/*     */       }
/*     */     }
/* 338 */     return keys;
/*     */   }
/*     */ 
/*     */   public boolean containsValue(float val)
/*     */   {
/* 348 */     byte[] states = this._states;
/* 349 */     float[] vals = this._values;
/*     */ 
/* 351 */     for (int i = vals.length; i-- > 0; ) {
/* 352 */       if ((states[i] == 1) && (val == vals[i])) {
/* 353 */         return true;
/*     */       }
/*     */     }
/* 356 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean containsKey(long key)
/*     */   {
/* 367 */     return contains(key);
/*     */   }
/*     */ 
/*     */   public boolean forEachKey(TLongProcedure procedure)
/*     */   {
/* 378 */     return forEach(procedure);
/*     */   }
/*     */ 
/*     */   public boolean forEachValue(TFloatProcedure procedure)
/*     */   {
/* 389 */     byte[] states = this._states;
/* 390 */     float[] values = this._values;
/* 391 */     for (int i = values.length; i-- > 0; ) {
/* 392 */       if ((states[i] == 1) && (!procedure.execute(values[i]))) {
/* 393 */         return false;
/*     */       }
/*     */     }
/* 396 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean forEachEntry(TLongFloatProcedure procedure)
/*     */   {
/* 408 */     byte[] states = this._states;
/* 409 */     long[] keys = this._set;
/* 410 */     float[] values = this._values;
/* 411 */     for (int i = keys.length; i-- > 0; ) {
/* 412 */       if ((states[i] == 1) && (!procedure.execute(keys[i], values[i]))) {
/* 413 */         return false;
/*     */       }
/*     */     }
/* 416 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean retainEntries(TLongFloatProcedure procedure)
/*     */   {
/* 427 */     boolean modified = false;
/* 428 */     byte[] states = this._states;
/* 429 */     long[] keys = this._set;
/* 430 */     float[] values = this._values;
/* 431 */     for (int i = keys.length; i-- > 0; ) {
/* 432 */       if ((states[i] == 1) && (!procedure.execute(keys[i], values[i]))) {
/* 433 */         removeAt(i);
/* 434 */         modified = true;
/*     */       }
/*     */     }
/* 437 */     return modified;
/*     */   }
/*     */ 
/*     */   public void transformValues(TFloatFunction function)
/*     */   {
/* 446 */     byte[] states = this._states;
/* 447 */     float[] values = this._values;
/* 448 */     for (int i = values.length; i-- > 0; )
/* 449 */       if (states[i] == 1)
/* 450 */         values[i] = function.execute(values[i]);
/*     */   }
/*     */ 
/*     */   public boolean increment(long key)
/*     */   {
/* 462 */     return adjustValue(key, 1.0F);
/*     */   }
/*     */ 
/*     */   public boolean adjustValue(long key, float amount)
/*     */   {
/* 473 */     int index = index(key);
/* 474 */     if (index < 0) {
/* 475 */       return false;
/*     */     }
/* 477 */     this._values[index] += amount;
/* 478 */     return true;
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream stream)
/*     */     throws IOException
/*     */   {
/* 485 */     stream.defaultWriteObject();
/*     */ 
/* 488 */     stream.writeInt(this._size);
/*     */ 
/* 490 */     SerializationProcedure writeProcedure = new SerializationProcedure(stream);
/* 491 */     if (!forEachEntry(writeProcedure))
/* 492 */       throw writeProcedure.exception;
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream stream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 498 */     stream.defaultReadObject();
/*     */ 
/* 500 */     int size = stream.readInt();
/* 501 */     setUp(size);
/* 502 */     while (size-- > 0) {
/* 503 */       long key = stream.readLong();
/* 504 */       float val = stream.readFloat();
/* 505 */       put(key, val);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static final class EqProcedure
/*     */     implements TLongFloatProcedure
/*     */   {
/*     */     private final TLongFloatHashMap _otherMap;
/*     */ 
/*     */     EqProcedure(TLongFloatHashMap otherMap)
/*     */     {
/* 275 */       this._otherMap = otherMap;
/*     */     }
/*     */ 
/*     */     public final boolean execute(long key, float value) {
/* 279 */       int index = this._otherMap.index(key);
/*     */ 
/* 281 */       return (index >= 0) && (eq(value, this._otherMap.get(key)));
/*     */     }
/*     */ 
/*     */     private final boolean eq(float v1, float v2)
/*     */     {
/* 290 */       return v1 == v2;
/*     */     }
/*     */   }
/*     */ 
/*     */   private final class HashProcedure
/*     */     implements TLongFloatProcedure
/*     */   {
/*     */     private int h;
/*     */     private final TLongFloatHashMap this$0;
/*     */ 
/*     */     private HashProcedure()
/*     */     {
/* 258 */       this.this$0 = this$0;
/* 259 */       this.h = 0;
/*     */     }
/*     */     public int getHashCode() {
/* 262 */       return this.h;
/*     */     }
/*     */ 
/*     */     public final boolean execute(long key, float value) {
/* 266 */       this.h += (this.this$0._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value));
/* 267 */       return true;
/*     */     }
/*     */ 
/*     */     HashProcedure(TLongFloatHashMap.1 x1)
/*     */     {
/* 258 */       this();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     gnu.trove.TLongFloatHashMap
 * JD-Core Version:    0.6.0
 */