/*     */ package gnu.trove;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ 
/*     */ public abstract class TFloatHash extends TPrimitiveHash
/*     */   implements Serializable, TFloatHashingStrategy
/*     */ {
/*     */   protected transient float[] _set;
/*     */   protected TFloatHashingStrategy _hashingStrategy;
/*     */ 
/*     */   public TFloatHash()
/*     */   {
/*  47 */     this._hashingStrategy = this;
/*     */   }
/*     */ 
/*     */   public TFloatHash(int initialCapacity)
/*     */   {
/*  58 */     super(initialCapacity);
/*  59 */     this._hashingStrategy = this;
/*     */   }
/*     */ 
/*     */   public TFloatHash(int initialCapacity, float loadFactor)
/*     */   {
/*  71 */     super(initialCapacity, loadFactor);
/*  72 */     this._hashingStrategy = this;
/*     */   }
/*     */ 
/*     */   public TFloatHash(TFloatHashingStrategy strategy)
/*     */   {
/*  82 */     this._hashingStrategy = strategy;
/*     */   }
/*     */ 
/*     */   public TFloatHash(int initialCapacity, TFloatHashingStrategy strategy)
/*     */   {
/*  94 */     super(initialCapacity);
/*  95 */     this._hashingStrategy = strategy;
/*     */   }
/*     */ 
/*     */   public TFloatHash(int initialCapacity, float loadFactor, TFloatHashingStrategy strategy)
/*     */   {
/* 108 */     super(initialCapacity, loadFactor);
/* 109 */     this._hashingStrategy = strategy;
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/* 116 */     TFloatHash h = (TFloatHash)super.clone();
/* 117 */     h._set = ((float[])this._set.clone());
/* 118 */     return h;
/*     */   }
/*     */ 
/*     */   protected int setUp(int initialCapacity)
/*     */   {
/* 131 */     int capacity = super.setUp(initialCapacity);
/* 132 */     this._set = new float[capacity];
/* 133 */     return capacity;
/*     */   }
/*     */ 
/*     */   public boolean contains(float val)
/*     */   {
/* 143 */     return index(val) >= 0;
/*     */   }
/*     */ 
/*     */   public boolean forEach(TFloatProcedure procedure)
/*     */   {
/* 154 */     byte[] states = this._states;
/* 155 */     float[] set = this._set;
/* 156 */     for (int i = set.length; i-- > 0; ) {
/* 157 */       if ((states[i] == 1) && (!procedure.execute(set[i]))) {
/* 158 */         return false;
/*     */       }
/*     */     }
/* 161 */     return true;
/*     */   }
/*     */ 
/*     */   protected void removeAt(int index)
/*     */   {
/* 170 */     super.removeAt(index);
/* 171 */     this._set[index] = 0.0F;
/*     */   }
/*     */ 
/*     */   protected int index(float val)
/*     */   {
/* 185 */     byte[] states = this._states;
/* 186 */     float[] set = this._set;
/* 187 */     int length = states.length;
/* 188 */     int hash = this._hashingStrategy.computeHashCode(val) & 0x7FFFFFFF;
/* 189 */     int index = hash % length;
/*     */ 
/* 191 */     if ((states[index] != 0) && ((states[index] == 2) || (set[index] != val)))
/*     */     {
/* 194 */       int probe = 1 + hash % (length - 2);
/*     */       do
/*     */       {
/* 197 */         index -= probe;
/* 198 */         if (index < 0)
/* 199 */           index += length;
/*     */       }
/* 201 */       while ((states[index] != 0) && ((states[index] == 2) || (set[index] != val)));
/*     */     }
/*     */ 
/* 205 */     return states[index] == 0 ? -1 : index;
/*     */   }
/*     */ 
/*     */   protected int insertionIndex(float val)
/*     */   {
/* 221 */     byte[] states = this._states;
/* 222 */     float[] set = this._set;
/* 223 */     int length = states.length;
/* 224 */     int hash = this._hashingStrategy.computeHashCode(val) & 0x7FFFFFFF;
/* 225 */     int index = hash % length;
/*     */ 
/* 227 */     if (states[index] == 0)
/* 228 */       return index;
/* 229 */     if ((states[index] == 1) && (set[index] == val)) {
/* 230 */       return -index - 1;
/*     */     }
/*     */ 
/* 233 */     int probe = 1 + hash % (length - 2);
/*     */     do
/*     */     {
/* 237 */       index -= probe;
/* 238 */       if (index < 0)
/* 239 */         index += length;
/*     */     }
/* 241 */     while ((states[index] == 1) && (set[index] != val));
/*     */ 
/* 246 */     if (states[index] == 2) {
/* 247 */       int firstRemoved = index;
/* 248 */       while ((states[index] != 0) && ((states[index] == 2) || (set[index] != val)))
/*     */       {
/* 250 */         index -= probe;
/* 251 */         if (index < 0) {
/* 252 */           index += length;
/*     */         }
/*     */       }
/* 255 */       return states[index] == 1 ? -index - 1 : firstRemoved;
/*     */     }
/*     */ 
/* 258 */     return states[index] == 1 ? -index - 1 : index;
/*     */   }
/*     */ 
/*     */   public final int computeHashCode(float val)
/*     */   {
/* 270 */     return HashFunctions.hash(val);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     gnu.trove.TFloatHash
 * JD-Core Version:    0.6.0
 */