/*     */ package com.sun.xml.bind.v2.runtime.reflect;
/*     */ 
/*     */ import com.sun.xml.bind.api.AccessorException;
/*     */ import com.sun.xml.bind.v2.runtime.XMLSerializer;
/*     */ import java.util.Map;
/*     */ 
/*     */ final class PrimitiveArrayListerDouble<BeanT> extends Lister<BeanT, double[], Double, DoubleArrayPack>
/*     */ {
/*     */   static void register()
/*     */   {
/*  55 */     Lister.primitiveArrayListers.put(Double.TYPE, new PrimitiveArrayListerDouble());
/*     */   }
/*     */ 
/*     */   public ListIterator<Double> iterator(double[] objects, XMLSerializer context) {
/*  59 */     return new ListIterator(objects) {
/*  60 */       int idx = 0;
/*     */ 
/*  62 */       public boolean hasNext() { return this.idx < this.val$objects.length; }
/*     */ 
/*     */       public Double next()
/*     */       {
/*  66 */         return Double.valueOf(this.val$objects[(this.idx++)]);
/*     */       } } ;
/*     */   }
/*     */ 
/*     */   public DoubleArrayPack startPacking(BeanT current, Accessor<BeanT, double[]> acc) {
/*  72 */     return new DoubleArrayPack();
/*     */   }
/*     */ 
/*     */   public void addToPack(DoubleArrayPack objects, Double o) {
/*  76 */     objects.add(o);
/*     */   }
/*     */ 
/*     */   public void endPacking(DoubleArrayPack pack, BeanT bean, Accessor<BeanT, double[]> acc) throws AccessorException {
/*  80 */     acc.set(bean, pack.build());
/*     */   }
/*     */ 
/*     */   public void reset(BeanT o, Accessor<BeanT, double[]> acc) throws AccessorException {
/*  84 */     acc.set(o, new double[0]);
/*     */   }
/*  88 */   static final class DoubleArrayPack { double[] buf = new double[16];
/*     */     int size;
/*     */ 
/*     */     void add(Double b) {
/*  92 */       if (this.buf.length == this.size)
/*     */       {
/*  94 */         double[] nb = new double[this.buf.length * 2];
/*  95 */         System.arraycopy(this.buf, 0, nb, 0, this.buf.length);
/*  96 */         this.buf = nb;
/*     */       }
/*  98 */       this.buf[(this.size++)] = b.doubleValue();
/*     */     }
/*     */ 
/*     */     double[] build() {
/* 102 */       if (this.buf.length == this.size)
/*     */       {
/* 104 */         return this.buf;
/*     */       }
/* 106 */       double[] r = new double[this.size];
/* 107 */       System.arraycopy(this.buf, 0, r, 0, this.size);
/* 108 */       return r;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.runtime.reflect.PrimitiveArrayListerDouble
 * JD-Core Version:    0.6.0
 */