/*     */ package com.sun.xml.bind.v2.runtime.property;
/*     */ 
/*     */ import com.sun.xml.bind.api.AccessorException;
/*     */ import com.sun.xml.bind.v2.ClassFactory;
/*     */ import com.sun.xml.bind.v2.model.core.PropertyKind;
/*     */ import com.sun.xml.bind.v2.model.core.WildcardMode;
/*     */ import com.sun.xml.bind.v2.model.runtime.RuntimeElement;
/*     */ import com.sun.xml.bind.v2.model.runtime.RuntimeReferencePropertyInfo;
/*     */ import com.sun.xml.bind.v2.runtime.ElementBeanInfoImpl;
/*     */ import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
/*     */ import com.sun.xml.bind.v2.runtime.JaxBeanInfo;
/*     */ import com.sun.xml.bind.v2.runtime.XMLSerializer;
/*     */ import com.sun.xml.bind.v2.runtime.reflect.Accessor;
/*     */ import com.sun.xml.bind.v2.runtime.unmarshaller.ChildLoader;
/*     */ import com.sun.xml.bind.v2.runtime.unmarshaller.WildcardLoader;
/*     */ import com.sun.xml.bind.v2.util.QNameMap;
/*     */ import com.sun.xml.bind.v2.util.QNameMap.Entry;
/*     */ import java.io.IOException;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import javax.xml.bind.JAXBElement;
/*     */ import javax.xml.bind.JAXBException;
/*     */ import javax.xml.bind.annotation.DomHandler;
/*     */ import javax.xml.stream.XMLStreamException;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ final class SingleReferenceNodeProperty<BeanT, ValueT> extends PropertyImpl<BeanT>
/*     */ {
/*     */   private final Accessor<BeanT, ValueT> acc;
/*  71 */   private final QNameMap<JaxBeanInfo> expectedElements = new QNameMap();
/*     */   private final DomHandler domHandler;
/*     */   private final WildcardMode wcMode;
/*     */ 
/*     */   public SingleReferenceNodeProperty(JAXBContextImpl context, RuntimeReferencePropertyInfo prop)
/*     */   {
/*  77 */     super(context, prop);
/*  78 */     this.acc = prop.getAccessor().optimize(context);
/*     */ 
/*  80 */     for (RuntimeElement e : prop.getElements()) {
/*  81 */       this.expectedElements.put(e.getElementName(), context.getOrCreate(e));
/*     */     }
/*     */ 
/*  84 */     if (prop.getWildcard() != null) {
/*  85 */       this.domHandler = ((DomHandler)ClassFactory.create((Class)prop.getDOMHandler()));
/*  86 */       this.wcMode = prop.getWildcard();
/*     */     } else {
/*  88 */       this.domHandler = null;
/*  89 */       this.wcMode = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void reset(BeanT bean) throws AccessorException {
/*  94 */     this.acc.set(bean, null);
/*     */   }
/*     */ 
/*     */   public String getIdValue(BeanT beanT) {
/*  98 */     return null;
/*     */   }
/*     */ 
/*     */   public void serializeBody(BeanT o, XMLSerializer w, Object outerPeer) throws SAXException, AccessorException, IOException, XMLStreamException {
/* 102 */     Object v = this.acc.get(o);
/* 103 */     if (v != null)
/*     */       try {
/* 105 */         JaxBeanInfo bi = w.grammar.getBeanInfo(v, true);
/* 106 */         if ((bi.jaxbType == Object.class) && (this.domHandler != null))
/*     */         {
/* 109 */           w.writeDom(v, this.domHandler, o, this.fieldName);
/*     */         }
/* 111 */         else bi.serializeRoot(v, w); 
/*     */       }
/*     */       catch (JAXBException e) {
/* 113 */         w.reportError(this.fieldName, e);
/*     */       }
/*     */   }
/*     */ 
/*     */   public void buildChildElementUnmarshallers(UnmarshallerChain chain, QNameMap<ChildLoader> handlers)
/*     */   {
/* 120 */     for (QNameMap.Entry n : this.expectedElements.entrySet()) {
/* 121 */       handlers.put(n.nsUri, n.localName, new ChildLoader(((JaxBeanInfo)n.getValue()).getLoader(chain.context, true), this.acc));
/*     */     }
/* 123 */     if (this.domHandler != null)
/* 124 */       handlers.put(CATCH_ALL, new ChildLoader(new WildcardLoader(this.domHandler, this.wcMode), this.acc));
/*     */   }
/*     */ 
/*     */   public PropertyKind getKind()
/*     */   {
/* 129 */     return PropertyKind.REFERENCE;
/*     */   }
/*     */ 
/*     */   public Accessor getElementPropertyAccessor(String nsUri, String localName)
/*     */   {
/* 134 */     JaxBeanInfo bi = (JaxBeanInfo)this.expectedElements.get(nsUri, localName);
/* 135 */     if (bi != null) {
/* 136 */       if ((bi instanceof ElementBeanInfoImpl)) {
/* 137 */         ElementBeanInfoImpl ebi = (ElementBeanInfoImpl)bi;
/*     */ 
/* 139 */         return new Accessor(ebi.expectedType, ebi) {
/*     */           public Object get(BeanT bean) throws AccessorException {
/* 141 */             Object r = SingleReferenceNodeProperty.this.acc.get(bean);
/* 142 */             if ((r instanceof JAXBElement)) {
/* 143 */               return ((JAXBElement)r).getValue();
/*     */             }
/*     */ 
/* 146 */             return r;
/*     */           }
/*     */ 
/*     */           public void set(BeanT bean, Object value) throws AccessorException {
/* 150 */             if (value != null) {
/*     */               try {
/* 152 */                 value = this.val$ebi.createInstanceFromValue(value);
/*     */               } catch (IllegalAccessException e) {
/* 154 */                 throw new AccessorException(e);
/*     */               } catch (InvocationTargetException e) {
/* 156 */                 throw new AccessorException(e);
/*     */               } catch (InstantiationException e) {
/* 158 */                 throw new AccessorException(e);
/*     */               }
/*     */             }
/* 161 */             SingleReferenceNodeProperty.this.acc.set(bean, value);
/*     */           }
/*     */         };
/*     */       }
/* 166 */       return this.acc;
/*     */     }
/*     */ 
/* 169 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.runtime.property.SingleReferenceNodeProperty
 * JD-Core Version:    0.6.0
 */