/*     */ package com.sun.xml.bind.v2.runtime.output;
/*     */ 
/*     */ import com.sun.istack.FinalArrayList;
/*     */ import com.sun.xml.bind.v2.runtime.Name;
/*     */ import java.io.IOException;
/*     */ import java.io.OutputStream;
/*     */ import java.util.Arrays;
/*     */ import java.util.Collections;
/*     */ 
/*     */ public class C14nXmlOutput extends UTF8XmlOutput
/*     */ {
/*  68 */   private StaticAttribute[] staticAttributes = new StaticAttribute[8];
/*  69 */   private int len = 0;
/*     */ 
/*  74 */   private int[] nsBuf = new int[8];
/*     */ 
/*  83 */   private final FinalArrayList<DynamicAttribute> otherAttributes = new FinalArrayList();
/*     */   private final boolean namedAttributesAreOrdered;
/*     */ 
/*     */   public C14nXmlOutput(OutputStream out, Encoded[] localNames, boolean namedAttributesAreOrdered)
/*     */   {
/*  56 */     super(out, localNames);
/*  57 */     this.namedAttributesAreOrdered = namedAttributesAreOrdered;
/*     */ 
/*  59 */     for (int i = 0; i < this.staticAttributes.length; i++)
/*  60 */       this.staticAttributes[i] = new StaticAttribute();
/*     */   }
/*     */ 
/*     */   public void attribute(Name name, String value)
/*     */     throws IOException
/*     */   {
/* 147 */     if (this.staticAttributes.length == this.len)
/*     */     {
/* 149 */       int newLen = this.len * 2;
/* 150 */       StaticAttribute[] newbuf = new StaticAttribute[newLen];
/* 151 */       System.arraycopy(this.staticAttributes, 0, newbuf, 0, this.len);
/* 152 */       for (int i = this.len; i < newLen; i++)
/* 153 */         this.staticAttributes[i] = new StaticAttribute();
/* 154 */       this.staticAttributes = newbuf;
/*     */     }
/*     */ 
/* 157 */     this.staticAttributes[(this.len++)].set(name, value);
/*     */   }
/*     */ 
/*     */   public void attribute(int prefix, String localName, String value) throws IOException
/*     */   {
/* 162 */     this.otherAttributes.add(new DynamicAttribute(prefix, localName, value));
/*     */   }
/*     */ 
/*     */   public void endStartTag() throws IOException
/*     */   {
/* 167 */     if (this.otherAttributes.isEmpty()) {
/* 168 */       if (this.len != 0)
/*     */       {
/* 171 */         if (!this.namedAttributesAreOrdered) {
/* 172 */           Arrays.sort(this.staticAttributes, 0, this.len);
/*     */         }
/* 174 */         for (int i = 0; i < this.len; i++)
/* 175 */           this.staticAttributes[i].write();
/* 176 */         this.len = 0;
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 182 */       for (int i = 0; i < this.len; i++)
/* 183 */         this.otherAttributes.add(this.staticAttributes[i].toDynamicAttribute());
/* 184 */       this.len = 0;
/* 185 */       Collections.sort(this.otherAttributes);
/*     */ 
/* 188 */       int size = this.otherAttributes.size();
/* 189 */       for (int i = 0; i < size; i++) {
/* 190 */         DynamicAttribute a = (DynamicAttribute)this.otherAttributes.get(i);
/* 191 */         super.attribute(a.prefix, a.localName, a.value);
/*     */       }
/* 193 */       this.otherAttributes.clear();
/*     */     }
/* 195 */     super.endStartTag();
/*     */   }
/*     */ 
/*     */   protected void writeNsDecls(int base)
/*     */     throws IOException
/*     */   {
/* 203 */     int count = this.nsContext.getCurrent().count();
/*     */ 
/* 205 */     if (count == 0) {
/* 206 */       return;
/*     */     }
/* 208 */     if (count > this.nsBuf.length) {
/* 209 */       this.nsBuf = new int[count];
/*     */     }
/* 211 */     for (int i = count - 1; i >= 0; i--) {
/* 212 */       this.nsBuf[i] = (base + i);
/*     */     }
/*     */ 
/* 216 */     for (int i = 0; i < count; i++) {
/* 217 */       for (int j = i + 1; j < count; j++) {
/* 218 */         String p = this.nsContext.getPrefix(this.nsBuf[i]);
/* 219 */         String q = this.nsContext.getPrefix(this.nsBuf[j]);
/* 220 */         if (p.compareTo(q) <= 0)
/*     */           continue;
/* 222 */         int t = this.nsBuf[j];
/* 223 */         this.nsBuf[j] = this.nsBuf[i];
/* 224 */         this.nsBuf[i] = t;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 230 */     for (int i = 0; i < count; i++)
/* 231 */       writeNsDecl(this.nsBuf[i]);
/*     */   }
/*     */ 
/*     */   final class DynamicAttribute
/*     */     implements Comparable<DynamicAttribute>
/*     */   {
/*     */     final int prefix;
/*     */     final String localName;
/*     */     final String value;
/*     */ 
/*     */     public DynamicAttribute(int prefix, String localName, String value)
/*     */     {
/* 128 */       this.prefix = prefix;
/* 129 */       this.localName = localName;
/* 130 */       this.value = value;
/*     */     }
/*     */ 
/*     */     private String getURI() {
/* 134 */       if (this.prefix == -1) return "";
/* 135 */       return C14nXmlOutput.this.nsContext.getNamespaceURI(this.prefix);
/*     */     }
/*     */ 
/*     */     public int compareTo(DynamicAttribute that) {
/* 139 */       int r = getURI().compareTo(that.getURI());
/* 140 */       if (r != 0) return r;
/* 141 */       return this.localName.compareTo(that.localName);
/*     */     }
/*     */   }
/*     */ 
/*     */   final class StaticAttribute
/*     */     implements Comparable<StaticAttribute>
/*     */   {
/*     */     Name name;
/*     */     String value;
/*     */ 
/*     */     StaticAttribute()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void set(Name name, String value)
/*     */     {
/*  97 */       this.name = name;
/*  98 */       this.value = value;
/*     */     }
/*     */ 
/*     */     void write() throws IOException {
/* 102 */       C14nXmlOutput.this.attribute(this.name, this.value);
/*     */     }
/*     */ 
/*     */     C14nXmlOutput.DynamicAttribute toDynamicAttribute() {
/* 106 */       int nsUriIndex = this.name.nsUriIndex;
/*     */       int prefix;
/*     */       int prefix;
/* 108 */       if (nsUriIndex == -1)
/* 109 */         prefix = -1;
/*     */       else
/* 111 */         prefix = C14nXmlOutput.this.nsUriIndex2prefixIndex[nsUriIndex];
/* 112 */       return new C14nXmlOutput.DynamicAttribute(C14nXmlOutput.this, prefix, this.name.localName, this.value);
/*     */     }
/*     */ 
/*     */     public int compareTo(StaticAttribute that)
/*     */     {
/* 117 */       return this.name.compareTo(that.name);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.runtime.output.C14nXmlOutput
 * JD-Core Version:    0.6.0
 */