package antlr.preprocessor;

import antlr.collections.impl.Vector;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;

public class Tool
{
  protected Hierarchy theHierarchy;
  protected String grammarFileName;
  protected String[] args;
  protected int nargs;
  protected Vector grammars;
  protected antlr.Tool antlrTool;

  public Tool(antlr.Tool paramTool, String[] paramArrayOfString)
  {
    this.antlrTool = paramTool;
    processArguments(paramArrayOfString);
  }

  public static void main(String[] paramArrayOfString)
  {
    antlr.Tool localTool = new antlr.Tool();
    Tool localTool1 = new Tool(localTool, paramArrayOfString);
    localTool1.preprocess();
    String[] arrayOfString = localTool1.preprocessedArgList();
    for (int i = 0; i < arrayOfString.length; i++)
      System.out.print(" " + arrayOfString[i]);
    System.out.println();
  }

  public boolean preprocess()
  {
    if (this.grammarFileName == null)
    {
      this.antlrTool.toolError("no grammar file specified");
      return false;
    }
    if (this.grammars != null)
    {
      this.theHierarchy = new Hierarchy(this.antlrTool);
      Enumeration localEnumeration = this.grammars.elements();
      while (localEnumeration.hasMoreElements())
      {
        localObject = (String)localEnumeration.nextElement();
        try
        {
          this.theHierarchy.readGrammarFile((String)localObject);
        }
        catch (FileNotFoundException localFileNotFoundException)
        {
          this.antlrTool.toolError("file " + (String)localObject + " not found");
          return false;
        }
      }
    }
    boolean bool = this.theHierarchy.verifyThatHierarchyIsComplete();
    if (!bool)
      return false;
    this.theHierarchy.expandGrammarsInFile(this.grammarFileName);
    Object localObject = this.theHierarchy.getFile(this.grammarFileName);
    String str = ((GrammarFile)localObject).nameForExpandedGrammarFile(this.grammarFileName);
    if (str.equals(this.grammarFileName))
      this.args[(this.nargs++)] = this.grammarFileName;
    else
      try
      {
        ((GrammarFile)localObject).generateExpandedFile();
        this.args[(this.nargs++)] = (this.antlrTool.getOutputDirectory() + System.getProperty("file.separator") + str);
      }
      catch (IOException localIOException)
      {
        this.antlrTool.toolError("cannot write expanded grammar file " + str);
        return false;
      }
    return true;
  }

  public String[] preprocessedArgList()
  {
    String[] arrayOfString = new String[this.nargs];
    System.arraycopy(this.args, 0, arrayOfString, 0, this.nargs);
    this.args = arrayOfString;
    return this.args;
  }

  private void processArguments(String[] paramArrayOfString)
  {
    this.nargs = 0;
    this.args = new String[paramArrayOfString.length];
    for (int i = 0; i < paramArrayOfString.length; i++)
      if (paramArrayOfString[i].length() == 0)
      {
        this.antlrTool.warning("Zero length argument ignoring...");
      }
      else if (paramArrayOfString[i].equals("-glib"))
      {
        if ((File.separator.equals("\\")) && (paramArrayOfString[i].indexOf('/') != -1))
        {
          this.antlrTool.warning("-glib cannot deal with '/' on a PC: use '\\'; ignoring...");
        }
        else
        {
          this.grammars = antlr.Tool.parseSeparatedList(paramArrayOfString[(i + 1)], ';');
          i++;
        }
      }
      else if (paramArrayOfString[i].equals("-o"))
      {
        this.args[(this.nargs++)] = paramArrayOfString[i];
        if (i + 1 >= paramArrayOfString.length)
        {
          this.antlrTool.error("missing output directory with -o option; ignoring");
        }
        else
        {
          i++;
          this.args[(this.nargs++)] = paramArrayOfString[i];
          this.antlrTool.setOutputDirectory(paramArrayOfString[i]);
        }
      }
      else if (paramArrayOfString[i].charAt(0) == '-')
      {
        this.args[(this.nargs++)] = paramArrayOfString[i];
      }
      else
      {
        this.grammarFileName = paramArrayOfString[i];
        if (this.grammars == null)
          this.grammars = new Vector(10);
        this.grammars.appendElement(this.grammarFileName);
        if (i + 1 >= paramArrayOfString.length)
          continue;
        this.antlrTool.warning("grammar file must be last; ignoring other arguments...");
        break;
      }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.preprocessor.Tool
 * JD-Core Version:    0.6.0
 */