package antlr.collections.impl;

import java.io.PrintStream;
import java.util.Enumeration;

public class Vector
  implements Cloneable
{
  protected Object[] data;
  protected int lastElement = -1;

  public Vector()
  {
    this(10);
  }

  public Vector(int paramInt)
  {
    this.data = new Object[paramInt];
  }

  public synchronized void appendElement(Object paramObject)
  {
    ensureCapacity(this.lastElement + 2);
    this.data[(++this.lastElement)] = paramObject;
  }

  public int capacity()
  {
    return this.data.length;
  }

  public Object clone()
  {
    Vector localVector = null;
    try
    {
      localVector = (Vector)super.clone();
    }
    catch (CloneNotSupportedException localCloneNotSupportedException)
    {
      System.err.println("cannot clone Vector.super");
      return null;
    }
    localVector.data = new Object[size()];
    System.arraycopy(this.data, 0, localVector.data, 0, size());
    return localVector;
  }

  public synchronized Object elementAt(int paramInt)
  {
    if (paramInt >= this.data.length)
      throw new ArrayIndexOutOfBoundsException(paramInt + " >= " + this.data.length);
    if (paramInt < 0)
      throw new ArrayIndexOutOfBoundsException(paramInt + " < 0 ");
    return this.data[paramInt];
  }

  public synchronized Enumeration elements()
  {
    return new VectorEnumerator(this);
  }

  public synchronized void ensureCapacity(int paramInt)
  {
    if (paramInt + 1 > this.data.length)
    {
      Object[] arrayOfObject = this.data;
      int i = this.data.length * 2;
      if (paramInt + 1 > i)
        i = paramInt + 1;
      this.data = new Object[i];
      System.arraycopy(arrayOfObject, 0, this.data, 0, arrayOfObject.length);
    }
  }

  public synchronized boolean removeElement(Object paramObject)
  {
    for (int i = 0; (i <= this.lastElement) && (this.data[i] != paramObject); i++);
    if (i <= this.lastElement)
    {
      this.data[i] = null;
      int j = this.lastElement - i;
      if (j > 0)
        System.arraycopy(this.data, i + 1, this.data, i, j);
      this.lastElement -= 1;
      return true;
    }
    return false;
  }

  public synchronized void setElementAt(Object paramObject, int paramInt)
  {
    if (paramInt >= this.data.length)
      throw new ArrayIndexOutOfBoundsException(paramInt + " >= " + this.data.length);
    this.data[paramInt] = paramObject;
    if (paramInt > this.lastElement)
      this.lastElement = paramInt;
  }

  public int size()
  {
    return this.lastElement + 1;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.collections.impl.Vector
 * JD-Core Version:    0.6.0
 */