package antlr;

import antlr.ASdebug.ASDebugStream;
import antlr.ASdebug.IASDebugStream;
import antlr.ASdebug.TokenOffsetInfo;
import antlr.collections.Stack;
import antlr.collections.impl.LList;
import java.util.Hashtable;

public class TokenStreamSelector
  implements TokenStream, IASDebugStream
{
  protected Hashtable inputStreamNames = new Hashtable();
  protected TokenStream input;
  protected Stack streamStack = new LList();

  public void addInputStream(TokenStream paramTokenStream, String paramString)
  {
    this.inputStreamNames.put(paramString, paramTokenStream);
  }

  public TokenStream getCurrentStream()
  {
    return this.input;
  }

  public TokenStream getStream(String paramString)
  {
    TokenStream localTokenStream = (IASDebugStream)this.inputStreamNames.get(paramString);
    if (localTokenStream == null)
      throw new IllegalArgumentException("TokenStream " + paramString + " not found");
    return localTokenStream;
  }

  public Token nextToken()
    throws TokenStreamException
  {
    while (true)
      try
      {
        return this.input.nextToken();
      }
      catch (TokenStreamRetryException localTokenStreamRetryException)
      {
      }
  }

  public TokenStream pop()
  {
    TokenStream localTokenStream = (IASDebugStream)this.streamStack.pop();
    select(localTokenStream);
    return localTokenStream;
  }

  public void push(TokenStream paramTokenStream)
  {
    this.streamStack.push(this.input);
    select(paramTokenStream);
  }

  public void push(String paramString)
  {
    this.streamStack.push(this.input);
    select(paramString);
  }

  public void retry()
    throws TokenStreamRetryException
  {
    throw new TokenStreamRetryException();
  }

  public void select(TokenStream paramTokenStream)
  {
    this.input = paramTokenStream;
  }

  public void select(String paramString)
    throws IllegalArgumentException
  {
    this.input = getStream(paramString);
  }

  public String getEntireText()
  {
    return ASDebugStream.getEntireText(this.input);
  }

  public TokenOffsetInfo getOffsetInfo(Token paramToken)
  {
    return ASDebugStream.getOffsetInfo(this.input, paramToken);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.TokenStreamSelector
 * JD-Core Version:    0.6.0
 */