package antlr;

import antlr.collections.impl.BitSet;

public class TokenStreamHiddenTokenFilter extends TokenStreamBasicFilter
  implements TokenStream
{
  protected BitSet hideMask = new BitSet();
  protected CommonHiddenStreamToken nextMonitoredToken;
  protected CommonHiddenStreamToken lastHiddenToken;
  protected CommonHiddenStreamToken firstHidden = null;

  public TokenStreamHiddenTokenFilter(TokenStream paramTokenStream)
  {
    super(paramTokenStream);
  }

  protected void consume()
    throws TokenStreamException
  {
    this.nextMonitoredToken = ((CommonHiddenStreamToken)this.input.nextToken());
  }

  private void consumeFirst()
    throws TokenStreamException
  {
    consume();
    CommonHiddenStreamToken localCommonHiddenStreamToken = null;
    while ((this.hideMask.member(LA(1).getType())) || (this.discardMask.member(LA(1).getType())))
    {
      if (this.hideMask.member(LA(1).getType()))
      {
        if (localCommonHiddenStreamToken == null)
        {
          localCommonHiddenStreamToken = LA(1);
        }
        else
        {
          localCommonHiddenStreamToken.setHiddenAfter(LA(1));
          LA(1).setHiddenBefore(localCommonHiddenStreamToken);
          localCommonHiddenStreamToken = LA(1);
        }
        this.lastHiddenToken = localCommonHiddenStreamToken;
        if (this.firstHidden == null)
          this.firstHidden = localCommonHiddenStreamToken;
      }
      consume();
    }
  }

  public BitSet getDiscardMask()
  {
    return this.discardMask;
  }

  public CommonHiddenStreamToken getHiddenAfter(CommonHiddenStreamToken paramCommonHiddenStreamToken)
  {
    return paramCommonHiddenStreamToken.getHiddenAfter();
  }

  public CommonHiddenStreamToken getHiddenBefore(CommonHiddenStreamToken paramCommonHiddenStreamToken)
  {
    return paramCommonHiddenStreamToken.getHiddenBefore();
  }

  public BitSet getHideMask()
  {
    return this.hideMask;
  }

  public CommonHiddenStreamToken getInitialHiddenToken()
  {
    return this.firstHidden;
  }

  public void hide(int paramInt)
  {
    this.hideMask.add(paramInt);
  }

  public void hide(BitSet paramBitSet)
  {
    this.hideMask = paramBitSet;
  }

  protected CommonHiddenStreamToken LA(int paramInt)
  {
    return this.nextMonitoredToken;
  }

  public Token nextToken()
    throws TokenStreamException
  {
    if (LA(1) == null)
      consumeFirst();
    CommonHiddenStreamToken localCommonHiddenStreamToken1 = LA(1);
    localCommonHiddenStreamToken1.setHiddenBefore(this.lastHiddenToken);
    this.lastHiddenToken = null;
    consume();
    CommonHiddenStreamToken localCommonHiddenStreamToken2 = localCommonHiddenStreamToken1;
    while ((this.hideMask.member(LA(1).getType())) || (this.discardMask.member(LA(1).getType())))
    {
      if (this.hideMask.member(LA(1).getType()))
      {
        localCommonHiddenStreamToken2.setHiddenAfter(LA(1));
        if (localCommonHiddenStreamToken2 != localCommonHiddenStreamToken1)
          LA(1).setHiddenBefore(localCommonHiddenStreamToken2);
        localCommonHiddenStreamToken2 = this.lastHiddenToken = LA(1);
      }
      consume();
    }
    return localCommonHiddenStreamToken1;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.TokenStreamHiddenTokenFilter
 * JD-Core Version:    0.6.0
 */